/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.util.Arrays;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Interface;
import net.handle.hdllib.Util;

public class ServerInfo {
    public int serverId;
    public byte[] ipAddress;
    public byte[] publicKey;
    public Interface[] interfaces;
    private String addrString = null;
    private static final int IPV6_ONLY = 12;

    public Interface interfaceWithProtocol(int desiredProtocol, AbstractRequest req) {
        for (Interface interface1 : this.interfaces) {
            if (interface1.protocol != desiredProtocol || !interface1.canHandleRequest(req)) continue;
            return interface1;
        }
        return null;
    }

    public boolean isIPv4() {
        for (int i = 0; i < 12; ++i) {
            if (this.ipAddress[i] == 0) continue;
            return false;
        }
        return true;
    }

    public InetAddress getInetAddress() {
        if (this.ipAddress == null || this.ipAddress.length != 16) {
            throw new IllegalStateException("ServerInfo with ipAddress not 16 bytes");
        }
        try {
            if (this.isIPv4()) {
                return InetAddress.getByAddress(Arrays.copyOfRange(this.ipAddress, 12, 16));
            }
            return InetAddress.getByAddress(this.ipAddress);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getAddressString() {
        if (this.addrString != null) {
            return this.addrString;
        }
        StringBuffer sb = new StringBuffer();
        if (this.ipAddress == null) {
            return "";
        }
        if (this.isIPv4()) {
            for (int i = 12; i < this.ipAddress.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(0xFF & this.ipAddress[i]);
            }
        } else if (this.ipAddress.length == 4) {
            for (byte ipAddressByte : this.ipAddress) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(0xFF & ipAddressByte);
            }
        } else if (this.ipAddress.length != 16) {
            for (int i = 0; i < this.ipAddress.length; i += 2) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(Util.decodeHexString(this.ipAddress, i, 2, false));
            }
        } else {
            return Util.rfcIpRepr(this.ipAddress);
        }
        this.addrString = sb.toString();
        return this.addrString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.serverId);
        sb.append(' ');
        sb.append(this.getAddressString());
        sb.append(' ');
        Interface[] ifcs = this.interfaces;
        boolean hasInterfaces = false;
        for (int i = 0; ifcs != null && i < ifcs.length; ++i) {
            Interface ifc = ifcs[i];
            if (ifc == null) continue;
            if (!hasInterfaces) {
                sb.append("(");
                hasInterfaces = true;
            } else {
                sb.append(",");
            }
            sb.append(Interface.protocolName(ifc.protocol));
            sb.append('/');
            sb.append(ifc.port);
            sb.append('/');
            sb.append(Interface.typeName(ifc.type));
        }
        if (hasInterfaces) {
            sb.append(")");
        }
        return sb.toString();
    }

    public ServerInfo cloneServerInfo() {
        ServerInfo si2 = new ServerInfo();
        si2.serverId = this.serverId;
        byte[] tmp = this.ipAddress;
        if (tmp != null) {
            si2.ipAddress = new byte[tmp.length];
            System.arraycopy(tmp, 0, si2.ipAddress, 0, tmp.length);
        } else {
            si2.ipAddress = null;
        }
        tmp = this.publicKey;
        if (tmp != null) {
            si2.publicKey = new byte[tmp.length];
            System.arraycopy(tmp, 0, si2.publicKey, 0, tmp.length);
        } else {
            si2.publicKey = null;
        }
        Interface[] tmpIA = this.interfaces;
        si2.interfaces = tmpIA == null ? null : new Interface[tmpIA.length];
        for (int i = 0; tmpIA != null && i < tmpIA.length; ++i) {
            Interface tmpI = tmpIA[i];
            si2.interfaces[i] = tmpI == null ? null : tmpI.cloneInterface();
        }
        return si2;
    }

    public PublicKey getPublicKey() throws Exception {
        return Util.getPublicKeyFromBytes(this.publicKey, 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.interfaces);
        result = 31 * result + Arrays.hashCode(this.ipAddress);
        result = 31 * result + Arrays.hashCode(this.publicKey);
        result = 31 * result + this.serverId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        if (this.serverId != other.serverId) {
            return false;
        }
        if (!Arrays.equals(this.ipAddress, other.ipAddress)) {
            return false;
        }
        if (!Arrays.equals(this.publicKey, other.publicKey)) {
            return false;
        }
        return Arrays.equals(this.interfaces, other.interfaces);
    }

    public boolean hasAllZerosAddress() {
        if (this.ipAddress == null) {
            return true;
        }
        for (byte b : this.ipAddress) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

