/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public class SessionSetupInfo {
    public int keyExchangeMode = 0;
    public byte[] exchangeKeyHandle = null;
    public int exchangeKeyIndex = -1;
    public byte[] publicExchangeKey = null;
    public PrivateKey privateExchangeKey = null;
    public int timeout = 86400;
    public boolean encrypted;
    public boolean authenticated;

    public SessionSetupInfo(byte[] exchangeHandle, int exchangeIndex, PrivateKey privateKey) {
        this.exchangeKeyHandle = exchangeHandle;
        this.exchangeKeyIndex = exchangeIndex;
        this.publicExchangeKey = null;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = 3;
    }

    public SessionSetupInfo(String exchangeHandle, int exchangeIndex, PrivateKey privateKey) {
        this.exchangeKeyHandle = Util.encodeString(exchangeHandle);
        this.exchangeKeyIndex = exchangeIndex;
        this.publicExchangeKey = null;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = 3;
    }

    @Deprecated
    public SessionSetupInfo(AuthenticationInfo authInfo) {
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.keyExchangeMode = 4;
    }

    public SessionSetupInfo() {
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.keyExchangeMode = 4;
    }

    public SessionSetupInfo(int mode, byte[] exchangekey, PrivateKey privateKey) {
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = exchangekey;
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = mode;
    }

    public SessionSetupInfo(int mode, PublicKey exchangekey, PrivateKey privateKey) throws Exception {
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = Util.getBytesFromPublicKey(exchangekey);
        this.privateExchangeKey = privateKey;
        this.keyExchangeMode = mode;
    }

    public SessionSetupInfo(int mode) {
        this.keyExchangeMode = mode;
    }

    public void reset() {
        this.exchangeKeyHandle = null;
        this.exchangeKeyIndex = -1;
        this.publicExchangeKey = null;
        this.keyExchangeMode = 0;
    }

    public String toString() {
        String str = "";
        str = str + "exchange key usage " + this.keyExchangeMode;
        return str;
    }

    public synchronized void initDHKeys() throws HandleException {
        if (this.publicExchangeKey != null || this.keyExchangeMode != 4) {
            return;
        }
        try {
            KeyPair kp = HdlSecurityProvider.getInstance().generateDHKeyPair(1024);
            this.publicExchangeKey = Util.getBytesFromPublicKey(kp.getPublic());
            this.privateExchangeKey = kp.getPrivate();
        }
        catch (Exception e) {
            throw new HandleException(26, "Unable to initialize Diffie-Hellman keyPair for session", e);
        }
    }
}

