/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.Permission;
import net.handle.hdllib.trust.TrustException;

public abstract class AbstractRequiredSignerStore {
    private static HandleVerifier handleVerifier = HandleVerifier.getInstance();
    protected volatile List<JsonWebSignature> requiredSigners;

    public void loadSigners() {
    }

    public boolean needsLoadSigners() {
        return false;
    }

    protected boolean validateSelfSignedCert(JsonWebSignature cert) throws TrustException {
        HandleClaimsSet claims = handleVerifier.getHandleClaimsSet(cert);
        PublicKey publicKey = claims.publicKey;
        String issuer = claims.iss;
        String subject = claims.sub;
        if (!issuer.equals(subject)) {
            return false;
        }
        if (!claims.isDateInRange(System.currentTimeMillis() / 1000L)) {
            return false;
        }
        return cert.validates(publicKey);
    }

    public List<JsonWebSignature> getRequiredSignersAuthorizedOver(String handle) {
        List<JsonWebSignature> currentRequiredSigners = this.requiredSigners;
        ArrayList<JsonWebSignature> results = new ArrayList<JsonWebSignature>();
        for (JsonWebSignature cert : currentRequiredSigners) {
            HandleClaimsSet claims = handleVerifier.getHandleClaimsSet(cert);
            List<Permission> perms = claims.perms;
            boolean isAuthorizedOver = handleVerifier.verifyPermissionsAreAuthorizedOverHandle(handle, perms);
            if (!isAuthorizedOver) continue;
            results.add(cert);
        }
        return results;
    }
}

