/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.AbstractRequiredSignerStore;
import net.handle.hdllib.trust.ChainVerificationReport;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.IssuedSignatureVerificationReport;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.ValuesSignatureVerificationReport;

public class ChainVerifier {
    private static final String TRUST_ROOT_HANDLE = "0.0/0.0";
    private final HandleVerifier handleVerifier = new HandleVerifier();
    private final List<PublicKey> rootKeys;
    private AbstractRequiredSignerStore requiredSigners;

    public ChainVerifier(List<PublicKey> rootKeys) {
        this.rootKeys = rootKeys;
    }

    public ChainVerifier(List<PublicKey> rootKeys, AbstractRequiredSignerStore requiredSigners) {
        this.rootKeys = rootKeys;
        this.requiredSigners = requiredSigners;
    }

    public ChainVerificationReport verifyValues(String handle, List<HandleValue> values, List<IssuedSignature> issuedSignatures) {
        ValuesSignatureVerificationReport valuesReport;
        ChainVerificationReport report = new ChainVerificationReport();
        report.valuesReport = valuesReport = this.handleVerifier.verifyValues(handle, values, issuedSignatures.get((int)0).jws, issuedSignatures.get((int)0).issuerPublicKey);
        this.setChainReportValues(report, handle, issuedSignatures);
        return report;
    }

    public ChainVerificationReport verifyChain(List<IssuedSignature> issuedSignatures) {
        ChainVerificationReport report = new ChainVerificationReport();
        String handle = null;
        this.setChainReportValues(report, handle, issuedSignatures);
        return report;
    }

    private void setChainReportValues(ChainVerificationReport report, String handle, List<IssuedSignature> issuedSignatures) {
        JsonWebSignature rootSig;
        HandleClaimsSet rootClaims;
        List<JsonWebSignature> relevantRequiredSigners;
        List<IssuedSignatureVerificationReport> reports = this.checkIssuedSignatures(handle, issuedSignatures);
        report.issuedSignatureVerificationReports = reports;
        if (this.requiredSigners != null && handle != null && (relevantRequiredSigners = this.requiredSigners.getRequiredSignersAuthorizedOver(handle)) != null && !relevantRequiredSigners.isEmpty()) {
            report.chainNeedsRequiredSigner = true;
            report.chainGoodUpToRequiredSigner = this.areIssuedSignaturesTrustAndAuthorizedUpToRequiredSigner(relevantRequiredSigners, issuedSignatures, reports);
        }
        if ((rootClaims = this.handleVerifier.getHandleClaimsSet(rootSig = issuedSignatures.get((int)(issuedSignatures.size() - 1)).jws)) == null) {
            return;
        }
        if (this.isRoot(rootClaims.sub, rootClaims.publicKey)) {
            report.rootIsTrusted = true;
        }
    }

    private boolean areIssuedSignaturesTrustAndAuthorizedUpToRequiredSigner(List<JsonWebSignature> relevantRequiredSigners, List<IssuedSignature> issuedSignatures, List<IssuedSignatureVerificationReport> reports) {
        for (int i = 0; i < issuedSignatures.size(); ++i) {
            IssuedSignature sig = issuedSignatures.get(i);
            IssuedSignatureVerificationReport sigReport = reports.get(i);
            HandleClaimsSet chainClaims = this.handleVerifier.getHandleClaimsSet(sig.jws);
            for (JsonWebSignature requiredSigner : relevantRequiredSigners) {
                HandleClaimsSet requiredSignerClaims = this.handleVerifier.getHandleClaimsSet(requiredSigner);
                if (!Util.equalsPrefixCI(requiredSignerClaims.sub, chainClaims.iss) || !requiredSignerClaims.publicKey.equals(sig.issuerPublicKey)) continue;
                return true;
            }
            if (sigReport.canTrustAndAuthorized()) continue;
            return false;
        }
        return false;
    }

    private List<IssuedSignatureVerificationReport> checkIssuedSignatures(String handle, List<IssuedSignature> issuedSignatures) {
        ArrayList<IssuedSignatureVerificationReport> result = new ArrayList<IssuedSignatureVerificationReport>();
        for (IssuedSignature issuedSignature : issuedSignatures) {
            IssuedSignatureVerificationReport report = this.handleVerifier.verifyIssuedSignature(handle, issuedSignature);
            result.add(report);
        }
        return result;
    }

    private boolean isRoot(String subject, PublicKey publicKey) {
        if (this.rootKeys == null) {
            System.err.println("Error missing root keys.");
        }
        return Util.equalsPrefixCI(TRUST_ROOT_HANDLE, ValueReference.fromString(subject).getHandleAsString()) && this.rootKeys.contains(publicKey);
    }
}

