/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.trust.ChainVerificationReport;

public class HandleRecordTrustVerificationReport {
    public boolean noSignatures;
    public boolean exceptionParsingSignature;
    public List<ChainVerificationReport> signatureReports = new ArrayList<ChainVerificationReport>();
    public List<Integer> signedValues = new ArrayList<Integer>();
    public List<Integer> unsignedValues = new ArrayList<Integer>();
    public boolean requiredSignerNeeded;
    public List<Integer> valuesSignedUpToRequiredSigner = new ArrayList<Integer>();
    public List<Integer> valuesNotSignedUpToRequiredSigner = new ArrayList<Integer>();
    public List<Exception> exceptions = new ArrayList<Exception>();

    public String getErrorMessage() {
        if (this.noSignatures) {
            return "no signatures";
        }
        if (this.exceptionParsingSignature) {
            return "exception parsing signature";
        }
        for (ChainVerificationReport chainReport : this.signatureReports) {
            if (chainReport.unableToBuildChain) {
                return "unable to build chain";
            }
            if (!chainReport.valuesReport.correctHandle) {
                return "incorrect handle";
            }
            if (!chainReport.valuesReport.validPayload) {
                return "invalid signature payload";
            }
            if (!chainReport.valuesReport.signatureVerifies) {
                return "signature does not verify";
            }
            if (!chainReport.valuesReport.dateInRange) {
                return "incorrect date range in signature";
            }
            if (!chainReport.valuesReport.badDigestValues.isEmpty()) {
                return "bad digests";
            }
            if (!chainReport.valuesReport.missingValues.isEmpty()) {
                return "missing values";
            }
            if (chainReport.canTrust()) continue;
            return "chain not trusted";
        }
        if (!this.unsignedValues.isEmpty()) {
            return "unsigned values";
        }
        if (this.requiredSignerNeeded && !this.valuesNotSignedUpToRequiredSigner.isEmpty()) {
            return "values not signed up to requiredSigners";
        }
        return null;
    }
}

