/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.DigestedHandleValues;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleValueDigester;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.Permission;
import net.handle.hdllib.trust.RemoteJsonWebSignatureSigner;
import net.handle.hdllib.trust.TrustException;

public class HandleSigner {
    private static HandleSigner INSTANCE = new HandleSigner();

    public static HandleSigner getInstance() {
        return INSTANCE;
    }

    public HandleClaimsSet createPayload(String handleToSign, List<HandleValue> valuesToSign, ValueReference signer, List<String> chain, long notBefore, long expiration) {
        DigestedHandleValues digests;
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = handleToSign;
        claims.iss = signer != null ? signer.toString() : "";
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = notBefore;
        claims.exp = expiration;
        claims.chain = chain;
        try {
            digests = new HandleValueDigester().digest(valuesToSign, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        claims.digests = digests;
        return claims;
    }

    public JsonWebSignature signClaims(HandleClaimsSet claims, PrivateKey privateKey) throws TrustException {
        String payload = GsonUtility.getGson().toJson((Object)claims);
        JsonWebSignature jws = JsonWebSignatureFactory.getInstance().create(payload, privateKey);
        return jws;
    }

    public JsonWebSignature signClaimsRemotely(HandleClaimsSet claims, String baseUri, String username, String password, String privateKeyId, String privateKeyPassphrase) throws TrustException {
        String payloadString = GsonUtility.getGson().toJson((Object)claims);
        RemoteJsonWebSignatureSigner remoteSigner = new RemoteJsonWebSignatureSigner(baseUri);
        JsonWebSignature jws = remoteSigner.create(payloadString, username, password, privateKeyId, privateKeyPassphrase);
        return jws;
    }

    public JsonWebSignature signHandleValues(String handleToSign, List<HandleValue> valuesToSign, ValueReference signer, PrivateKey privateKey, List<String> chain, long notBefore, long expiration) throws TrustException {
        DigestedHandleValues digests;
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = handleToSign;
        claims.iss = signer.toString();
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = notBefore;
        claims.exp = expiration;
        claims.chain = chain;
        try {
            digests = new HandleValueDigester().digest(valuesToSign, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        claims.digests = digests;
        JsonWebSignature jws = this.signClaims(claims, privateKey);
        return jws;
    }

    public JsonWebSignature signHandleValuesRemotely(String handleToSign, List<HandleValue> valuesToSign, ValueReference signer, List<String> chain, long notBefore, long expiration, String baseUri, String username, String password, String privateKeyId, String privateKeyPassphrase) throws TrustException {
        DigestedHandleValues digests;
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = handleToSign;
        claims.iss = signer.toString();
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = notBefore;
        claims.exp = expiration;
        claims.chain = chain;
        try {
            digests = new HandleValueDigester().digest(valuesToSign, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        claims.digests = digests;
        JsonWebSignature jws = this.signClaimsRemotely(claims, baseUri, username, password, privateKeyId, privateKeyPassphrase);
        return jws;
    }

    public JsonWebSignature signPermissions(ValueReference subject, PublicKey subjectPublicKey, List<Permission> permissions, ValueReference signer, PrivateKey privateKey, List<String> chain, long notBefore, long expiration) throws TrustException {
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = subject.toString();
        claims.iss = signer.toString();
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = notBefore;
        claims.exp = expiration;
        claims.chain = chain;
        claims.perms = permissions;
        claims.publicKey = subjectPublicKey;
        JsonWebSignature jws = this.signClaims(claims, privateKey);
        return jws;
    }

    public JsonWebSignature signPermissionsRemotely(ValueReference subject, PublicKey subjectPublicKey, List<Permission> permissions, ValueReference signer, List<String> chain, long notBefore, long expiration, String baseUri, String username, String password, String privateKeyId, String privateKeyPassphrase) throws TrustException {
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = subject.toString();
        claims.iss = signer.toString();
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = notBefore;
        claims.exp = expiration;
        claims.chain = chain;
        claims.perms = permissions;
        claims.publicKey = subjectPublicKey;
        JsonWebSignature jws = this.signClaimsRemotely(claims, baseUri, username, password, privateKeyId, privateKeyPassphrase);
        return jws;
    }
}

