/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.trust.DigestedHandleValues;
import org.apache.commons.codec.binary.Base64;

public class HandleValueDigester {
    private static final int VALUE_DIGEST_OFFSET = 8;

    public DigestedHandleValues digest(List<HandleValue> values, String alg) throws NoSuchAlgorithmException {
        ArrayList<DigestedHandleValues.DigestedHandleValue> digests = new ArrayList<DigestedHandleValues.DigestedHandleValue>();
        MessageDigest digester = MessageDigest.getInstance(alg);
        for (HandleValue value : values) {
            DigestedHandleValues.DigestedHandleValue digest = this.digest(value, digester);
            digests.add(digest);
        }
        DigestedHandleValues result = new DigestedHandleValues();
        result.alg = alg;
        result.digests = digests;
        return result;
    }

    private DigestedHandleValues.DigestedHandleValue digest(HandleValue value, MessageDigest digester) {
        byte[] digestBytes = this.digestHandleValue(value, digester);
        DigestedHandleValues.DigestedHandleValue result = new DigestedHandleValues.DigestedHandleValue();
        result.digest = Base64.encodeBase64String((byte[])digestBytes);
        result.index = value.getIndex();
        return result;
    }

    private byte[] digestHandleValue(HandleValue value, MessageDigest digester) {
        digester.reset();
        byte[] encodedHandleValue = Encoder.encodeHandleValue(value);
        digester.update(encodedHandleValue, 8, encodedHandleValue.length - 8);
        byte[] digestBytes = digester.digest();
        return digestBytes;
    }

    public boolean verify(DigestedHandleValues digestedValues, List<HandleValue> values) throws NoSuchAlgorithmException {
        HashMap<Integer, HandleValue> indexOfValues = new HashMap<Integer, HandleValue>();
        for (HandleValue value : values) {
            indexOfValues.put(value.getIndex(), value);
        }
        if (indexOfValues.size() != digestedValues.digests.size()) {
            return false;
        }
        MessageDigest digester = MessageDigest.getInstance(digestedValues.alg);
        for (DigestedHandleValues.DigestedHandleValue digestedHandleValue : digestedValues.digests) {
            HandleValue value = (HandleValue)indexOfValues.get(digestedHandleValue.index);
            if (value == null) {
                return false;
            }
            byte[] digestBytes = this.digestHandleValue(value, digester);
            String digestAsBase64 = Base64.encodeBase64String((byte[])digestBytes);
            if (digestedHandleValue.digest.equals(digestAsBase64)) continue;
            return false;
        }
        return true;
    }
}

