/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.IOException;
import java.io.Writer;

public class AsciiJsonWriter
extends Writer {
    private final Writer writer;

    public AsciiJsonWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int start = off;
        for (int i = off; i < off + len; ++i) {
            char ch = cbuf[i];
            if (cbuf[i] <= '\u007f') continue;
            if (start < i) {
                this.writer.write(cbuf, start, i - start);
            }
            this.jsonEncode(ch);
            start = i + 1;
        }
        if (start < off + len) {
            this.writer.write(cbuf, start, off + len - start);
        }
    }

    private void jsonEncode(char ch) throws IOException {
        this.writer.write("\\u");
        String s = Integer.toHexString(ch);
        for (int i = s.length(); i < 4; ++i) {
            this.writer.write(48);
        }
        this.writer.write(s);
    }
}

