/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.codec;

import java.nio.charset.StandardCharsets;

public abstract class Base64 {
    protected static final String STANDARD = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    protected static final String URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    protected static final String ORDERED = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";

    public static String base64Encode(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        byte[] b = null;
        b = s.getBytes(StandardCharsets.UTF_8);
        return Base64.base64EncodeFoArray(b);
    }

    public static String base64EncodeFoArray(byte[] s) {
        if (s == null) {
            return null;
        }
        if (s.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = s.length;
        int i = 0;
        while (i < len) {
            int b3;
            int b2;
            byte tmp = s[i++];
            int b0 = (tmp & 0xFC) >> 2;
            int b1 = (tmp & 3) << 4;
            if (i < len) {
                tmp = s[i++];
                b1 |= (tmp & 0xF0) >> 4;
                b2 = (tmp & 0xF) << 2;
                if (i < len) {
                    tmp = s[i++];
                    b2 |= (tmp & 0xC0) >> 6;
                    b3 = tmp & 0x3F;
                } else {
                    b3 = 64;
                }
            } else {
                b3 = 64;
                b2 = 64;
            }
            buf.append(STANDARD.charAt(b0));
            buf.append(STANDARD.charAt(b1));
            buf.append(STANDARD.charAt(b2));
            buf.append(STANDARD.charAt(b3));
        }
        return buf.toString();
    }

    public static String base64Decode(String s) {
        byte[] b = Base64.base64DecodeToArray(s);
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return "";
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    public static byte[] base64DecodeToArray(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return new byte[0];
        }
        if (len % 4 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] b = new byte[len / 4 * 3];
        int i = 0;
        int j = 0;
        int e = 0;
        while (i < len) {
            int c = STANDARD.indexOf(s.charAt(i++));
            int tmp = c << 18;
            c = STANDARD.indexOf(s.charAt(i++));
            tmp |= c << 12;
            if ((c = STANDARD.indexOf(s.charAt(i++))) < 64) {
                tmp |= c << 6;
                if ((c = STANDARD.indexOf(s.charAt(i++))) < 64) {
                    tmp |= c;
                } else {
                    e = 1;
                }
            } else {
                e = 2;
                ++i;
            }
            b[j + 2] = (byte)(tmp & 0xFF);
            b[j + 1] = (byte)((tmp >>= 8) & 0xFF);
            b[j + 0] = (byte)((tmp >>= 8) & 0xFF);
            j += 3;
        }
        if (e != 0) {
            len = b.length - e;
            byte[] copy = new byte[len];
            System.arraycopy(b, 0, copy, 0, len);
            return copy;
        }
        return b;
    }
}

