/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.util.function.Predicate;
import net.hasor.cobble.loader.ClassMatcher;

public class ClassMatchers {
    private ClassMatchers() {
    }

    public static Predicate<?> any() {
        return t -> true;
    }

    public static ClassMatcher featureWith(Class<?> annotationType) {
        String featureType = annotationType.getName();
        return context -> {
            ClassMatcher.ClassInfo classInfo = context.getClassInfo();
            for (String castType : classInfo.castType) {
                if (!castType.equals(featureType)) continue;
                return true;
            }
            for (String face : classInfo.annos) {
                if (!face.equals(featureType)) continue;
                return true;
            }
            return false;
        };
    }

    public static ClassMatcher annotatedWith(Class<?> annotationType) {
        String featureType = annotationType.getName();
        return context -> {
            ClassMatcher.ClassInfo classInfo = context.getClassInfo();
            for (String face : classInfo.annos) {
                if (!face.equals(featureType)) continue;
                return true;
            }
            return false;
        };
    }

    public static ClassMatcher subClassesOf(Class<?> superclass) {
        String testType = superclass.getName();
        return context -> {
            ClassMatcher.ClassInfo classInfo = context.getClassInfo();
            if (classInfo.className.equals(testType)) {
                return false;
            }
            for (String castType : classInfo.castType) {
                if (!castType.equals(testType)) continue;
                return true;
            }
            return false;
        };
    }
}

