/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;

public interface ResourceLoader {
    default public <T> List<T> scanResources(Scanner<T> scanner) throws IOException {
        return this.scanResources(MatchType.None, scanner, new String[0]);
    }

    default public <T> List<T> scanResources(MatchType matchType, Scanner<T> scanner) throws IOException {
        return this.scanResources(matchType, scanner, new String[0]);
    }

    public <T> List<T> scanResources(MatchType var1, Scanner<T> var2, String[] var3) throws IOException;

    default public <T> T scanOneResource(Scanner<T> scanner) throws IOException {
        return this.scanOneResource(MatchType.None, scanner, new String[0]);
    }

    default public <T> T scanOneResource(MatchType matchType, Scanner<T> scanner) throws IOException {
        return this.scanOneResource(matchType, scanner, new String[0]);
    }

    public <T> T scanOneResource(MatchType var1, Scanner<T> var2, String[] var3) throws IOException;

    public URL getResource(String var1) throws IOException;

    public InputStream getResourceAsStream(String var1) throws IOException;

    public Class<?> getClass(String var1) throws ClassNotFoundException;

    public List<URL> getResources(String var1) throws IOException;

    public List<InputStream> getResourcesAsStream(String var1) throws IOException;

    public boolean exist(String var1);

    public static enum MatchType {
        None,
        Prefix,
        ContainsAny,
        Suffix,
        Match,
        Regex;

    }

    public static interface Scanner<T> {
        public T found(ScanEvent var1) throws IOException;
    }

    public static class ScanEvent {
        private final String name;
        private final long size;
        private final URI resource;
        private final InputStreamGet streamGetter;

        public ScanEvent(String name, long size, URI resource, InputStreamGet streamGetter) {
            this.name = name;
            this.size = size;
            this.resource = resource;
            this.streamGetter = streamGetter;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public URI getResource() {
            return this.resource;
        }

        public InputStream getStream() throws IOException {
            return this.streamGetter.getStream();
        }
    }

    public static interface InputStreamGet {
        public InputStream getStream() throws IOException;
    }
}

