/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.SystemUtils;
import net.hasor.cobble.io.FileUtils;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.jar.JarFile;
import net.hasor.cobble.logging.Logger;

public class ClassPathResourceLoader
extends AbstractResourceLoader {
    private static final Logger logger = Logger.getLogger(ClassPathResourceLoader.class);
    public static ResourceLoader INSTANCE = new ClassPathResourceLoader();
    private final ClassLoader classLoader;
    private final List<URL> classpath;
    private final String[] ZIP_TYPES = new String[]{".jar", ".JAR", ".zip", ".ZIP"};

    public ClassPathResourceLoader() {
        super(Thread.currentThread().getContextClassLoader());
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.classpath = this.getClassPath(this.classLoader);
    }

    public ClassPathResourceLoader(ClassLoader parent) {
        super(parent);
        this.classLoader = Objects.requireNonNull(parent);
        this.classpath = this.getClassPath(this.classLoader);
    }

    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    protected List<URL> getClassPath(ClassLoader classLoader) {
        return ClassUtils.getClassPath(classLoader);
    }

    private String formatResourcePath(String resourcePath) {
        if ((resourcePath = resourcePath.replaceAll("/{2}", "/")).charAt(0) == '/') {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    @Override
    public URL getResource(String resource) throws IOException {
        return this.classLoader.getResource(this.formatResourcePath(resource));
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        return this.classLoader.getResourceAsStream(this.formatResourcePath(resource));
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        resource = this.formatResourcePath(resource);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(resource);
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        resource = this.formatResourcePath(resource);
        ArrayList<InputStream> ins = new ArrayList<InputStream>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(resource);
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            InputStream in = url != null ? url.openStream() : null;
            if (in == null) continue;
            ins.add(in);
        }
        return ins;
    }

    @Override
    public boolean exist(String resource) {
        return this.classLoader.getResource(this.formatResourcePath(resource)) != null;
    }

    @Override
    public <T> List<T> scanResources(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<JarEntry>[] testJar = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
        Predicate<String>[] testDir = this.buildPredicate(matchType, scanPaths, s -> s);
        for (URL url : this.classpath) {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File contextDir = FileUtils.toFile(url);
                if (contextDir == null || !contextDir.exists()) continue;
                if (contextDir.isDirectory()) {
                    ClassPathResourceLoader.dirScan(result, contextDir, contextDir, testDir, scanner, false);
                    continue;
                }
                String jarName = contextDir.getName();
                if (!StringUtils.endsWithAny(jarName, this.ZIP_TYPES)) continue;
                try {
                    JarFile jarFile = new JarFile(contextDir);
                    ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, false);
                }
                catch (Exception e) {
                    logger.error("cannot open jar (" + jarName + ") " + e.getMessage(), e);
                }
                continue;
            }
            if (!protocol.equals("jar")) continue;
            JarURLConnection jarc = (JarURLConnection)url.openConnection();
            java.util.jar.JarFile jarFile = jarc.getJarFile();
            ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, false);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<JarEntry>[] testJar = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
        Predicate<String>[] testDir = this.buildPredicate(matchType, scanPaths, s -> s);
        for (URL url : this.classpath) {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File contextDir = FileUtils.toFile(url);
                if (contextDir == null || !contextDir.exists()) continue;
                if (contextDir.isDirectory()) {
                    ClassPathResourceLoader.dirScan(result, contextDir, contextDir, testDir, scanner, true);
                } else {
                    String jarName = contextDir.getName();
                    if (!StringUtils.endsWithAny(jarName, this.ZIP_TYPES)) continue;
                    try {
                        JarFile jarFile = new JarFile(contextDir);
                        ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, true);
                    }
                    catch (Exception e) {
                        logger.error("cannot open jar (" + jarName + ") " + e.getMessage(), e);
                    }
                }
            } else if (protocol.equals("jar")) {
                JarURLConnection jarc = (JarURLConnection)url.openConnection();
                java.util.jar.JarFile jarFile = jarc.getJarFile();
                ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, true);
            }
            if (result.isEmpty()) continue;
            return (T)result.get(0);
        }
        return null;
    }

    private static <T> void jarScan(List<T> result, java.util.jar.JarFile jarFile, Predicate<JarEntry>[] jarTest, ResourceLoader.Scanner<T> scanner, boolean matchOnce) throws IOException {
        URL content = new File(jarFile.getName()).toURI().toURL();
        Iterator zipEntry = jarFile.stream().iterator();
        while (zipEntry.hasNext()) {
            JarEntry entry = (JarEntry)zipEntry.next();
            if (!ClassPathResourceLoader.jarTestFound(entry, jarTest)) continue;
            try {
                URI uri = new URL("jar:" + content + "!/" + entry.getName()).toURI();
                ResourceLoader.InputStreamGet inputStream = () -> jarFile.getInputStream(entry);
                T res = scanner.found(new ResourceLoader.ScanEvent(entry.getName(), entry.getSize(), uri, inputStream));
                if (res != null) {
                    result.add(res);
                }
            }
            catch (URISyntaxException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("scanJarFile :" + e.getMessage(), e);
                }
                logger.debug("scanJarFile :" + e.getMessage());
            }
            if (!matchOnce || result.isEmpty()) continue;
            return;
        }
    }

    private static boolean jarTestFound(JarEntry entry, Predicate<JarEntry>[] jarTest) {
        if (jarTest == null || jarTest.length == 0) {
            return true;
        }
        for (Predicate<JarEntry> predicate : jarTest) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private static <T> void dirScan(List<T> result, File contextDir, File curFile, Predicate<String>[] testDir, ResourceLoader.Scanner<T> scanner, boolean matchOnce) throws IOException {
        if (matchOnce && !result.isEmpty()) {
            return;
        }
        File[] listFiles = curFile.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File fileItem : listFiles) {
            if (matchOnce && !result.isEmpty()) {
                return;
            }
            if (fileItem.isHidden() || !fileItem.exists()) continue;
            if (fileItem.isDirectory()) {
                ClassPathResourceLoader.dirScan(result, contextDir, fileItem, testDir, scanner, matchOnce);
                continue;
            }
            String resourceName = fileItem.getAbsolutePath().substring(contextDir.getAbsolutePath().length() + 1);
            if (SystemUtils.isWindows()) {
                resourceName = StringUtils.replace(resourceName, File.separator, "/");
            }
            if (!ClassPathResourceLoader.dirTestFound(resourceName, testDir)) continue;
            ResourceLoader.InputStreamGet inputStream = () -> {
                if (fileItem.canRead()) {
                    return Files.newInputStream(fileItem.toPath(), new OpenOption[0]);
                }
                throw new IOException("file cannot be read :" + fileItem);
            };
            T res = scanner.found(new ResourceLoader.ScanEvent(resourceName, fileItem.length(), fileItem.toURI(), inputStream));
            if (res == null) continue;
            result.add(res);
        }
    }

    private static boolean dirTestFound(String entry, Predicate<String>[] dirTest) {
        if (dirTest == null || dirTest.length == 0) {
            return true;
        }
        for (Predicate<String> predicate : dirTest) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }
}

