/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.sandbox;

import java.security.Permission;
import net.hasor.cobble.loader.sandbox.SecPolicyContext;

class SecSandbox
extends SecurityManager {
    private final SecurityManager parent;

    public SecSandbox(SecurityManager parent) {
        this.parent = parent;
    }

    private SecPolicyContext findPolicyContext() {
        Class<?>[] context;
        for (Class<?> atClass : context = this.getClassContext()) {
            if (!(atClass.getClassLoader() instanceof SecPolicyContext)) continue;
            return (SecPolicyContext)((Object)atClass.getClassLoader());
        }
        return null;
    }

    @Override
    public void checkPermission(Permission perm) {
        SecPolicyContext policyContext = this.findPolicyContext();
        if (policyContext != null && policyContext.enable()) {
            policyContext.checkPermission(perm);
            return;
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm);
        } else {
            super.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        SecPolicyContext policyContext = this.findPolicyContext();
        if (policyContext != null && policyContext.enable()) {
            policyContext.checkPermission(perm);
            return;
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm, context);
        } else {
            super.checkPermission(perm);
        }
    }
}

