/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.FilenameUtils;
import net.hasor.cobble.setting.SettingNode;
import net.hasor.cobble.setting.Settings;

public abstract class AbstractSettings
implements Settings {
    protected abstract Map<String, String> envMap();

    public abstract <T> T getToType(String var1, Class<T> var2, T var3);

    public abstract <T> T[] getToTypeArray(String var1, Class<T> var2, T var3);

    public <T> T[] getToTypeArray(String name, Class<T> toType) {
        return this.getToTypeArray(name, toType, null);
    }

    public final <T> T getToType(String name, Class<T> toType) {
        return this.getToType(name, toType, null);
    }

    public Object getObject(String name) {
        return this.getToType(name, Object.class);
    }

    public Object getObject(String name, Object defaultValue) {
        return this.getToType(name, Object.class, defaultValue);
    }

    @Override
    public Character getChar(String name) {
        return this.getToType(name, Character.class);
    }

    @Override
    public Character getChar(String name, Character defaultValue) {
        return this.getToType(name, Character.class, defaultValue);
    }

    @Override
    public Character[] getCharArray(String name) {
        return this.getToTypeArray(name, Character.class);
    }

    @Override
    public Character[] getCharArray(String name, Character defaultValue) {
        return this.getToTypeArray(name, Character.class, defaultValue);
    }

    @Override
    public String getString(String name) {
        return this.getToType(name, String.class);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getToType(name, String.class, defaultValue);
    }

    @Override
    public String[] getStringArray(String name) {
        return this.getToTypeArray(name, String.class);
    }

    @Override
    public String[] getStringArray(String name, String defaultValue) {
        return this.getToTypeArray(name, String.class, defaultValue);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.getToType(name, Boolean.class);
    }

    @Override
    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getToType(name, Boolean.class, defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String name) {
        return this.getToTypeArray(name, Boolean.class);
    }

    @Override
    public Boolean[] getBooleanArray(String name, Boolean defaultValue) {
        return this.getToTypeArray(name, Boolean.class, defaultValue);
    }

    @Override
    public Short getShort(String name) {
        return this.getToType(name, Short.class);
    }

    @Override
    public Short getShort(String name, Short defaultValue) {
        return this.getToType(name, Short.class, defaultValue);
    }

    @Override
    public Short[] getShortArray(String name) {
        return this.getToTypeArray(name, Short.class);
    }

    @Override
    public Short[] getShortArray(String name, Short defaultValue) {
        return this.getToTypeArray(name, Short.class, defaultValue);
    }

    @Override
    public Integer getInteger(String name) {
        return this.getToType(name, Integer.class);
    }

    @Override
    public Integer getInteger(String name, Integer defaultValue) {
        return this.getToType(name, Integer.class, defaultValue);
    }

    @Override
    public Integer[] getIntegerArray(String name) {
        return this.getToTypeArray(name, Integer.class);
    }

    @Override
    public Integer[] getIntegerArray(String name, Integer defaultValue) {
        return this.getToTypeArray(name, Integer.class, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        return this.getToType(name, Long.class);
    }

    @Override
    public Long getLong(String name, Long defaultValue) {
        return this.getToType(name, Long.class, defaultValue);
    }

    @Override
    public Long[] getLongArray(String name) {
        return this.getToTypeArray(name, Long.class);
    }

    @Override
    public Long[] getLongArray(String name, Long defaultValue) {
        return this.getToTypeArray(name, Long.class, defaultValue);
    }

    @Override
    public Float getFloat(String name) {
        return this.getToType(name, Float.class);
    }

    @Override
    public Float getFloat(String name, Float defaultValue) {
        return this.getToType(name, Float.class, defaultValue);
    }

    @Override
    public Float[] getFloatArray(String name) {
        return this.getToTypeArray(name, Float.class);
    }

    @Override
    public Float[] getFloatArray(String name, Float defaultValue) {
        return this.getToTypeArray(name, Float.class, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        return this.getToType(name, Double.class);
    }

    @Override
    public Double getDouble(String name, Double defaultValue) {
        return this.getToType(name, Double.class, defaultValue);
    }

    @Override
    public Double[] getDoubleArray(String name) {
        return this.getToTypeArray(name, Double.class);
    }

    @Override
    public Double[] getDoubleArray(String name, Double defaultValue) {
        return this.getToTypeArray(name, Double.class, defaultValue);
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(name, this.getString(name + ".format"), null);
    }

    @Override
    public Date getDate(String name, Date defaultValue) {
        return this.getDate(name, this.getString(name + ".format"), defaultValue);
    }

    @Override
    public Date getDate(String name, long defaultValue) {
        return this.getDate(name, this.getString(name + ".format"), new Date(defaultValue));
    }

    @Override
    public Date getDate(String name, String format) {
        return this.getDate(name, format, null);
    }

    @Override
    public Date getDate(String name, String format, long defaultValue) {
        return this.getDate(name, format, new Date(defaultValue));
    }

    @Override
    public Date getDate(String name, String format, Date defaultValue) {
        String oriData = this.getToType(name, String.class);
        if (oriData == null || oriData.length() == 0) {
            return defaultValue;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        dateFormat.setLenient(false);
        Date parsedDate = ((DateFormat)dateFormat).parse(oriData, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != oriData.length() || parsedDate == null) {
            return defaultValue;
        }
        return parsedDate;
    }

    @Override
    public Date[] getDateArray(String name) {
        return this.getDateArray(name, this.getString(name + ".format"), null);
    }

    @Override
    public Date[] getDateArray(String name, Date defaultValue) {
        return this.getDateArray(name, this.getString(name + ".format"), defaultValue);
    }

    @Override
    public Date[] getDateArray(String name, long defaultValue) {
        return this.getDateArray(name, this.getString(name + ".format"), new Date(defaultValue));
    }

    @Override
    public Date[] getDateArray(String name, String format) {
        return this.getDateArray(name, format, null);
    }

    @Override
    public Date[] getDateArray(String name, String format, long defaultValue) {
        return this.getDateArray(name, format, new Date(defaultValue));
    }

    @Override
    public Date[] getDateArray(String name, String format, Date defaultValue) {
        String[] oriDataArray = this.getToTypeArray(name, String.class);
        if (oriDataArray == null || oriDataArray.length == 0) {
            return new Date[0];
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        Date[] parsedDate = new Date[oriDataArray.length];
        for (int i = 0; i < oriDataArray.length; ++i) {
            String oriData = oriDataArray[i];
            ParsePosition pos = new ParsePosition(0);
            parsedDate[i] = ((DateFormat)dateFormat).parse(oriData, pos);
            if (pos.getErrorIndex() < 0 && pos.getIndex() == oriData.length() && parsedDate[i] != null) continue;
            parsedDate[i] = defaultValue == null ? null : new Date(defaultValue.getTime());
        }
        return parsedDate;
    }

    @Override
    public <T extends Enum<?>> T getEnum(String name, Class<T> enmType) {
        return (T)((Enum)this.getToType(name, enmType, null));
    }

    @Override
    public <T extends Enum<?>> T getEnum(String name, Class<T> enmType, T defaultValue) {
        return (T)((Enum)this.getToType(name, enmType, defaultValue));
    }

    @Override
    public <T extends Enum<?>> T[] getEnumArray(String name, Class<T> enmType) {
        return this.getToTypeArray(name, enmType, null);
    }

    @Override
    public <T extends Enum<?>> T[] getEnumArray(String name, Class<T> enmType, T defaultValue) {
        return (Enum[])this.getToTypeArray(name, enmType, defaultValue);
    }

    @Override
    public String getFilePath(String name) {
        return this.getFilePath(name, null, true);
    }

    @Override
    public String getFilePath(String name, String defaultValue) {
        return this.getFilePath(name, defaultValue, true);
    }

    @Override
    public String getDirectoryPath(String name) {
        return this.getFilePath(name, null, false);
    }

    @Override
    public String getDirectoryPath(String name, String defaultValue) {
        return this.getFilePath(name, defaultValue, false);
    }

    @Override
    public String[] getFilePathArray(String name) {
        return this.getFilePathArray(name, null, true);
    }

    @Override
    public String[] getFilePathArray(String name, String defaultValue) {
        return this.getFilePathArray(name, defaultValue, true);
    }

    @Override
    public String[] getDirectoryPathArray(String name) {
        return this.getFilePathArray(name, null, false);
    }

    @Override
    public String[] getDirectoryPathArray(String name, String defaultValue) {
        return this.getFilePathArray(name, defaultValue, false);
    }

    private String getFilePath(String name, String defaultValue, boolean includeName) {
        String filePath = this.getToType(name, String.class);
        if (StringUtils.isBlank(filePath)) {
            return defaultValue;
        }
        if (includeName) {
            String fileName = FilenameUtils.getName(filePath);
            if (StringUtils.isNotBlank(fileName)) {
                return FilenameUtils.getFullPath(filePath) + FilenameUtils.getName(filePath);
            }
            return StringUtils.isBlank(defaultValue) ? null : defaultValue;
        }
        return FilenameUtils.getFullPath(filePath);
    }

    private String[] getFilePathArray(String name, String defaultValue, boolean includeName) {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (String url : this.getSettingArray()) {
            Settings targetSettings = this.getSettings(url);
            String filePath = targetSettings.getString(name);
            if (StringUtils.isBlank(filePath)) continue;
            if (includeName) {
                String fileName = FilenameUtils.getName(filePath);
                if (!StringUtils.isNotBlank(fileName)) continue;
                filePaths.add(FilenameUtils.getFullPath(filePath) + FilenameUtils.getName(filePath));
                continue;
            }
            filePaths.add(FilenameUtils.getFullPath(filePath));
        }
        return filePaths.toArray(new String[0]);
    }

    @Override
    public SettingNode getNode(String name) {
        return this.getToType(name, SettingNode.class, null);
    }

    @Override
    public SettingNode[] getNodeArray(String name) {
        return this.getToTypeArray(name, SettingNode.class, null);
    }

    @Override
    public String[] getEnvNames() {
        return this.envMap().keySet().toArray(new String[0]);
    }

    @Override
    public String getEnv(String name) {
        return this.envMap().get(name);
    }

    @Override
    public void addEnv(String name, String value) {
        this.envMap().put(name, value);
    }

    @Override
    public void removeEnv(String name) {
        this.envMap().remove(name);
    }

    public String toString() {
        return "Settings[" + this.getClass().getSimpleName() + "]";
    }
}

