/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.setting.MergedSettings;
import net.hasor.cobble.setting.provider.StreamType;

public class DefaultSettings
extends MergedSettings {
    private String resource;

    public DefaultSettings() throws IOException {
        this.refresh();
    }

    public DefaultSettings(String mainSettings) throws IOException {
        if (StringUtils.isNotBlank(mainSettings)) {
            this.resource = mainSettings;
            this.loadSettings();
        }
        this.refresh();
    }

    public DefaultSettings(File mainSettings) throws IOException {
        if (mainSettings != null) {
            this.resource = mainSettings.toURI().toURL().toString();
            this.loadSettings();
        }
        this.refresh();
    }

    public DefaultSettings(URI mainSettings) throws IOException {
        if (mainSettings != null) {
            this.resource = mainSettings.toURL().toString();
            this.loadSettings();
        }
        this.refresh();
    }

    @Override
    protected void loadSettings() throws IOException {
        super.loadSettings();
        if (StringUtils.isNotBlank(this.resource)) {
            try (InputStream stream = ResourcesUtils.getResourceAsStream(this.resource);){
                if (stream != null) {
                    String lowerCase = this.resource.toLowerCase();
                    if (lowerCase.endsWith(".xml")) {
                        this.loadStream(stream, StreamType.Xml);
                    } else if (lowerCase.endsWith(".yaml") || lowerCase.endsWith(".yml")) {
                        this.loadStream(stream, StreamType.Yaml);
                    } else {
                        this.loadStream(stream, StreamType.Properties);
                    }
                }
            }
        }
        super.loadSettings();
    }
}

