/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.io.input.AutoCloseInputStream;
import net.hasor.cobble.io.input.AutoCloseReader;
import net.hasor.cobble.setting.BasicSettings;
import net.hasor.cobble.setting.IOSettings;
import net.hasor.cobble.setting.provider.SettingsReader;
import net.hasor.cobble.setting.provider.StreamType;
import net.hasor.cobble.setting.provider.properties.PropertiesSettingsReader;
import net.hasor.cobble.setting.provider.xml.XmlSettingsReader;
import net.hasor.cobble.setting.provider.yaml.YamlSettingsReader;

public class MergedSettings
extends BasicSettings
implements IOSettings {
    @Override
    public void loadResource(String mainSettings, StreamType type) throws IOException {
        try (InputStream inStream = ResourcesUtils.getResourceAsStream(mainSettings);){
            if (inStream != null) {
                this.loadConfigSource(new InputStreamReader(inStream, StandardCharsets.UTF_8), type);
            }
        }
    }

    @Override
    public void loadStream(InputStream mainSettings, StreamType type) throws IOException {
        if (mainSettings != null) {
            this.loadConfigSource(new InputStreamReader((InputStream)new AutoCloseInputStream(mainSettings), StandardCharsets.UTF_8), type);
        }
    }

    @Override
    public void loadStream(InputStream mainSettings, Charset charset, StreamType type) throws IOException {
        if (mainSettings != null) {
            this.loadConfigSource(new InputStreamReader((InputStream)new AutoCloseInputStream(mainSettings), charset), type);
        }
    }

    @Override
    public void loadStringBody(String mainSettings, StreamType type) throws IOException {
        if (mainSettings != null) {
            this.loadConfigSource(new StringReader(mainSettings), type);
        }
    }

    @Override
    public void loadReader(Reader mainSettings, StreamType type) throws IOException {
        if (mainSettings != null) {
            this.loadConfigSource(new AutoCloseReader(mainSettings), type);
        }
    }

    private void loadConfigSource(Reader dataReader, StreamType type) throws IOException {
        SettingsReader reader;
        switch (type) {
            case Xml: {
                reader = new XmlSettingsReader();
                break;
            }
            case Yaml: {
                reader = new YamlSettingsReader();
                break;
            }
            case Properties: {
                reader = new PropertiesSettingsReader();
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)type) + " Unsupported.");
            }
        }
        reader.readSetting(dataReader, this);
        this.updateSettings();
    }
}

