/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.setting.SettingNode;
import net.hasor.cobble.setting.Settings;
import net.hasor.cobble.setting.data.DataNode;
import net.hasor.cobble.setting.data.UpdateValue;

public class TreeNode
implements SettingNode {
    public static final TreeNode[] EMPTY = new TreeNode[0];
    private final TreeNode parent;
    private final String space;
    private final String name;
    private final DataNode data = new DataNode(this);
    private final Map<String, TreeNode> subDefault = new ConcurrentHashMap<String, TreeNode>();
    private final Map<String, List<TreeNode>> subList = new ConcurrentHashMap<String, List<TreeNode>>();

    public TreeNode() {
        this.parent = null;
        this.space = "";
        this.name = "";
    }

    public TreeNode(String name) {
        this.parent = null;
        this.space = "";
        this.name = name == null ? "" : name.trim();
    }

    public TreeNode(String name, String space) {
        this.parent = null;
        this.space = space == null ? "" : space.trim();
        this.name = name == null ? "" : name.trim();
    }

    TreeNode(TreeNode parent, String name) {
        String string = name = name == null ? "" : name.trim();
        if (name.contains(".")) {
            throw new IllegalArgumentException("name contains symbol '.'");
        }
        this.parent = Objects.requireNonNull(parent, "parent must not be null.");
        this.space = parent.space;
        this.name = name;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public String getSpace() {
        return this.space;
    }

    @Override
    public boolean isDefault() {
        if (this.parent == null) {
            return true;
        }
        return this.parent.subDefault.containsValue(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        if (this.parent != null && StringUtils.isNotBlank(this.parent.getFullName())) {
            return this.parent.getFullName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public String getValue() {
        return this.data.getValue();
    }

    @Override
    public String[] getValues() {
        return this.data.getValues();
    }

    @Override
    public void setValue(String value) {
        this.data.setValue(value);
    }

    @Override
    public void addValue(String value) {
        this.data.addValue(value);
    }

    @Override
    public String getSubValue(String elementName) {
        TreeNode defaultNode = this.subDefault.get(elementName);
        if (defaultNode != null) {
            return defaultNode.getValue();
        }
        return null;
    }

    @Override
    public String[] getSubValues(String elementName) {
        SettingNode[] defaultNode = this.getSubNodes(elementName);
        if (defaultNode == null || defaultNode.length == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])Arrays.stream(defaultNode).flatMap(settingNode -> Arrays.stream(settingNode.getValues())).toArray(String[]::new);
    }

    @Override
    public TreeNode getSubNode(String elementName) {
        return this.subDefault.get(elementName);
    }

    @Override
    public SettingNode[] getSubNodes(String elementName) {
        List<TreeNode> treeNodes = this.subList.get(elementName);
        if (treeNodes == null) {
            return new SettingNode[0];
        }
        return treeNodes.toArray(EMPTY);
    }

    @Override
    public SettingNode[] getSubNodes(String elementName, Predicate<SettingNode> predicate) {
        List<TreeNode> nodeList = this.subList.get(elementName);
        if (nodeList != null && predicate != null) {
            if (nodeList.isEmpty()) {
                return EMPTY;
            }
            return (SettingNode[])nodeList.stream().filter(predicate).toArray(TreeNode[]::new);
        }
        return EMPTY;
    }

    @Override
    public String[] getSubKeys() {
        return this.subList.keySet().toArray(new String[0]);
    }

    public TreeNode[] getSubNodes() {
        if (this.subList.isEmpty()) {
            return EMPTY;
        }
        List<TreeNode> treeNodes = this.subList.values().stream().reduce((n1, n2) -> {
            ArrayList merged = new ArrayList(n1.size() + n2.size());
            merged.addAll(n1);
            merged.addAll(n2);
            return merged;
        }).orElse(Collections.emptyList());
        return treeNodes.toArray(EMPTY);
    }

    @Override
    public TreeNode newNode(String elementName) {
        return this.newNode(elementName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode newNode(String elementName, boolean setDefault) {
        if (StringUtils.isBlank(elementName)) {
            throw new IllegalArgumentException("elementName must not blank.");
        }
        if (elementName.contains(".")) {
            throw new IllegalArgumentException("elementName contains symbol '.'");
        }
        boolean isInit = false;
        TreeNode treeNode = new TreeNode(this, elementName);
        List<TreeNode> nodeList = this.subList.get(elementName);
        if (nodeList == null) {
            TreeNode treeNode2 = this;
            synchronized (treeNode2) {
                nodeList = this.subList.get(elementName);
                if (nodeList == null) {
                    nodeList = new CopyOnWriteArrayList<TreeNode>();
                    isInit = true;
                    this.subList.put(elementName, nodeList);
                }
            }
        }
        if (setDefault || isInit) {
            this.subDefault.put(elementName, treeNode);
        }
        nodeList.add(treeNode);
        return treeNode;
    }

    @Override
    public TreeNode newLast(String configKey) {
        int lastIndexOf = configKey.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return this.newNode(configKey);
        }
        String parentConfigKey = configKey.substring(0, lastIndexOf);
        String lastConfigKey = configKey.substring(lastIndexOf + 1);
        TreeNode treeNode = this.mkAndGet(parentConfigKey.split("\\."), 0);
        return treeNode.newNode(lastConfigKey);
    }

    @Override
    public SettingNode addSubNode(SettingNode treeNode) {
        return this.addSubNode(treeNode.getName(), treeNode, false);
    }

    public SettingNode addSubNode(SettingNode target, boolean setDefault) {
        return this.addSubNode(target.getName(), target, setDefault);
    }

    @Override
    public SettingNode addSubNode(String elementName, SettingNode target) {
        return this.addSubNode(elementName, target, false);
    }

    public SettingNode addSubNode(String elementName, SettingNode target, boolean setDefault) {
        if (StringUtils.isBlank(elementName)) {
            throw new IllegalArgumentException("elementName must not blank.");
        }
        TreeNode treeNode = this.newNode(elementName, setDefault);
        this.appendNode(target, treeNode);
        return treeNode;
    }

    private void appendNode(SettingNode src, SettingNode dest) {
        String[] values = src.getValues();
        for (String value : values) {
            dest.addValue(value);
        }
        for (SettingNode node : src.getSubNodes()) {
            ((TreeNode)dest).addSubNode(node, node.isDefault());
        }
    }

    @Override
    public void setNode(String configKey, SettingNode target) {
        TreeNode treeNode = this.mkAndGet(configKey.split("\\."), 0);
        treeNode.clearSub();
        this.appendNode(target, treeNode);
    }

    @Override
    public void addNode(String configKey, SettingNode target) {
        TreeNode treeNode = this.mkAndGet(configKey.split("\\."), 0);
        this.appendNode(target, treeNode);
    }

    @Override
    public void setValue(String configKey, String value) {
        TreeNode treeNode = this.mkAndGet(configKey.split("\\."), 0);
        treeNode.setValue(value);
    }

    @Override
    public void addValue(String configKey, String value) {
        TreeNode treeNode = this.mkAndGet(configKey.split("\\."), 0);
        treeNode.addValue(value);
    }

    private TreeNode mkAndGet(String[] keyPath, int index) {
        if (index >= keyPath.length) {
            return this;
        }
        TreeNode tn = null;
        tn = this.getSubNode(keyPath[index]);
        if (tn == null) {
            TreeNode treeNode = this.newNode(keyPath[index], true);
            return treeNode.mkAndGet(keyPath, index + 1);
        }
        return tn.mkAndGet(keyPath, index + 1);
    }

    @Override
    public TreeNode findNode(String configKey) {
        if (configKey.equals(".") || configKey.equals("")) {
            return this;
        }
        return this.findNode(configKey.split("\\."), 0);
    }

    @Override
    public TreeNode findOrNew(String configKey) {
        return this.mkAndGet(configKey.split("\\."), 0);
    }

    private TreeNode findNode(String[] keyPath, int index) {
        if (index >= keyPath.length) {
            if (this.getName().equals(keyPath[index - 1])) {
                return this;
            }
            return null;
        }
        TreeNode treeNode = this.getSubNode(keyPath[index]);
        if (treeNode != null) {
            return treeNode.findNode(keyPath, index + 1);
        }
        return null;
    }

    @Override
    public String findValue(String configKey) {
        return this.findNode(configKey).getValue();
    }

    @Override
    public List<SettingNode> findNodes(String configKey) {
        ArrayList<SettingNode> results = new ArrayList<SettingNode>();
        if (configKey.equals(".") || configKey.equals("")) {
            results.add(this);
        } else {
            this.findNodes(results, configKey.split("\\."), 0);
        }
        return results;
    }

    private void findNodes(List<SettingNode> results, String[] keyPath, int index) {
        if (index >= keyPath.length) {
            if (this.getName().equals(keyPath[index - 1])) {
                results.add(this);
            }
            return;
        }
        List<TreeNode> treeNodes = this.subList.get(keyPath[index]);
        if (treeNodes != null && !treeNodes.isEmpty()) {
            for (TreeNode treeNode : treeNodes) {
                treeNode.findNodes(results, keyPath, index + 1);
            }
        }
    }

    @Override
    public String[] findValues(String configKey) {
        return this.findNodes(configKey).stream().map(SettingNode::getValues).reduce(ArrayUtils::addAll).orElse(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public void visitNodes(Consumer<SettingNode> consumer) {
        if (!this.subList.isEmpty()) {
            this.subList.values().forEach(tn -> tn.forEach(treeNode -> {
                consumer.accept((SettingNode)treeNode);
                treeNode.visitNodes(consumer);
            }));
        }
    }

    @Override
    public void clear() {
        this.clearSub();
        this.clearValue();
    }

    @Override
    public void clearValue() {
        this.data.clear();
    }

    @Override
    public void clearSub() {
        if (!this.subList.isEmpty()) {
            this.subList.forEach((key, value) -> {
                value.forEach(TreeNode::clear);
                value.clear();
            });
            this.subList.clear();
        }
        this.subDefault.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSub(String elementName) {
        if (!this.subDefault.containsKey(elementName)) {
            return;
        }
        TreeNode treeNode = this;
        synchronized (treeNode) {
            TreeNode treeNode2 = this.subDefault.get(elementName);
            List<TreeNode> treeNodeList = this.subList.get(elementName);
            if (treeNode2 == null && treeNodeList == null) {
                return;
            }
            this.subDefault.remove(elementName);
            this.subList.remove(elementName);
            if (treeNode2 != null) {
                treeNode2.clear();
            }
            if (treeNodeList != null) {
                treeNodeList.forEach(TreeNode::clear);
            }
        }
    }

    @Override
    public void findClear(String configKey) {
        List<SettingNode> nodeList = this.findNodes(configKey);
        if (nodeList == null) {
            return;
        }
        ArrayList<TreeNode> afterClear = new ArrayList<TreeNode>();
        for (SettingNode node : nodeList) {
            node.clear();
            afterClear.add((TreeNode)node);
        }
        while (!afterClear.isEmpty()) {
            ArrayList<TreeNode> newAfterClear = new ArrayList<TreeNode>();
            for (TreeNode treeNode : afterClear) {
                TreeNode parent;
                if (!treeNode.isEmpty() || (parent = treeNode.getParent()) == null) continue;
                parent.removeObject(treeNode);
                if (newAfterClear.contains(parent)) continue;
                newAfterClear.add(parent);
            }
            afterClear = newAfterClear;
        }
    }

    private void removeObject(TreeNode treeNode) {
        String nodeName = treeNode.getName();
        boolean needDefault = this.subDefault.containsValue(treeNode);
        List<TreeNode> nodes = this.subList.get(nodeName);
        nodes.remove(treeNode);
        if (needDefault) {
            this.subDefault.remove(nodeName);
            if (!nodes.isEmpty()) {
                this.subDefault.put(nodeName, nodes.get(0));
            } else {
                this.subList.remove(nodeName);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty() && this.subList.isEmpty() && this.subDefault.isEmpty();
    }

    @Override
    public void update(UpdateValue updateValue, Settings context) {
        this.data.update(updateValue, context);
        this.subList.forEach((s, treeNodes) -> treeNodes.forEach(treeNode -> treeNode.update(updateValue, context)));
    }

    public String toString() {
        String value = this.data.getValue();
        value = value == null ? "null" : '\'' + value + '\'';
        return "TreeNode{space='" + this.space + '\'' + ", name='" + this.name + '\'' + ", value=" + value + ", dataSize=" + this.data.getValues().length + ", subKeysSize=" + this.getSubKeys().length + ", subSize=" + this.subList.size() + '}';
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.visitNodes(settingNode -> {
            String nodeValue = settingNode.getValue();
            if (nodeValue != null) {
                hashMap.put(settingNode.getFullName(), nodeValue);
            }
        });
        return hashMap;
    }

    @Override
    public Map<String, List<String>> toMapList() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.visitNodes(settingNode -> {
            String fullName = settingNode.getFullName();
            String[] values = settingNode.getValues();
            if (values != null && values.length > 0) {
                List list = hashMap.computeIfAbsent(fullName, k -> new ArrayList());
                list.addAll(Arrays.asList(values));
            }
        });
        return hashMap;
    }

    public Map<String, Object> toMapData() {
        TreeNode[] subNodes;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TreeNode treeNode : subNodes = this.getSubNodes()) {
            String name = treeNode.getName();
            String[] values = treeNode.getValues();
            if (values == null || values.length == 0) {
                if (!hashMap.containsKey(name)) {
                    hashMap.put(name, treeNode.toMapData());
                    continue;
                }
                Object o = hashMap.get(name);
                if (o instanceof List) {
                    ((List)o).add(treeNode.toMapData());
                    continue;
                }
                hashMap.put(name, new ArrayList<Object>(Arrays.asList(o, treeNode.toMapData())));
                continue;
            }
            hashMap.put(name, values.length == 1 ? values[0] : values);
        }
        return hashMap;
    }

    @Override
    public String toXml() {
        TreeNode[] subNodes = this.getSubNodes();
        String[] thisValues = this.getValues();
        if (!(subNodes != null && subNodes.length != 0 || thisValues != null && thisValues.length != 0)) {
            return "<" + this.name + "/>";
        }
        StringBuilder strBuilder = new StringBuilder();
        if (thisValues != null && thisValues.length > 1) {
            for (int i = 1; i < thisValues.length; ++i) {
                strBuilder.append(this.beginElement(this.name));
                strBuilder.append(this.writeCDATA(thisValues[i]));
                strBuilder.append(this.endElement(this.name));
            }
        }
        strBuilder.append(this.beginElement(this.name));
        if (thisValues != null && thisValues.length == 1) {
            strBuilder.append(this.writeCDATA(thisValues[0]));
        }
        if (subNodes != null) {
            for (TreeNode subNode : subNodes) {
                strBuilder.append(subNode.toXml());
            }
        }
        strBuilder.append(this.endElement(this.name));
        return strBuilder.toString();
    }

    private String beginElement(String name) {
        return "<" + name + ">";
    }

    private String endElement(String name) {
        return "</" + name + ">";
    }

    private String writeCDATA(String thisValue) {
        if (thisValue.contains("<") || thisValue.contains(">")) {
            return "<![CDATA[" + thisValue + "]]>";
        }
        return thisValue;
    }

    private static String writeAttribute(String attVal) {
        attVal = attVal.replace("<", "&lt;");
        attVal = attVal.replace(">", "&gt;");
        attVal = attVal.replace("'", "&apos;");
        attVal = attVal.replace("\"", "&quot;");
        attVal = attVal.replace("&", "&amp;");
        return attVal;
    }
}

