/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting.provider.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.setting.Settings;
import net.hasor.cobble.setting.data.TreeNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxXmlParser
extends DefaultHandler {
    private final Map<String, TreeNode> root = new HashMap<String, TreeNode>();
    private final Map<String, Stack<TreeNode>> curNode = new HashMap<String, Stack<TreeNode>>();
    private String curXmlns;
    private final Settings settings;

    public SaxXmlParser(Settings settings) {
        this.settings = settings;
    }

    private TreeNode getRoot(String uri) {
        TreeNode treeNode = this.root.get(uri);
        if (treeNode == null) {
            treeNode = new TreeNode("", uri);
            this.root.put(uri, treeNode);
        }
        return treeNode;
    }

    private TreeNode curNode(String uri) {
        Stack stack = this.curNode.computeIfAbsent(uri, k -> new Stack());
        if (stack.isEmpty()) {
            return null;
        }
        return (TreeNode)stack.peek();
    }

    private TreeNode pushNode(String uri, TreeNode treeNode) {
        Stack stack = this.curNode.computeIfAbsent(uri, k -> new Stack());
        stack.push(treeNode);
        return treeNode;
    }

    private TreeNode popNode(String uri) {
        Stack stack = this.curNode.computeIfAbsent(uri, k -> new Stack());
        return (TreeNode)stack.pop();
    }

    private TreeNode newNode(String uri, String localName) {
        TreeNode curNode = this.curNode(uri);
        if (curNode == null) {
            return this.pushNode(uri, this.getRoot(uri));
        }
        TreeNode newSubNode = curNode.newLast(localName.trim());
        return this.pushNode(uri, newSubNode);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        TreeNode treeNode = this.newNode(uri, localName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getLocalName(i);
            String attValue = attributes.getValue(i);
            if (StringUtils.isBlank(attName)) continue;
            treeNode.addValue(attName.trim(), attValue);
        }
        this.curXmlns = uri;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.curXmlns == null) {
            return;
        }
        String dat = new String(ch, start, length);
        if (StringUtils.isNotBlank(dat)) {
            this.curNode(this.curXmlns).addValue(dat.trim());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popNode(uri);
        this.curXmlns = uri;
    }

    @Override
    public void endDocument() {
        this.root.forEach((xmlns, treeNode) -> {
            for (TreeNode node : treeNode.getSubNodes()) {
                this.settings.addSetting(node.getName(), node, (String)xmlns);
            }
        });
    }
}

