/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtils {
    private static void isPortAvailable(String host, int port) throws Exception {
        Socket s = new Socket();
        s.bind(new InetSocketAddress(host, port));
        s.close();
    }

    public static boolean isPortAvailable(int port) {
        try {
            NetworkUtils.isPortAvailable("0.0.0.0", port);
            NetworkUtils.isPortAvailable(InetAddress.getLocalHost().getHostAddress(), port);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] ipStrToBytes(String ipData) {
        byte[] ipParts = new byte[4];
        String[] splitArrays = ipData.split("\\.");
        for (int i = 0; i < splitArrays.length; ++i) {
            ipParts[i] = (byte)Integer.parseInt(splitArrays[i]);
        }
        return ipParts;
    }

    public static InetAddress finalBindAddress(String hostString) throws UnknownHostException, SocketException {
        if ("local".equalsIgnoreCase(hostString)) {
            List<String> localAddr = NetworkUtils.localAddrForIPv4();
            if (localAddr.isEmpty()) {
                return InetAddress.getLocalHost();
            }
            return InetAddress.getByName(localAddr.get(0));
        }
        return InetAddress.getByName(hostString);
    }

    public static String maskToStringByPrefixLength(int length) {
        return NetworkUtils.ipDataToString(NetworkUtils.ipDataByInt(NetworkUtils.maskByPrefixLength(length)));
    }

    public static int maskByPrefixLength(int length) {
        if (length > 32) {
            throw new IndexOutOfBoundsException("mask length max is 32.");
        }
        return -1 << 32 - length;
    }

    public static byte[] ipDataByInt(int ipData) {
        byte[] ipParts = new byte[4];
        for (int i = 0; i < ipParts.length; ++i) {
            int pos = ipParts.length - 1 - i;
            ipParts[pos] = (byte)(ipData >> i * 8);
        }
        return ipParts;
    }

    public static int ipDataByBytes(byte[] ipData) {
        int[] ipParts = new int[]{0xFFFFFFFF & ipData[0] << 24, 0xFFFFFF & ipData[1] << 16, 0xFFFF & ipData[2] << 8, 0xFF & ipData[3] << 0};
        int intIP = 0;
        for (int ipPart : ipParts) {
            intIP |= ipPart;
        }
        return intIP;
    }

    public static String ipDataToString(int ipData) {
        return NetworkUtils.ipDataToString(NetworkUtils.ipDataByInt(ipData));
    }

    public static String ipDataToString(byte[] ipData) {
        StringBuilder result = new StringBuilder();
        result.append(NetworkUtils.toStr(ipData[0]));
        for (int i = 1; i < ipData.length; ++i) {
            result.append(".").append(NetworkUtils.toStr(ipData[i]));
        }
        return result.toString();
    }

    private static String toStr(byte byteData) {
        return "" + (byteData < 0 ? 256 + byteData : byteData);
    }

    public static List<String> localAddrForIPv4() throws SocketException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> ipAddrEnum = ni.getInetAddresses();
            while (ipAddrEnum.hasMoreElements()) {
                String ip;
                InetAddress addr = ipAddrEnum.nextElement();
                if (addr.isLoopbackAddress() || (ip = addr.getHostAddress()).contains(":") || ipList.contains(ip)) continue;
                ipList.add(ip);
            }
        }
        return ipList;
    }
}

