/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.concurrent.future;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.hasor.cobble.concurrent.future.CancelFutureCallback;
import net.hasor.cobble.concurrent.future.Future;
import net.hasor.cobble.concurrent.future.FutureCallback;
import net.hasor.cobble.concurrent.future.FutureListener;

public class BasicFuture<T>
implements Future<T> {
    private final FutureCallback<T> callback;
    private volatile List<FutureListener<Future<T>>> completedListener;
    private volatile List<FutureListener<Future<T>>> failedListener;
    private volatile List<FutureListener<Future<T>>> cancelListener;
    private volatile List<FutureListener<Future<T>>> finalListener;
    private volatile boolean completed;
    private volatile boolean cancelled;
    private volatile T result;
    private volatile Throwable ex;

    public BasicFuture() {
        this.callback = null;
    }

    public BasicFuture(T value) {
        this();
        this.completed = true;
        this.result = value;
    }

    public BasicFuture(FutureCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    @Override
    public Throwable getCause() {
        return this.ex;
    }

    @Override
    public T getResult() {
        return this.ex != null ? null : (T)this.result;
    }

    private T result() throws ExecutionException {
        if (this.ex != null) {
            throw new ExecutionException(this.ex.getMessage(), this.ex);
        }
        return this.result;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        return this.result();
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException("Time unit");
        }
        long msecs = unit.toMillis(timeout);
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.completed) {
            return this.result();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException();
        }
        do {
            this.wait(waitTime);
            if (!this.completed) continue;
            return this.result();
        } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean completed(T result) {
        if (this.completed) {
            return false;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.result = result;
            if (this.callback != null) {
                this.callback.completed(result);
            }
            this.triggerListener(this.completedListener);
            this.triggerListener(this.finalListener);
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean failed(Throwable exception) {
        if (this.completed) {
            return false;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.ex = exception;
            if (this.callback != null) {
                this.callback.failed(exception);
            }
            this.triggerListener(this.failedListener);
            this.triggerListener(this.finalListener);
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.completed) {
            return false;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.cancelled = true;
            if (this.callback != null) {
                if (this.callback instanceof CancelFutureCallback) {
                    ((CancelFutureCallback)this.callback).cancelled();
                } else {
                    this.failed(new CancellationException());
                    return true;
                }
            }
            this.triggerListener(this.cancelListener);
            this.triggerListener(this.finalListener);
            this.notifyAll();
        }
        return true;
    }

    @Override
    public boolean cancel() {
        return this.cancel(true);
    }

    private void triggerListener(List<FutureListener<Future<T>>> listenerList) {
        if (listenerList != null) {
            for (FutureListener<Future<T>> callback : listenerList) {
                try {
                    callback.operationComplete(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onCompleted(FutureListener<Future<T>> listener) {
        if (listener == null) {
            return this;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed && !this.cancelled && this.ex == null) {
                listener.operationComplete(this);
                return this;
            }
            if (this.completedListener == null && this.completedListener == null) {
                this.completedListener = new ArrayList<FutureListener<Future<T>>>();
            }
            this.completedListener.add(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onFailed(FutureListener<Future<T>> listener) {
        if (listener == null) {
            return this;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed && !this.cancelled && this.ex != null) {
                listener.operationComplete(this);
                return this;
            }
            if (this.failedListener == null && this.failedListener == null) {
                this.failedListener = new ArrayList<FutureListener<Future<T>>>();
            }
            this.failedListener.add(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onCancel(FutureListener<Future<T>> listener) {
        if (listener == null) {
            return this;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed && this.cancelled) {
                listener.operationComplete(this);
                return this;
            }
            if (this.cancelListener == null && this.cancelListener == null) {
                this.cancelListener = new ArrayList<FutureListener<Future<T>>>();
            }
            this.cancelListener.add(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onFinal(FutureListener<Future<T>> listener) {
        if (listener == null) {
            return this;
        }
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.completed) {
                listener.operationComplete(this);
                return this;
            }
            if (this.finalListener == null && this.finalListener == null) {
                this.finalListener = new ArrayList<FutureListener<Future<T>>>();
            }
            this.finalListener.add(listener);
            return this;
        }
    }
}

