/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.dynamic;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.hasor.cobble.asm.Label;
import net.hasor.cobble.asm.MethodVisitor;
import net.hasor.cobble.asm.Opcodes;

public class AsmTools
implements Opcodes {
    public static int getReturn(String asmType) {
        char t = asmType.charAt(0);
        switch (t) {
            case 'B': {
                return 172;
            }
            case 'C': {
                return 172;
            }
            case 'D': {
                return 175;
            }
            case 'F': {
                return 174;
            }
            case 'I': {
                return 172;
            }
            case 'J': {
                return 173;
            }
            case 'L': {
                return 176;
            }
            case 'S': {
                return 172;
            }
            case 'Z': {
                return 172;
            }
            case '[': {
                return 176;
            }
            case 'V': {
                return 177;
            }
        }
        throw new UnsupportedOperationException("Unsupported LOAD instruction.");
    }

    public static int getLoad(String asmType) {
        char t = asmType.charAt(0);
        switch (t) {
            case 'B': {
                return 21;
            }
            case 'C': {
                return 21;
            }
            case 'D': {
                return 24;
            }
            case 'F': {
                return 23;
            }
            case 'I': {
                return 21;
            }
            case 'J': {
                return 22;
            }
            case 'L': {
                return 25;
            }
            case 'S': {
                return 21;
            }
            case 'Z': {
                return 21;
            }
            case '[': {
                return 25;
            }
        }
        throw new UnsupportedOperationException("Unsupported LOAD instruction.");
    }

    public static String toAsmType(Class<?> classType) {
        if (classType == Integer.TYPE) {
            return "I";
        }
        if (classType == Byte.TYPE) {
            return "B";
        }
        if (classType == Character.TYPE) {
            return "C";
        }
        if (classType == Double.TYPE) {
            return "D";
        }
        if (classType == Float.TYPE) {
            return "F";
        }
        if (classType == Long.TYPE) {
            return "J";
        }
        if (classType == Short.TYPE) {
            return "S";
        }
        if (classType == Boolean.TYPE) {
            return "Z";
        }
        if (classType == Void.TYPE) {
            return "V";
        }
        if (classType.isArray()) {
            return "[" + AsmTools.toAsmType(classType.getComponentType());
        }
        return "L" + net.hasor.cobble.asm.Type.getInternalName(classType) + ";";
    }

    public static String toAsmType(Class<?>[] classType) {
        String returnString = "";
        for (Class<?> c : classType) {
            returnString = returnString + AsmTools.toAsmType(c);
        }
        return returnString;
    }

    public static String toAsmSignature(Method targetMethod) {
        int i;
        StringBuffer signature = new StringBuffer();
        Class<?>[] pTypeArray = targetMethod.getParameterTypes();
        class MoreType {
            String name = null;
            Class<?> paramClass = null;
            TypeVariable<?> paramType = null;

            MoreType() {
            }
        }
        MoreType[] mTypeList = new MoreType[pTypeArray.length];
        for (int i2 = 0; i2 < pTypeArray.length; ++i2) {
            Class<?> pType = pTypeArray[i2];
            MoreType mtype = new MoreType();
            mtype.paramClass = pType;
            mTypeList[i2] = mtype;
        }
        Type[] gTypeArray = targetMethod.getGenericParameterTypes();
        for (int i3 = 0; i3 < gTypeArray.length; ++i3) {
            Type gType = gTypeArray[i3];
            if (!(gType instanceof TypeVariable)) continue;
            mTypeList[i3].name = ((TypeVariable)gType).getName();
            mTypeList[i3].paramType = (TypeVariable)gType;
        }
        TypeVariable<Method>[] tTypeArray = targetMethod.getTypeParameters();
        for (i = 0; i < tTypeArray.length; ++i) {
            if (i == 0) {
                signature.append("<");
            }
            TypeVariable<Method> tType = tTypeArray[i];
            String tName = tType.getName();
            for (int j = 0; j < mTypeList.length; ++j) {
                if (!tName.equals(mTypeList[j].name)) continue;
                signature.append(tName);
                if (mTypeList[j].paramClass.isInterface()) {
                    signature.append("::");
                } else {
                    signature.append(":");
                }
                for (Type atType : mTypeList[j].paramType.getBounds()) {
                    AsmTools.getTypeVarStr(signature, atType);
                }
            }
            if (i != tTypeArray.length - 1) continue;
            signature.append(">");
        }
        signature.append("(");
        for (i = 0; i < mTypeList.length; ++i) {
            MoreType mType = mTypeList[i];
            if (mType.name != null) {
                signature.append(String.format("T%s;", mType.name));
                continue;
            }
            signature.append(AsmTools.toAsmType(mType.paramClass));
        }
        signature.append(")");
        signature.append(AsmTools.toAsmType(targetMethod.getReturnType()));
        if (signature.length() == 0) {
            return null;
        }
        return signature.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuffer getTypeVarStr(StringBuffer atString, Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable paramType = (TypeVariable)type;
            atString.append("T" + paramType.getName() + ";");
            return atString;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            atString.append("L" + AsmTools.replaceClassName((Class)paramType.getRawType()));
            atString.append("<");
            for (Type atType : paramType.getActualTypeArguments()) {
                AsmTools.getTypeVarStr(atString, atType);
            }
            atString.append(">");
            atString.append(";");
            return atString;
        } else if (type instanceof Class) {
            Class paramType = (Class)type;
            atString.append(AsmTools.toAsmType(paramType));
            return atString;
        } else if (type instanceof WildcardType) {
            WildcardType paramType = (WildcardType)type;
            Type[] upperType = paramType.getUpperBounds();
            Type[] lowerType = paramType.getLowerBounds();
            if (lowerType.length == 0 && upperType.length != 0) {
                atString.append("+");
                for (Type atType : upperType) {
                    AsmTools.getTypeVarStr(atString, atType);
                }
                return atString;
            } else {
                if (lowerType.length == 0 || upperType.length == 0) throw new RuntimeException("Generic format error.");
                atString.append("-");
                for (Type atType : lowerType) {
                    AsmTools.getTypeVarStr(atString, atType);
                }
            }
            return atString;
        } else if (!(type instanceof GenericArrayType)) return atString;
        return atString;
    }

    public static String toAsmFullDesc(Method method) {
        StringBuffer str = new StringBuffer();
        str.append(method.getName());
        str.append("(");
        str.append(AsmTools.toAsmType(method.getParameterTypes()));
        str.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            str.append("V");
        } else {
            str.append(AsmTools.toAsmType(returnType));
        }
        return str.toString();
    }

    public static String toAsmDesc(Method method) {
        StringBuffer str = new StringBuffer();
        str.append("(");
        str.append(AsmTools.toAsmType(method.getParameterTypes()));
        str.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            str.append("V");
        } else {
            str.append(AsmTools.toAsmType(returnType));
        }
        return str.toString();
    }

    public static String[] splitAsmType(String asmTypes) {
        try {
            class AsmTypeRead {
                StringReader sread = null;

                public AsmTypeRead(String sr) {
                    this.sread = new StringReader(sr);
                }

                private String readToSemicolon() throws IOException {
                    String res = "";
                    int strInt;
                    while ((strInt = this.sread.read()) != -1) {
                        if ((char)strInt == ';') {
                            return res + ';';
                        }
                        res = res + (char)strInt;
                    }
                    return res;
                }

                private String readType() throws IOException {
                    int strInt = this.sread.read();
                    if (strInt == -1) {
                        return "";
                    }
                    switch ((char)strInt) {
                        case '[': {
                            return '[' + this.readType();
                        }
                        case 'L': {
                            return 'L' + this.readToSemicolon();
                        }
                    }
                    return String.valueOf((char)strInt);
                }

                public String[] readTypes() throws IOException {
                    String s;
                    ArrayList<String> ss = new ArrayList<String>(0);
                    while (!"".equals(s = this.readType())) {
                        ss.add(s);
                    }
                    String[] res = new String[ss.size()];
                    ss.toArray(res);
                    return res;
                }
            }
            return new AsmTypeRead(asmTypes).readTypes();
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid ASM type desc.");
        }
    }

    public static String replaceClassName(Class<?> targetClass) {
        return targetClass.getName().replace(".", "/");
    }

    public static String replaceClassName(String targetClass) {
        return targetClass.replace(".", "/");
    }

    public static String[] replaceClassName(Class<?>[] exceptionTypes) {
        String[] typeStr = new String[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            typeStr[i] = AsmTools.replaceClassName(exceptionTypes[i]);
        }
        return typeStr;
    }

    public static boolean checkAnd(int data, int ... check) {
        for (int checkItem : check) {
            int or = data | checkItem;
            if (or == data) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOr(int data, int ... check) {
        for (int checkItem : check) {
            int or = data | checkItem;
            if (or != data) continue;
            return true;
        }
        return false;
    }

    public static String asmTypeToType(String asmType) {
        if (asmType.charAt(0) == 'L') {
            return asmType.substring(1, asmType.length() - 1);
        }
        return asmType;
    }

    public static void codeBuilder_1(MethodVisitor mv, String[] asmParams, Map<String, Integer> paramIndexMap) {
        HashSet<String> typeEnum = new HashSet<String>(Arrays.asList("B", "S", "I", "J", "F", "D", "C", "Z"));
        int paramCount = asmParams.length;
        mv.visitIntInsn(16, paramCount);
        mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            if (typeEnum.contains(asmParams[i])) {
                mv.visitVarInsn(AsmTools.getLoad(asmType), paramIndexMap.get("args" + i));
                AsmTools.codeBuilder_valueOf(mv, asmParams[i]);
            } else {
                mv.visitVarInsn(25, paramIndexMap.get("args" + i));
            }
            mv.visitInsn(83);
        }
    }

    public static void codeBuilder_valueOf(MethodVisitor mv, String asmType) {
        if (asmType.equals("B")) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (asmType.equals("S")) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (asmType.equals("I")) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (asmType.equals("J")) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (asmType.equals("F")) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (asmType.equals("D")) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        } else if (asmType.equals("C")) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (asmType.equals("Z")) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        }
    }

    public static void codeBuilder_2(MethodVisitor mv, String[] asmParams) {
        int paramCount = asmParams.length;
        mv.visitIntInsn(16, paramCount);
        mv.visitTypeInsn(189, "java/lang/Class");
        for (int i = 0; i < paramCount; ++i) {
            String asmType = asmParams[i];
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            if (asmParams[i].equals("B")) {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("S")) {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("I")) {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("J")) {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("F")) {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("D")) {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("C")) {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (asmParams[i].equals("Z")) {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else {
                mv.visitLdcInsn(net.hasor.cobble.asm.Type.getType(asmType));
            }
            mv.visitInsn(83);
        }
    }

    public static void codeBuilder_3(MethodVisitor mv, String asmReturns) {
        AsmTools.codeBuilder_3(mv, asmReturns, null);
    }

    public static void codeBuilder_3(MethodVisitor mv, String asmReturns, Label tryEnd) {
        AsmTools.codeBuilder_Cast(mv, asmReturns, tryEnd);
        mv.visitInsn(AsmTools.getReturn(asmReturns));
    }

    public static void codeBuilder_Cast(MethodVisitor mv, String asmReturns, Label tryEnd) {
        if (asmReturns.equals("B")) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("S")) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("I")) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("J")) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("F")) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("D")) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("C")) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("Z")) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else if (asmReturns.equals("V")) {
            mv.visitInsn(87);
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        } else {
            mv.visitTypeInsn(192, AsmTools.asmTypeToType(asmReturns));
            if (tryEnd != null) {
                mv.visitLabel(tryEnd);
            }
        }
    }
}

