/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.dynamic;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.dynamic.Aop;
import net.hasor.cobble.dynamic.AopSet;
import net.hasor.cobble.dynamic.AsmTools;
import net.hasor.cobble.dynamic.BasicObject;
import net.hasor.cobble.dynamic.DynamicProperty;
import net.hasor.cobble.dynamic.MethodInterceptor;
import net.hasor.cobble.dynamic.ReadWriteType;
import net.hasor.cobble.dynamic.SimpleDynamicProperty;
import net.hasor.cobble.provider.Provider;

public class DynamicConfig {
    private final String specialNamePrefix;
    private final Class<?> superClass;
    private final Map<String, DynamicPropertyInfo> dynamicPropertyMap = new HashMap<String, DynamicPropertyInfo>();
    private final Map<String, MethodInterceptor[]> interceptorMap = new HashMap<String, MethodInterceptor[]>();
    private final Map<String, Method> interceptorMethods = new HashMap<String, Method>();
    private final Map<Class<?>, InvocationHandler> implementMap = new HashMap();
    private File debugOutputDir;

    public DynamicConfig() {
        this(BasicObject.class);
    }

    public DynamicConfig(Class<?> superClass) {
        this(superClass, null);
    }

    public DynamicConfig(Class<?> superClass, InvocationHandler handler) {
        boolean classTest;
        this.superClass = superClass == null || superClass.isInterface() ? BasicObject.class : superClass;
        this.specialNamePrefix = this.superClass.getName().startsWith("java.") ? "proxy" : null;
        boolean modifiersTest = Modifier.isFinal(this.superClass.getModifiers()) || !Modifier.isPublic(this.superClass.getModifiers());
        boolean bl = classTest = this.superClass.isPrimitive() || this.superClass.isArray() || this.superClass.isEnum() || this.superClass.isAnonymousClass() || this.superClass.isInterface();
        if (modifiersTest || classTest) {
            throw new IllegalArgumentException("superClass " + superClass + " must be public class and cannot be form [Primitive/Array/Enum/AnonymousClass/Interface]");
        }
        if (Modifier.isAbstract(this.superClass.getModifiers())) {
            if (handler == null) {
                throw new NullPointerException("superClass is abstract, must a handler");
            }
            this.implementMap.put(this.superClass, handler);
        }
    }

    public void addProperty(String propertyName, Class<?> propertyType) {
        this.addProperty(propertyName, propertyType, ReadWriteType.ReadWrite);
    }

    public void addProperty(String propertyName, Class<?> propertyType, ReadWriteType rwType) {
        Object defaultValue = BeanUtils.getDefaultValue(propertyType);
        SimpleDynamicProperty dynamic = new SimpleDynamicProperty(defaultValue);
        this.addProperty(propertyName, propertyType, Provider.of(dynamic), rwType);
    }

    public void addProperty(String propertyName, Class<?> propertyType, Supplier<? extends DynamicProperty> delegate) {
        this.addProperty(propertyName, propertyType, delegate, ReadWriteType.ReadWrite);
    }

    public void addProperty(String propertyName, Class<?> propertyType, Supplier<? extends DynamicProperty> delegate, ReadWriteType rwType) {
        Objects.requireNonNull(propertyType, "args propertyType is null.");
        Objects.requireNonNull(delegate, "args delegate is null.");
        Objects.requireNonNull(rwType, "args rwType is null.");
        if (StringUtils.isBlank(propertyName)) {
            throw new IllegalArgumentException("args propertyName is null.");
        }
        if (BeanUtils.hasProperty(this.getSuperClass(), propertyName)) {
            throw new IllegalStateException(propertyName + " get/set already exists");
        }
        this.dynamicPropertyMap.put(propertyName, new DynamicPropertyInfo(propertyType, delegate, rwType));
    }

    Supplier<? extends DynamicProperty> findDynamicProperty(String name) {
        return this.dynamicPropertyMap.get((Object)name).delegateSupplier;
    }

    Map<String, DynamicPropertyInfo> getDynamicPropertyMap() {
        return Collections.unmodifiableMap(this.dynamicPropertyMap);
    }

    public void addAopInterceptor(Predicate<Method> matcher, MethodInterceptor ... interceptors) {
        Method[] targetMethodArrays;
        Objects.requireNonNull(matcher, "args matcher is null.");
        Objects.requireNonNull(interceptors, "args interceptors is null.");
        for (Method targetMethod : targetMethodArrays = this.getSuperClass().getMethods()) {
            Object[] interceptorArray;
            int dataModifiers = targetMethod.getModifiers();
            if (Modifier.isPrivate(dataModifiers) || Modifier.isFinal(dataModifiers) || Modifier.isStatic(dataModifiers) || Modifier.isAbstract(dataModifiers) || !matcher.test(targetMethod)) continue;
            String interceptorMethodDesc = AsmTools.toAsmFullDesc(targetMethod);
            if (this.interceptorMap.containsKey(interceptorMethodDesc)) {
                interceptorArray = this.interceptorMap.get(interceptorMethodDesc);
                interceptorArray = (MethodInterceptor[])ArrayUtils.addAll(interceptorArray, interceptors);
            } else {
                interceptorArray = interceptors;
            }
            this.interceptorMap.put(interceptorMethodDesc, (MethodInterceptor[])interceptorArray);
            this.interceptorMethods.put(interceptorMethodDesc, targetMethod);
        }
    }

    MethodInterceptor[] findInterceptor(String tmDesc) {
        return this.interceptorMap.get(tmDesc);
    }

    Map<String, MethodInterceptor[]> getInterceptorMap() {
        return Collections.unmodifiableMap(this.interceptorMap);
    }

    Map<String, Method> getInterceptorMethods() {
        return Collections.unmodifiableMap(this.interceptorMethods);
    }

    public void loadAnnotation() throws ReflectiveOperationException {
        Method[] targetMethodArrays;
        Set<Class<? extends MethodInterceptor>> classLevels = this.extractAopType(this.superClass);
        for (Class<? extends MethodInterceptor> interceptorType : classLevels) {
            this.addAopInterceptor(t -> true, interceptorType.newInstance());
        }
        for (Method method : targetMethodArrays = this.getSuperClass().getMethods()) {
            Set<Class<? extends MethodInterceptor>> methodLevels = this.extractAopType(method);
            for (Class<? extends MethodInterceptor> interceptorType : methodLevels) {
                if (classLevels.contains(interceptorType)) continue;
                this.addAopInterceptor(t -> t.equals(method), interceptorType.newInstance());
            }
        }
    }

    private Set<Class<? extends MethodInterceptor>> extractAopType(AnnotatedElement element) {
        Annotation[] annotations = element.getDeclaredAnnotations();
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            DynamicConfig.extractAopAnnotation(annotation, annotationList, new ArrayList<Annotation>());
        }
        HashSet<Class<? extends MethodInterceptor>> config = new HashSet<Class<? extends MethodInterceptor>>();
        for (Annotation annotation : annotationList) {
            config.addAll(Arrays.asList(((Aop)annotation).value()));
        }
        return config;
    }

    private static void extractAopAnnotation(Annotation data, List<Annotation> annotationList, List<Annotation> visitList) {
        if (visitList.contains(data)) {
            return;
        }
        visitList.add(data);
        if (data instanceof Aop) {
            annotationList.add(data);
        } else if (data instanceof AopSet) {
            annotationList.addAll(Arrays.asList(((AopSet)data).value()));
        } else {
            Annotation[] annotations;
            for (Annotation annotation : annotations = data.annotationType().getAnnotations()) {
                DynamicConfig.extractAopAnnotation(annotation, annotationList, visitList);
            }
        }
    }

    public void addImplements(Class<?> interfaceType, InvocationHandler handler) {
        Objects.requireNonNull(interfaceType, "args interfaceType is null.");
        Objects.requireNonNull(handler, "args handler is null.");
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException("only interface can be add.");
        }
        this.implementMap.put(interfaceType, handler);
    }

    Map<Class<?>, InvocationHandler> getImplementMap() {
        return Collections.unmodifiableMap(this.implementMap);
    }

    public boolean hasChange() {
        return !this.interceptorMap.isEmpty() || !this.dynamicPropertyMap.isEmpty() || !this.implementMap.isEmpty();
    }

    String getSpecialNamePrefix() {
        return this.specialNamePrefix;
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    File getDebugOutputDir() {
        return this.debugOutputDir;
    }

    public void setDebugOutputDir(File debugOutputDir) {
        this.debugOutputDir = debugOutputDir;
    }

    static class DynamicPropertyInfo {
        Supplier<? extends DynamicProperty> delegateSupplier;
        Class<?> propertyType;
        ReadWriteType rwType;

        public DynamicPropertyInfo(Class<?> propertyType, Supplier<? extends DynamicProperty> delegateSupplier, ReadWriteType rwType) {
            this.propertyType = propertyType;
            this.delegateSupplier = delegateSupplier;
            this.rwType = rwType;
        }
    }
}

