/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.dynamic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.hasor.cobble.dynamic.DynamicConfig;
import net.hasor.cobble.dynamic.DynamicObject;
import net.hasor.cobble.dynamic.MethodInterceptor;
import net.hasor.cobble.dynamic.MethodInvocation;

public class InvokerMethodInvocation
implements MethodInvocation {
    private final MethodInterceptor[] interceptorDefinitions;
    private final MethodInvocation proceedingChain;
    private int index = -1;

    public InvokerMethodInvocation(boolean isProxy, String targetMethodDesc, Method targetMethod, Method proxyMethod, DynamicConfig dynamicConfig, Object targetObject, Object[] methodParams) {
        MethodInterceptor[] interceptors = dynamicConfig.findInterceptor(targetMethodDesc);
        this.interceptorDefinitions = interceptors == null ? new MethodInterceptor[]{} : interceptors;
        this.proceedingChain = new InnerChainMethodInvocation(isProxy, proxyMethod, targetMethod, targetObject, methodParams);
    }

    @Override
    public boolean isProxy() {
        return this.proceedingChain.isProxy();
    }

    @Override
    public Method getMethod() {
        return this.proceedingChain.getMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.proceedingChain.getArguments();
    }

    @Override
    public Object proceed() throws Throwable {
        ++this.index;
        if (this.index < this.interceptorDefinitions.length) {
            return this.interceptorDefinitions[this.index].invoke(this);
        }
        return this.proceedingChain.proceed();
    }

    @Override
    public Object getThis() {
        return this.proceedingChain.getThis();
    }

    private static class InnerChainMethodInvocation
    implements MethodInvocation {
        private final boolean isProxy;
        private final Method proxyMethod;
        private final Method targetMethod;
        private final Object targetObject;
        private final Object[] paramObjects;

        InnerChainMethodInvocation(boolean isProxy, Method proxyMethod, Method targetMethod, Object targetObject, Object[] paramObjects) {
            this.isProxy = isProxy;
            if (isProxy) {
                this.proxyMethod = targetMethod;
                this.targetObject = ((DynamicObject)targetObject).getOriginalObject();
            } else {
                this.proxyMethod = proxyMethod;
                this.targetObject = targetObject;
            }
            this.targetMethod = targetMethod;
            this.paramObjects = paramObjects;
        }

        @Override
        public boolean isProxy() {
            return this.isProxy;
        }

        @Override
        public Method getMethod() {
            return this.targetMethod;
        }

        @Override
        public Object[] getArguments() {
            return this.paramObjects;
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return this.proxyMethod.invoke(this.targetObject, this.paramObjects);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public Object getThis() {
            return this.targetObject;
        }
    }
}

