/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.MatchUtils;

public class Matchers {
    private Matchers() {
    }

    public static Predicate<Class<?>> anyClass() {
        return t -> true;
    }

    public static Predicate<Method> anyMethod() {
        return t -> true;
    }

    public static Predicate<Method> withMethod(Method method) {
        return t -> t.equals(method);
    }

    public static Predicate<Class<?>> annotatedWithClass(Class<? extends Annotation> annotationType) {
        return new ClassAnnotationOf(annotationType);
    }

    public static Predicate<Method> annotatedWithMethod(Class<? extends Annotation> annotationType) {
        return new MethodAnnotationOf(annotationType);
    }

    public static Predicate<Class<?>> subClassesOf(Class<?> superclass) {
        return new SubClassesOf(superclass);
    }

    public static Predicate<Class<?>> expressionClass(String matcherExpression) {
        return new ClassOf(MatchUtils.MatchTypeEnum.Wild, matcherExpression);
    }

    public static Predicate<Method> expressionMethod(String matcherExpression) {
        return new MethodOf(MatchUtils.MatchTypeEnum.Wild, matcherExpression);
    }

    public static Predicate<Class<?>> anyClassInclude(Set<Class<?>> checkTypes) {
        return checkTypes::contains;
    }

    public static Predicate<Class<?>> anyClassExcludes(Set<Class<?>> checkTypes) {
        return Matchers.anyClassInclude(checkTypes).negate();
    }

    public static Predicate<Method> anyMethod(Class<?> face) {
        return m -> m.getDeclaringClass() == face;
    }

    private static class MethodAnnotationOf
    implements Predicate<Method> {
        private Class<? extends Annotation> annotationType = null;

        public MethodAnnotationOf(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public boolean test(Method matcherType) {
            if (matcherType.isAnnotationPresent(this.annotationType)) {
                return true;
            }
            return matcherType.getDeclaringClass().isAnnotationPresent(this.annotationType);
        }

        public boolean equals(Object other) {
            return other instanceof MethodAnnotationOf && ((MethodAnnotationOf)other).annotationType.equals(this.annotationType);
        }

        public int hashCode() {
            return 37 * this.annotationType.hashCode();
        }

        public String toString() {
            return "MethodAnnotationOf(" + this.annotationType.getSimpleName() + ".class)";
        }
    }

    private static class ClassAnnotationOf
    implements Predicate<Class<?>> {
        private Class<? extends Annotation> annotationType = null;

        public ClassAnnotationOf(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public boolean test(Class<?> matcherType) {
            Annotation[] annoByType1 = matcherType.getAnnotationsByType(this.annotationType);
            if (annoByType1 != null && annoByType1.length > 0) {
                return true;
            }
            Annotation[] annoByType2 = (Annotation[])Arrays.stream(matcherType.getMethods()).flatMap(method -> Arrays.stream(method.getAnnotationsByType(this.annotationType))).toArray(Annotation[]::new);
            if (annoByType2.length > 0) {
                return true;
            }
            Annotation[] annoByType3 = (Annotation[])Arrays.stream(matcherType.getDeclaredMethods()).flatMap(method -> Arrays.stream(method.getAnnotationsByType(this.annotationType))).toArray(Annotation[]::new);
            return annoByType3.length > 0;
        }

        public boolean equals(Object other) {
            return other instanceof ClassAnnotationOf && ((ClassAnnotationOf)other).annotationType.equals(this.annotationType);
        }

        public int hashCode() {
            return 37 * this.annotationType.hashCode();
        }

        public String toString() {
            return "ClassAnnotationOf(" + this.annotationType.getSimpleName() + ".class)";
        }
    }

    private static class SubClassesOf
    implements Predicate<Class<?>> {
        private final Class<?> superclass;

        public SubClassesOf(Class<?> superclass) {
            this.superclass = Objects.requireNonNull(superclass, "superclass");
        }

        @Override
        public boolean test(Class<?> subclass) {
            return this.superclass.isAssignableFrom(subclass);
        }

        public boolean equals(Object other) {
            return other instanceof SubClassesOf && ((SubClassesOf)other).superclass.equals(this.superclass);
        }

        public int hashCode() {
            return 37 * this.superclass.hashCode();
        }

        public String toString() {
            return "SubClassesOf(" + this.superclass.getSimpleName() + ".class)";
        }
    }

    private static class ClassOf
    implements Predicate<Class<?>> {
        private final MatchUtils.MatchTypeEnum matchTypeEnum;
        private final String matcherExpression;

        public ClassOf(MatchUtils.MatchTypeEnum matchTypeEnum, String matcherExpression) {
            this.matchTypeEnum = matchTypeEnum;
            this.matcherExpression = matcherExpression;
        }

        @Override
        public boolean test(Class<?> target) {
            return MatchUtils.wildToRegex(this.matcherExpression, target.getName(), this.matchTypeEnum);
        }

        public boolean equals(Object other) {
            if (other instanceof ClassOf) {
                MatchUtils.MatchTypeEnum otherMatchTypeEnum = ((ClassOf)other).matchTypeEnum;
                String otherMatcherExpression = ((ClassOf)other).matcherExpression;
                return this.matchTypeEnum.equals((Object)otherMatchTypeEnum) && this.matcherExpression.equals(otherMatcherExpression);
            }
            return false;
        }

        public int hashCode() {
            return 37 * this.matcherExpression.hashCode() * this.matchTypeEnum.hashCode();
        }

        public String toString() {
            return "ClassOf(" + this.matchTypeEnum.name() + ")";
        }
    }

    private static class MethodOf
    implements Predicate<Method> {
        private final MatchUtils.MatchTypeEnum matchTypeEnum;
        private final String matcherExpression;

        public MethodOf(MatchUtils.MatchTypeEnum matchTypeEnum, String matcherExpression) {
            this.matchTypeEnum = matchTypeEnum;
            this.matcherExpression = matcherExpression;
        }

        @Override
        public boolean test(Method target) {
            String methodStr = ClassUtils.getDescNameWithOutModifiers(target);
            return MatchUtils.wildToRegex(this.matcherExpression, methodStr, this.matchTypeEnum);
        }

        public boolean equals(Object other) {
            if (other instanceof MethodOf) {
                MatchUtils.MatchTypeEnum otherMatchTypeEnum = ((MethodOf)other).matchTypeEnum;
                String otherMatcherExpression = ((MethodOf)other).matcherExpression;
                return this.matchTypeEnum.equals((Object)otherMatchTypeEnum) && this.matcherExpression.equals(otherMatcherExpression);
            }
            return false;
        }

        public int hashCode() {
            return 37 * this.matcherExpression.hashCode() * this.matchTypeEnum.hashCode();
        }

        public String toString() {
            return "MethodOf(" + this.matchTypeEnum.name() + ")";
        }
    }
}

