/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.dynamic;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.asm.ClassWriter;
import net.hasor.cobble.asm.FieldVisitor;
import net.hasor.cobble.asm.Label;
import net.hasor.cobble.asm.MethodVisitor;
import net.hasor.cobble.asm.Type;
import net.hasor.cobble.dynamic.AsmTools;
import net.hasor.cobble.dynamic.BasicObject;
import net.hasor.cobble.dynamic.DynamicClass;
import net.hasor.cobble.dynamic.DynamicConfig;
import net.hasor.cobble.dynamic.DynamicObject;
import net.hasor.cobble.dynamic.InvokerDynamicProperty;
import net.hasor.cobble.dynamic.InvokerImplementInvocation;
import net.hasor.cobble.dynamic.InvokerMethodInvocation;
import net.hasor.cobble.dynamic.JdkWeakCache;
import net.hasor.cobble.dynamic.Matchers;
import net.hasor.cobble.dynamic.MethodInterceptor;
import net.hasor.cobble.dynamic.ProxyFactory;
import net.hasor.cobble.dynamic.ReadWriteType;

public final class Proxy {
    private static final AtomicLong spinIndex = new AtomicLong(0L);
    private static final String aopClassSuffix = "$proxy$";
    private static final String aopMethodSuffix = "redirect$";
    private static final JdkWeakCache<ClassLoader, DynamicConfig, Class<?>> proxyClassCache = new JdkWeakCache(new KeyFactory(), new ProxyClassFactory());
    private static final JdkWeakCache<ClassLoader, DynamicConfig, Class<?>> dynamicClassCache = new JdkWeakCache(new KeyFactory(), new DynamicClassFactory());
    private static final Method defineClassMethod;

    private static Class<?> realSuperType(Class<?> superType) {
        if (Proxy.isDynamicClass(superType)) {
            return Proxy.getPrototypeType(superType);
        }
        return superType;
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        try {
            return Proxy.newProxyClass(loader, interfaces, handler).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    public static Class<?> newProxyClass(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        if (interfaces.length == 0 || handler == null) {
            throw new IllegalStateException("no interfaces or handler is specified.");
        }
        Class superClass = null;
        for (Class<?> inter : interfaces) {
            if (inter.isInterface()) continue;
            if (superClass != null) {
                throw new IllegalArgumentException("only one base class is allowed.");
            }
            superClass = inter;
        }
        superClass = superClass == null ? BasicObject.class : superClass;
        DynamicConfig config = new DynamicConfig(superClass, handler);
        for (Class<?> inter : interfaces) {
            if (superClass == inter) continue;
            if (!inter.isInterface()) {
                throw new IllegalArgumentException("interfaces type " + inter + " is not interface.");
            }
            config.addImplements(inter, handler);
        }
        return Proxy.buildProxyClass(loader, config);
    }

    public static <T> T newProxyInstance(ClassLoader loader, T instance, Class<?>[] interfaces, MethodInterceptor ... interceptors) {
        Objects.requireNonNull(instance, "instance is null.");
        if (interfaces == null || interfaces.length == 0) {
            throw new NullPointerException("interfaces is null.");
        }
        LinkedList<Predicate<Method>> matcherList = new LinkedList<Predicate<Method>>();
        for (Class<?> face : interfaces) {
            if (!face.isInstance(instance)) continue;
            matcherList.add(Matchers.anyMethod(face));
        }
        return Proxy.newProxyInstance(loader, instance, (Method method) -> {
            for (Predicate p : matcherList) {
                if (!p.test(method)) continue;
                return true;
            }
            return false;
        }, interceptors);
    }

    public static <T> T newProxyInstance(ClassLoader loader, T instance, Predicate<Method> matchers, MethodInterceptor ... interceptors) {
        Objects.requireNonNull(instance, "instance is null.");
        Objects.requireNonNull(matchers, "matchers is null.");
        DynamicConfig config = new DynamicConfig(Proxy.realSuperType(instance.getClass()));
        config.addAopInterceptor(matchers, interceptors);
        if (!config.hasChange()) {
            return instance;
        }
        Class<?> buildClass = Proxy.buildInstanceClass(loader, config);
        Constructor<?> constructor = buildClass.getConstructors()[0];
        try {
            return (T)constructor.newInstance(instance);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    public static <T> T newProxyInstance(ClassLoader loader, T instance) {
        Objects.requireNonNull(instance, "instance is null.");
        try {
            DynamicConfig config = new DynamicConfig(Proxy.realSuperType(instance.getClass()));
            config.loadAnnotation();
            if (!config.hasChange()) {
                return instance;
            }
            Class<?> buildClass = Proxy.buildInstanceClass(loader, config);
            Constructor<?> constructor = buildClass.getConstructors()[0];
            return (T)constructor.newInstance(instance);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    public static <T> T newProxyInstance(T instance, Class<?>[] interfaces, MethodInterceptor ... interceptors) {
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance, interfaces, interceptors);
    }

    public static <T> T newProxyInstance(T instance, Predicate<Method> matchers, MethodInterceptor ... interceptors) {
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance, matchers, interceptors);
    }

    public static <T> T newProxyInstance(T instance) {
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance);
    }

    public static Class<?> newProxyClass(ClassLoader loader, Class<?> superType, Class<?>[] interfaces, MethodInterceptor ... interceptors) {
        Objects.requireNonNull(superType, "superType is null.");
        if (interfaces == null || interfaces.length == 0) {
            throw new NullPointerException("interfaces is null.");
        }
        LinkedList<Predicate<Method>> matcherList = new LinkedList<Predicate<Method>>();
        for (Class<?> face : interfaces) {
            if (!face.isAssignableFrom(superType)) continue;
            matcherList.add(Matchers.anyMethod(face));
        }
        return Proxy.newProxyClass(loader, superType, method -> {
            for (Predicate p : matcherList) {
                if (!p.test(method)) continue;
                return true;
            }
            return false;
        }, interceptors);
    }

    public static Class<?> newProxyClass(ClassLoader loader, Class<?> superType, Predicate<Method> methodMatcher, MethodInterceptor ... interceptors) {
        Objects.requireNonNull(superType, "instance is null.");
        Objects.requireNonNull(methodMatcher, "methodMatcher is null.");
        if (interceptors == null || interceptors.length == 0) {
            return superType;
        }
        DynamicConfig config = new DynamicConfig(Proxy.realSuperType(superType));
        for (MethodInterceptor interceptor : interceptors) {
            config.addAopInterceptor(methodMatcher, interceptor);
        }
        if (!config.hasChange()) {
            return superType;
        }
        return dynamicClassCache.get(loader, config);
    }

    public static Class<?> newProxyClass(ClassLoader loader, Class<?> superType) {
        Objects.requireNonNull(superType, "instance is null.");
        try {
            DynamicConfig config = new DynamicConfig(Proxy.realSuperType(superType));
            config.loadAnnotation();
            if (!config.hasChange()) {
                return superType;
            }
            return dynamicClassCache.get(loader, config);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    public static <T> ProxyFactory<T> newProxyFactory(ClassLoader loader, DynamicConfig config) {
        Class<?> buildClass = Proxy.buildInstanceClass(loader, config);
        return o -> {
            Constructor<?> constructor = buildClass.getConstructors()[0];
            return constructor.newInstance(o);
        };
    }

    public static Class<?> buildInstanceClass(ClassLoader loader, DynamicConfig config) {
        return proxyClassCache.get(loader, config);
    }

    public static Class<?> buildProxyClass(ClassLoader loader, DynamicConfig config) {
        return dynamicClassCache.get(loader, config);
    }

    private static Class<?> buildAndLoadClass(DynamicConfig config, boolean isProxy, ClassLoader loader) throws ReflectiveOperationException {
        String className = Proxy.getClassName(config);
        byte[] classBytes = Proxy.buildClassBytes(config, className, isProxy);
        Proxy.logClassBytes(className, classBytes, config.getDebugOutputDir());
        Class buildType = (Class)defineClassMethod.invoke((Object)loader, className, classBytes, 0, classBytes.length);
        Field dynamicConfig = buildType.getDeclaredField("dynamicConfig");
        dynamicConfig.setAccessible(true);
        dynamicConfig.set(null, config);
        return buildType;
    }

    private static void logClassBytes(String className, byte[] classBytes, File debugOutputFile) {
        if (debugOutputFile == null) {
            return;
        }
        try {
            String classFullPath = className.replace(".", String.valueOf(File.separatorChar)) + ".class";
            File outFile = new File(debugOutputFile, classFullPath);
            outFile.getParentFile().mkdirs();
            try (FileOutputStream fos = new FileOutputStream(outFile, false);){
                fos.write(classBytes);
                fos.flush();
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    private static String getClassName(DynamicConfig config) {
        String specialNamePrefix = config.getSpecialNamePrefix();
        specialNamePrefix = StringUtils.isBlank(specialNamePrefix) ? "" : specialNamePrefix + ".";
        return specialNamePrefix + config.getSuperClass().getName() + aopClassSuffix + spinIndex.getAndIncrement();
    }

    private static byte[] buildClassBytes(DynamicConfig config, String newClassName, boolean isProxy) throws ReflectiveOperationException {
        List<String> dynamicMethods;
        String thisClassName = AsmTools.replaceClassName(newClassName);
        String superClassName = AsmTools.replaceClassName(config.getSuperClass());
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        ArrayList<String> writerMethod = new ArrayList<String>();
        interfaces.add(AsmTools.replaceClassName(DynamicClass.class));
        config.getImplementMap().keySet().stream().filter(Class::isInterface).forEach(c -> interfaces.add(AsmTools.replaceClassName(c)));
        interfaces.remove(AsmTools.replaceClassName(config.getSuperClass()));
        if (isProxy) {
            interfaces.add(AsmTools.replaceClassName(DynamicObject.class));
        }
        ClassWriter classWriter = new ClassWriter(2);
        classWriter.visit(50, 33, thisClassName, null, superClassName, interfaces.toArray(new String[0]));
        FieldVisitor fdc = classWriter.visitField(10, "dynamicConfig", AsmTools.toAsmType(DynamicConfig.class), null, null);
        fdc.visitEnd();
        if (isProxy) {
            Proxy.buildConstructorForProxy(config, classWriter, thisClassName, superClassName);
        } else {
            Proxy.buildConstructorForBuild(config, classWriter, thisClassName, superClassName);
        }
        Map<String, Integer> indexMap = Proxy.buildStatic(config, classWriter, thisClassName, isProxy);
        for (Map.Entry<String, Method> entry : config.getInterceptorMethods().entrySet()) {
            dynamicMethods = Proxy.buildDynamicMethod(entry.getKey(), entry.getValue(), indexMap, classWriter, superClassName, thisClassName, isProxy);
            writerMethod.addAll(dynamicMethods);
        }
        for (Map.Entry<String, Object> entry : config.getDynamicPropertyMap().entrySet()) {
            dynamicMethods = Proxy.buildDynamicProperty(entry.getKey(), (DynamicConfig.DynamicPropertyInfo)entry.getValue(), classWriter, newClassName, thisClassName, isProxy);
            writerMethod.addAll(dynamicMethods);
        }
        for (Map.Entry<Object, Object> entry : config.getImplementMap().entrySet()) {
            String methodDescriptor;
            String methodName;
            Class faceType = (Class)entry.getKey();
            if (faceType == config.getSuperClass()) {
                for (Method implMethod : faceType.getMethods()) {
                    if (!Modifier.isAbstract(implMethod.getModifiers())) continue;
                    methodName = implMethod.getName();
                    methodDescriptor = AsmTools.toAsmDesc(implMethod);
                    if (writerMethod.contains(methodName + methodDescriptor)) continue;
                    writerMethod.add(methodName + methodDescriptor);
                    Proxy.buildDynamicImpl(faceType, implMethod, indexMap, classWriter, thisClassName, isProxy);
                }
                continue;
            }
            if (faceType.isInterface()) {
                for (Method implMethod : faceType.getMethods()) {
                    methodName = implMethod.getName();
                    methodDescriptor = AsmTools.toAsmDesc(implMethod);
                    if (writerMethod.contains(methodName + methodDescriptor)) continue;
                    writerMethod.add(methodName + methodDescriptor);
                    Proxy.buildDynamicImpl(faceType, implMethod, indexMap, classWriter, thisClassName, isProxy);
                }
                continue;
            }
            throw new RuntimeException("Internal error.");
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static Map<String, Integer> buildStatic(DynamicConfig config, ClassWriter classWriter, String thisClassName, boolean isProxy) throws NoSuchMethodException {
        int i;
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        ArrayList implClassList = new ArrayList(config.getImplementMap().keySet());
        long arraySize = (long)config.getInterceptorMap().size() + implClassList.stream().flatMap(t -> Arrays.stream(t.getMethods())).count();
        if (arraySize > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("there are too many ways to method.");
        }
        if (!isProxy) {
            FieldVisitor fv1 = classWriter.visitField(10, "proxyMethod", AsmTools.toAsmType(Method[].class), null, null);
            fv1.visitEnd();
        }
        FieldVisitor fv2 = classWriter.visitField(10, "targetMethod", AsmTools.toAsmType(Method[].class), null, null);
        fv2.visitEnd();
        int superClassIndex = 0;
        int thisClassIndex = 1;
        int implsClassIndex = 2;
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label tryStartLabel = new Label();
        Label tryStartCodeLabel = new Label();
        Label tryCacheLabel = new Label();
        Label tryEndLabel = new Label();
        Label returnLabel = new Label();
        Label cacheStartCodeLabel = new Label();
        mv.visitTryCatchBlock(tryStartLabel, tryCacheLabel, tryEndLabel, AsmTools.replaceClassName(Throwable.class));
        mv.visitLabel(tryStartLabel);
        mv.visitLdcInsn(Type.getType(AsmTools.toAsmType(config.getSuperClass())));
        mv.visitVarInsn(58, superClassIndex);
        mv.visitLdcInsn(Type.getType("L" + thisClassName + ";"));
        mv.visitVarInsn(58, thisClassIndex);
        mv.visitIntInsn(16, implClassList.size());
        mv.visitTypeInsn(189, AsmTools.replaceClassName(Class.class));
        for (i = 0; i < implClassList.size(); ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitLdcInsn(Type.getType("L" + AsmTools.replaceClassName((Class)implClassList.get(i)) + ";"));
            mv.visitInsn(83);
        }
        mv.visitVarInsn(58, implsClassIndex);
        mv.visitLabel(tryStartCodeLabel);
        mv.visitIntInsn(16, (int)arraySize);
        mv.visitTypeInsn(189, AsmTools.replaceClassName(Method.class));
        mv.visitFieldInsn(179, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
        if (!isProxy) {
            mv.visitIntInsn(16, (int)arraySize);
            mv.visitTypeInsn(189, AsmTools.replaceClassName(Method.class));
            mv.visitFieldInsn(179, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
        }
        i = -1;
        String getMethodDesc = AsmTools.toAsmDesc(Class.class.getMethod("getMethod", String.class, Class[].class));
        for (Map.Entry<String, Method> entry : config.getInterceptorMethods().entrySet()) {
            Method aopMethod = entry.getValue();
            String asmMethodName = aopMethod.getName();
            String[] parameterTypes = AsmTools.splitAsmType(AsmTools.toAsmType(aopMethod.getParameterTypes()));
            indexMap.put(AsmTools.toAsmFullDesc(aopMethod), ++i);
            mv.visitFieldInsn(178, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
            mv.visitIntInsn(16, i);
            mv.visitVarInsn(25, superClassIndex);
            mv.visitLdcInsn(asmMethodName);
            AsmTools.codeBuilder_2(mv, parameterTypes);
            mv.visitMethodInsn(182, AsmTools.replaceClassName(Class.class), "getMethod", getMethodDesc, false);
            mv.visitInsn(83);
            mv.visitFieldInsn(178, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            mv.visitInsn(4);
            mv.visitMethodInsn(182, AsmTools.replaceClassName(Method.class), "setAccessible", "(Z)V", false);
            if (isProxy) continue;
            mv.visitFieldInsn(178, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
            mv.visitIntInsn(16, i);
            mv.visitVarInsn(25, thisClassIndex);
            mv.visitLdcInsn(aopMethodSuffix + asmMethodName);
            AsmTools.codeBuilder_2(mv, parameterTypes);
            mv.visitMethodInsn(182, AsmTools.replaceClassName(Class.class), "getDeclaredMethod", getMethodDesc, false);
            mv.visitInsn(83);
            mv.visitFieldInsn(178, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            mv.visitInsn(4);
            mv.visitMethodInsn(182, AsmTools.replaceClassName(Method.class), "setAccessible", "(Z)V", false);
        }
        for (Class clazz : implClassList) {
            String classType = AsmTools.toAsmType(clazz);
            for (Method entMethod : clazz.getMethods()) {
                String asmMethodName = entMethod.getName();
                String[] parameterTypes = AsmTools.splitAsmType(AsmTools.toAsmType(entMethod.getParameterTypes()));
                indexMap.put(classType + "." + AsmTools.toAsmFullDesc(entMethod), ++i);
                int implIndex = implClassList.indexOf(clazz);
                mv.visitFieldInsn(178, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
                mv.visitIntInsn(16, i);
                mv.visitVarInsn(25, thisClassIndex);
                mv.visitLdcInsn(asmMethodName);
                AsmTools.codeBuilder_2(mv, parameterTypes);
                mv.visitMethodInsn(182, AsmTools.replaceClassName(Class.class), "getMethod", getMethodDesc, false);
                mv.visitInsn(83);
                mv.visitFieldInsn(178, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
                mv.visitIntInsn(16, i);
                mv.visitVarInsn(25, implsClassIndex);
                mv.visitIntInsn(16, implIndex);
                mv.visitInsn(50);
                mv.visitLdcInsn(asmMethodName);
                AsmTools.codeBuilder_2(mv, parameterTypes);
                mv.visitMethodInsn(182, AsmTools.replaceClassName(Class.class), "getMethod", getMethodDesc, false);
                mv.visitInsn(83);
            }
        }
        mv.visitLabel(tryCacheLabel);
        mv.visitJumpInsn(167, returnLabel);
        mv.visitLabel(tryEndLabel);
        mv.visitFrame(4, 0, null, 1, new Object[]{AsmTools.replaceClassName(Throwable.class)});
        mv.visitVarInsn(58, 0);
        mv.visitLabel(cacheStartCodeLabel);
        mv.visitVarInsn(25, 0);
        String exceptionMethodDesc = AsmTools.toAsmDesc(ExceptionUtils.class.getMethod("toRuntime", Throwable.class));
        mv.visitMethodInsn(184, AsmTools.replaceClassName(ExceptionUtils.class), "toRuntime", exceptionMethodDesc, false);
        mv.visitInsn(191);
        mv.visitLabel(returnLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitLocalVariable("superClass", AsmTools.toAsmType(Class.class), "Ljava/lang/Class<*>;", tryStartLabel, tryCacheLabel, 0);
        mv.visitLocalVariable("thisClass", AsmTools.toAsmType(Class.class), "Ljava/lang/Class<*>;", tryStartLabel, tryCacheLabel, 1);
        mv.visitLocalVariable("implClass", "[Ljava/lang/Class;", "[Ljava/lang/Class<*>;", tryStartLabel, tryCacheLabel, 2);
        mv.visitMaxs(8, 1);
        mv.visitEnd();
        return indexMap;
    }

    private static void buildConstructorForBuild(DynamicConfig config, ClassWriter classWriter, String thisClassName, String superClassName) {
        Constructor<?>[] constructorArray = config.getSuperClass().getConstructors();
        if (constructorArray.length == 0) {
            MethodVisitor mv = classWriter.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(4, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, superClassName, "<init>", "()V", false);
            mv.visitInsn(177);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + thisClassName + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        for (Constructor<?> constructor : constructorArray) {
            int i;
            String[] asmParams = AsmTools.splitAsmType(AsmTools.toAsmType(constructor.getParameterTypes()));
            String[] throwStrArray = AsmTools.replaceClassName(constructor.getExceptionTypes());
            String paramsStr = "(" + AsmTools.toAsmType(constructor.getParameterTypes()) + ")V";
            AtomicInteger variableIndexCounters = new AtomicInteger(0);
            LinkedHashMap<String, Integer> paramIndexMap = new LinkedHashMap<String, Integer>();
            paramIndexMap.put("this", 0);
            for (int i2 = 0; i2 < asmParams.length; ++i2) {
                paramIndexMap.put("args" + i2, variableIndexCounters.incrementAndGet());
                if ("D".equals(asmParams[i2])) {
                    variableIndexCounters.incrementAndGet();
                }
                if (!"J".equals(asmParams[i2])) continue;
                variableIndexCounters.incrementAndGet();
            }
            Label startBlock = new Label();
            Label endBlock = new Label();
            MethodVisitor mv = classWriter.visitMethod(1, "<init>", paramsStr, null, throwStrArray);
            mv.visitCode();
            mv.visitLabel(startBlock);
            mv.visitVarInsn(25, (Integer)paramIndexMap.get("this"));
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (i = 0; i < parameterTypes.length; ++i) {
                mv.visitVarInsn(AsmTools.getLoad(AsmTools.toAsmType(parameterTypes[i])), (Integer)paramIndexMap.get("args" + i));
            }
            mv.visitMethodInsn(183, superClassName, "<init>", paramsStr, false);
            mv.visitInsn(177);
            mv.visitLabel(endBlock);
            mv.visitLocalVariable("this", "L" + thisClassName + ";", null, startBlock, endBlock, (Integer)paramIndexMap.get("this"));
            for (i = 0; i < parameterTypes.length; ++i) {
                mv.visitLocalVariable("args" + i, AsmTools.toAsmType(parameterTypes[i]), null, startBlock, endBlock, (Integer)paramIndexMap.get("args" + i));
            }
            int maxStack = parameterTypes.length + 1;
            mv.visitMaxs(maxStack, maxStack);
            mv.visitEnd();
        }
    }

    private static void buildConstructorForProxy(DynamicConfig config, ClassWriter classWriter, String thisClassName, String superClassName) {
        String superClassRef = "L" + superClassName + ";";
        String thisClassRef = "L" + thisClassName + ";";
        FieldVisitor fv1 = classWriter.visitField(2, "proxy", superClassRef, null, null);
        fv1.visitEnd();
        Label startBlock = new Label();
        Label endBlock = new Label();
        MethodVisitor mv = classWriter.visitMethod(1, "<init>", "(" + superClassRef + ")V", null, null);
        mv.visitCode();
        mv.visitCode();
        mv.visitLabel(startBlock);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClassName, "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, thisClassName, "proxy", superClassRef);
        mv.visitInsn(177);
        mv.visitLabel(endBlock);
        mv.visitLocalVariable("this", thisClassRef, null, startBlock, endBlock, 0);
        mv.visitLocalVariable("proxy", superClassRef, null, startBlock, endBlock, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        startBlock = new Label();
        endBlock = new Label();
        mv = classWriter.visitMethod(1, "getOriginalObject", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, thisClassName, "proxy", superClassRef);
        mv.visitInsn(176);
        mv.visitLocalVariable("this", thisClassRef, null, startBlock, endBlock, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static List<String> buildDynamicMethod(String aopMethodKey, Method aopMethod, Map<String, Integer> indexMap, ClassWriter classWriter, String superClassName, String thisClassName, boolean isProxy) throws NoSuchMethodException {
        String[] asmParams = AsmTools.splitAsmType(AsmTools.toAsmType(aopMethod.getParameterTypes()));
        String[] throwStrArray = AsmTools.replaceClassName(aopMethod.getExceptionTypes());
        ArrayList<String> outputMethod = new ArrayList<String>();
        AtomicInteger variableIndexCounters = new AtomicInteger(0);
        LinkedHashMap<String, Integer> paramIndexMap = new LinkedHashMap<String, Integer>();
        paramIndexMap.put("this", 0);
        for (int i = 0; i < asmParams.length; ++i) {
            paramIndexMap.put("args" + i, variableIndexCounters.incrementAndGet());
            if ("D".equals(asmParams[i])) {
                variableIndexCounters.incrementAndGet();
            }
            if (!"J".equals(asmParams[i])) continue;
            variableIndexCounters.incrementAndGet();
        }
        if (!isProxy) {
            String methodName = aopMethodSuffix + aopMethod.getName();
            String methodDesc = AsmTools.toAsmDesc(aopMethod);
            outputMethod.add(methodName + methodDesc);
            MethodVisitor replacementVisitor = classWriter.visitMethod(18, methodName, methodDesc, AsmTools.toAsmSignature(aopMethod), throwStrArray);
            replacementVisitor.visitCode();
            replacementVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < asmParams.length; ++i) {
                replacementVisitor.visitVarInsn(AsmTools.getLoad(asmParams[i]), (Integer)paramIndexMap.get("args" + i));
            }
            replacementVisitor.visitMethodInsn(183, superClassName, aopMethod.getName(), AsmTools.toAsmDesc(aopMethod), false);
            replacementVisitor.visitInsn(AsmTools.getReturn(AsmTools.toAsmType(aopMethod.getReturnType())));
            replacementVisitor.visitMaxs(-1, -1);
            replacementVisitor.visitEnd();
        }
        int paramsIndexMark = variableIndexCounters.get();
        paramIndexMap.put("paramObjects", variableIndexCounters.incrementAndGet());
        paramIndexMap.put("returnData", variableIndexCounters.incrementAndGet());
        paramIndexMap.put("e", paramsIndexMark + 1);
        Label tryStartLabel = new Label();
        Label tryCacheLabel = new Label();
        Label tryEndLabel = new Label();
        Label paramObjectsLabel = new Label();
        Label returnDataLabel = new Label();
        Label returnLabel = new Label();
        Label eLabel = new Label();
        String methodName = aopMethod.getName();
        String methodDesc = AsmTools.toAsmDesc(aopMethod);
        outputMethod.add(methodName + methodDesc);
        MethodVisitor mv = classWriter.visitMethod(1, methodName, methodDesc, AsmTools.toAsmSignature(aopMethod), throwStrArray);
        mv.visitCode();
        mv.visitTryCatchBlock(tryStartLabel, tryCacheLabel, tryEndLabel, AsmTools.replaceClassName(Throwable.class));
        mv.visitLabel(tryStartLabel);
        if (asmParams.length == 0) {
            mv.visitInsn(1);
        } else {
            AsmTools.codeBuilder_1(mv, asmParams, paramIndexMap);
        }
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("paramObjects"));
        mv.visitLabel(paramObjectsLabel);
        mv.visitTypeInsn(187, AsmTools.replaceClassName(InvokerMethodInvocation.class));
        mv.visitInsn(89);
        mv.visitInsn(isProxy ? 4 : 3);
        mv.visitLdcInsn(aopMethodKey);
        mv.visitFieldInsn(178, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
        mv.visitIntInsn(16, indexMap.get(AsmTools.toAsmFullDesc(aopMethod)));
        mv.visitInsn(50);
        if (!isProxy) {
            mv.visitFieldInsn(178, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
            mv.visitIntInsn(16, indexMap.get(AsmTools.toAsmFullDesc(aopMethod)));
            mv.visitInsn(50);
        } else {
            mv.visitInsn(1);
        }
        mv.visitFieldInsn(178, thisClassName, "dynamicConfig", AsmTools.toAsmType(DynamicConfig.class));
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("this"));
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("paramObjects"));
        String initDesc = AsmTools.toAsmType(InvokerMethodInvocation.class.getConstructor(Boolean.TYPE, String.class, Method.class, Method.class, DynamicConfig.class, Object.class, Object[].class).getParameterTypes());
        mv.visitMethodInsn(183, AsmTools.replaceClassName(InvokerMethodInvocation.class), "<init>", "(" + initDesc + ")V", false);
        mv.visitMethodInsn(182, AsmTools.replaceClassName(InvokerMethodInvocation.class), "proceed", "()Ljava/lang/Object;", false);
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("returnData"));
        mv.visitLabel(returnDataLabel);
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("returnData"));
        AsmTools.codeBuilder_3(mv, AsmTools.toAsmType(aopMethod.getReturnType()), tryCacheLabel);
        mv.visitLabel(tryEndLabel);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("e"));
        mv.visitLabel(eLabel);
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("e"));
        String exceptionMethodDesc = AsmTools.toAsmDesc(ExceptionUtils.class.getMethod("toRuntime", Throwable.class));
        mv.visitMethodInsn(184, AsmTools.replaceClassName(ExceptionUtils.class), "toRuntime", exceptionMethodDesc, false);
        mv.visitInsn(191);
        mv.visitLabel(returnLabel);
        mv.visitLocalVariable("paramObjects", "[Ljava/lang/Object;", null, paramObjectsLabel, tryEndLabel, (Integer)paramIndexMap.get("paramObjects"));
        mv.visitLocalVariable("returnData", "Ljava/lang/Object;", null, returnDataLabel, tryEndLabel, (Integer)paramIndexMap.get("returnData"));
        mv.visitLocalVariable("e", "Ljava/lang/Throwable;", null, eLabel, returnLabel, (Integer)paramIndexMap.get("e"));
        mv.visitLocalVariable("this", "L" + thisClassName + ";", null, tryStartLabel, returnLabel, (Integer)paramIndexMap.get("this"));
        for (int i = 0; i < asmParams.length; ++i) {
            mv.visitLocalVariable("args" + i, asmParams[i], null, tryStartLabel, returnLabel, (Integer)paramIndexMap.get("args" + i));
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        return outputMethod;
    }

    private static List<String> buildDynamicProperty(String propertyName, DynamicConfig.DynamicPropertyInfo propertyInfo, ClassWriter classWriter, String newClassName, String thisClassName, boolean isProxy) throws NoSuchMethodException {
        ArrayList<String> outputMethod = new ArrayList<String>();
        String asmType = AsmTools.toAsmType(propertyInfo.propertyType);
        Label sLabel = new Label();
        Label eLabel = new Label();
        String methodName = (propertyInfo.propertyType == Boolean.TYPE ? "is" : "get") + StringUtils.firstCharToUpperCase(propertyName);
        String methodDescriptor = "()" + asmType;
        Method propertyMethod = InvokerDynamicProperty.class.getMethod("getProperty", Boolean.TYPE, DynamicConfig.class, String.class, Object.class, String.class);
        outputMethod.add(methodName + methodDescriptor);
        MethodVisitor mv = classWriter.visitMethod(1, methodName, methodDescriptor, null, new String[]{"java/lang/Throwable"});
        mv.visitLabel(sLabel);
        mv.visitInsn(isProxy ? 4 : 3);
        mv.visitFieldInsn(178, thisClassName, "dynamicConfig", AsmTools.toAsmType(DynamicConfig.class));
        mv.visitLdcInsn(newClassName + "_get_" + propertyName);
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(propertyName);
        mv.visitMethodInsn(184, AsmTools.replaceClassName(InvokerDynamicProperty.class), propertyMethod.getName(), AsmTools.toAsmDesc(propertyMethod), false);
        AsmTools.codeBuilder_Cast(mv, asmType, null);
        mv.visitInsn(AsmTools.getReturn(asmType));
        mv.visitLabel(eLabel);
        mv.visitLocalVariable("this", AsmTools.toAsmType(InvokerDynamicProperty.class), null, sLabel, eLabel, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        if (propertyInfo.rwType == ReadWriteType.ReadWrite) {
            sLabel = new Label();
            eLabel = new Label();
            methodName = "set" + StringUtils.firstCharToUpperCase(propertyName);
            methodDescriptor = "(" + asmType + ")V";
            propertyMethod = InvokerDynamicProperty.class.getMethod("setProperty", Boolean.TYPE, DynamicConfig.class, String.class, Object.class, String.class, Object.class);
            outputMethod.add(methodName + methodDescriptor);
            mv = classWriter.visitMethod(1, methodName, methodDescriptor, null, new String[]{"java/lang/Throwable"});
            mv.visitCode();
            mv.visitLabel(sLabel);
            mv.visitInsn(isProxy ? 4 : 3);
            mv.visitFieldInsn(178, thisClassName, "dynamicConfig", AsmTools.toAsmType(DynamicConfig.class));
            mv.visitLdcInsn(newClassName + "_set_" + propertyName);
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(propertyName);
            mv.visitVarInsn(AsmTools.getLoad(asmType), 1);
            AsmTools.codeBuilder_valueOf(mv, AsmTools.toAsmType(propertyInfo.propertyType));
            mv.visitMethodInsn(184, AsmTools.replaceClassName(InvokerDynamicProperty.class), propertyMethod.getName(), AsmTools.toAsmDesc(propertyMethod), false);
            mv.visitInsn(177);
            mv.visitLabel(eLabel);
            mv.visitLocalVariable("this", AsmTools.toAsmType(InvokerDynamicProperty.class), null, sLabel, eLabel, 0);
            mv.visitLocalVariable(propertyName, AsmTools.toAsmType(Object.class), null, sLabel, eLabel, 1);
            mv.visitMaxs(4, 2);
            mv.visitEnd();
        }
        return outputMethod;
    }

    private static void buildDynamicImpl(Class<?> implType, Method implMethod, Map<String, Integer> indexMap, ClassWriter classWriter, String thisClassName, boolean isProxy) throws NoSuchMethodException {
        String methodKey = AsmTools.toAsmType(implType) + "." + AsmTools.toAsmFullDesc(implMethod);
        String[] asmParams = AsmTools.splitAsmType(AsmTools.toAsmType(implMethod.getParameterTypes()));
        String[] throwStrArray = AsmTools.replaceClassName(implMethod.getExceptionTypes());
        AtomicInteger variableIndexCounters = new AtomicInteger(0);
        LinkedHashMap<String, Integer> paramIndexMap = new LinkedHashMap<String, Integer>();
        paramIndexMap.put("this", 0);
        for (int i = 0; i < asmParams.length; ++i) {
            paramIndexMap.put("args" + i, variableIndexCounters.incrementAndGet());
            if ("D".equals(asmParams[i])) {
                variableIndexCounters.incrementAndGet();
            }
            if (!"J".equals(asmParams[i])) continue;
            variableIndexCounters.incrementAndGet();
        }
        int paramsIndexMark = variableIndexCounters.get();
        paramIndexMap.put("paramObjects", variableIndexCounters.incrementAndGet());
        paramIndexMap.put("returnData", variableIndexCounters.incrementAndGet());
        paramIndexMap.put("e", paramsIndexMark + 1);
        Label tryStartLabel = new Label();
        Label tryCacheLabel = new Label();
        Label tryEndLabel = new Label();
        Label paramObjectsLabel = new Label();
        Label returnDataLabel = new Label();
        Label returnLabel = new Label();
        Label eLabel = new Label();
        String methodName = implMethod.getName();
        String methodDesc = AsmTools.toAsmDesc(implMethod);
        MethodVisitor mv = classWriter.visitMethod(1, methodName, methodDesc, AsmTools.toAsmSignature(implMethod), throwStrArray);
        mv.visitCode();
        mv.visitTryCatchBlock(tryStartLabel, tryCacheLabel, tryEndLabel, AsmTools.replaceClassName(Throwable.class));
        mv.visitLabel(tryStartLabel);
        if (asmParams.length == 0) {
            mv.visitInsn(1);
        } else {
            AsmTools.codeBuilder_1(mv, asmParams, paramIndexMap);
        }
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("paramObjects"));
        mv.visitLabel(paramObjectsLabel);
        mv.visitTypeInsn(187, AsmTools.replaceClassName(InvokerImplementInvocation.class));
        mv.visitInsn(89);
        mv.visitInsn(isProxy ? 4 : 3);
        mv.visitLdcInsn(Type.getType(AsmTools.toAsmType(implType)));
        mv.visitFieldInsn(178, thisClassName, "targetMethod", AsmTools.toAsmType(Method[].class));
        mv.visitIntInsn(16, indexMap.get(methodKey));
        mv.visitInsn(50);
        mv.visitFieldInsn(178, thisClassName, "proxyMethod", AsmTools.toAsmType(Method[].class));
        mv.visitIntInsn(16, indexMap.get(methodKey));
        mv.visitInsn(50);
        mv.visitFieldInsn(178, thisClassName, "dynamicConfig", AsmTools.toAsmType(DynamicConfig.class));
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("this"));
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("paramObjects"));
        String initDesc = AsmTools.toAsmType(InvokerImplementInvocation.class.getConstructor(Boolean.TYPE, Class.class, Method.class, Method.class, DynamicConfig.class, Object.class, Object[].class).getParameterTypes());
        mv.visitMethodInsn(183, AsmTools.replaceClassName(InvokerImplementInvocation.class), "<init>", "(" + initDesc + ")V", false);
        mv.visitMethodInsn(182, AsmTools.replaceClassName(InvokerImplementInvocation.class), "proceed", "()Ljava/lang/Object;", false);
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("returnData"));
        mv.visitLabel(returnDataLabel);
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("returnData"));
        AsmTools.codeBuilder_3(mv, AsmTools.toAsmType(implMethod.getReturnType()), tryCacheLabel);
        mv.visitLabel(tryEndLabel);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitVarInsn(58, (Integer)paramIndexMap.get("e"));
        mv.visitLabel(eLabel);
        mv.visitVarInsn(25, (Integer)paramIndexMap.get("e"));
        String exceptionMethodDesc = AsmTools.toAsmDesc(ExceptionUtils.class.getMethod("toRuntime", Throwable.class));
        mv.visitMethodInsn(184, AsmTools.replaceClassName(ExceptionUtils.class), "toRuntime", exceptionMethodDesc, false);
        mv.visitInsn(191);
        mv.visitLabel(returnLabel);
        mv.visitLocalVariable("paramObjects", "[Ljava/lang/Object;", null, paramObjectsLabel, tryEndLabel, (Integer)paramIndexMap.get("paramObjects"));
        mv.visitLocalVariable("returnData", "Ljava/lang/Object;", null, returnDataLabel, tryEndLabel, (Integer)paramIndexMap.get("returnData"));
        mv.visitLocalVariable("e", "Ljava/lang/Throwable;", null, eLabel, returnLabel, (Integer)paramIndexMap.get("e"));
        mv.visitLocalVariable("this", "L" + thisClassName + ";", null, tryStartLabel, returnLabel, (Integer)paramIndexMap.get("this"));
        for (int i = 0; i < asmParams.length; ++i) {
            mv.visitLocalVariable("args" + i, asmParams[i], null, tryStartLabel, returnLabel, (Integer)paramIndexMap.get("args" + i));
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    public static Class<?> getPrototypeType(Object instance) {
        if (instance == null) {
            return null;
        }
        Class<?> instanceClass = instance.getClass();
        return Proxy.isDynamicObject(instance) ? instanceClass.getSuperclass() : instanceClass;
    }

    public static Class<?> getPrototypeType(Class<?> targetType) {
        if (targetType == null) {
            return null;
        }
        return Proxy.isDynamicClass(targetType) ? targetType.getSuperclass() : targetType;
    }

    public static boolean isProxyObject(Object instance) {
        return instance instanceof DynamicObject;
    }

    public static boolean isDynamicObject(Object instance) {
        return instance instanceof DynamicClass;
    }

    public static boolean isProxyClass(Class<?> targetType) {
        return targetType != null && DynamicObject.class.isAssignableFrom(targetType);
    }

    public static boolean isDynamicClass(Class<?> targetType) {
        return targetType != null && DynamicClass.class.isAssignableFrom(targetType);
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class DynamicClassFactory
    implements BiFunction<ClassLoader, DynamicConfig, Class<?>> {
        private DynamicClassFactory() {
        }

        @Override
        public Class<?> apply(ClassLoader classLoader, DynamicConfig config) {
            try {
                return Proxy.buildAndLoadClass(config, false, classLoader);
            }
            catch (Exception e) {
                throw new ProxyInvocationException(e);
            }
        }
    }

    private static final class ProxyClassFactory
    implements BiFunction<ClassLoader, DynamicConfig, Class<?>> {
        private ProxyClassFactory() {
        }

        @Override
        public Class<?> apply(ClassLoader classLoader, DynamicConfig config) {
            try {
                return Proxy.buildAndLoadClass(config, true, classLoader);
            }
            catch (Exception e) {
                throw new ProxyInvocationException(e);
            }
        }
    }

    private static class ProxyInvocationException
    extends RuntimeException {
        public ProxyInvocationException(Exception e) {
            super(e.getMessage(), e);
        }
    }

    private static final class Key
    extends WeakReference<DynamicConfig> {
        private final int hash;

        Key(DynamicConfig config) {
            super(config);
            this.hash = config.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            DynamicConfig intf;
            return this == obj || obj != null && obj.getClass() == Key.class && (intf = (DynamicConfig)this.get()) != null && intf == ((Key)obj).get();
        }
    }

    private static final class KeyFactory
    implements BiFunction<ClassLoader, DynamicConfig, Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, DynamicConfig dynamicConfig) {
            return new Key(dynamicConfig);
        }
    }
}

