/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ResourceClassLoader;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.Scanner;

public abstract class AbstractResourceLoader
implements ResourceLoader {
    protected final ClassLoader parentClassLoader;
    private volatile ResourceClassLoader innerClassLoader;

    public AbstractResourceLoader() {
        this.parentClassLoader = null;
    }

    public AbstractResourceLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    protected ResourceLoader loaderForClassLoader() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        if (this.innerClassLoader == null) {
            AbstractResourceLoader abstractResourceLoader = this;
            synchronized (abstractResourceLoader) {
                if (this.innerClassLoader == null) {
                    this.innerClassLoader = new ResourceClassLoader(this.parentClassLoader, this.loaderForClassLoader());
                }
            }
        }
        return this.innerClassLoader.loadClass(className);
    }

    @Override
    public <T> List<T> scanResources(Scanner<T> scanner) throws IOException {
        return this.scanResources(MatchType.None, scanner, new String[0]);
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Scanner<T> scanner) throws IOException {
        return this.scanResources(matchType, scanner, new String[0]);
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Scanner<T> scanner, String[] scanPaths) throws IOException {
        return this.scanResources(matchType, t -> true, scanner, scanPaths);
    }

    @Override
    public <T> T scanOneResource(Scanner<T> scanner) throws IOException {
        return this.scanOneResource(MatchType.None, scanner, new String[0]);
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Scanner<T> scanner) throws IOException {
        return this.scanOneResource(matchType, scanner, new String[0]);
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Scanner<T> scanner, String[] scanPaths) throws IOException {
        return this.scanOneResource(matchType, t -> true, scanner, scanPaths);
    }

    protected <T> Predicate<T>[] buildPredicate(MatchType matchType, String[] scanPaths, Function<T, String> nameFunc) {
        if (matchType == null) {
            throw new IllegalStateException("missing matchType.");
        }
        Predicate[] tests = new Predicate[scanPaths.length];
        block8: for (int i = 0; i < scanPaths.length; ++i) {
            String matchExpr = scanPaths[i];
            switch (matchType) {
                case None: {
                    tests[i] = e -> true;
                    continue block8;
                }
                case Match: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).equals(matchExpr);
                    continue block8;
                }
                case Regex: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).matches(matchExpr);
                    continue block8;
                }
                case ContainsAny: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).contains(matchExpr);
                    continue block8;
                }
                case Prefix: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).startsWith(matchExpr);
                    continue block8;
                }
                case Suffix: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).endsWith(matchExpr);
                    continue block8;
                }
                default: {
                    tests[i] = e -> false;
                }
            }
        }
        return tests;
    }
}

