/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.cobble.asm.AnnotationVisitor;
import net.hasor.cobble.asm.ClassReader;
import net.hasor.cobble.asm.ClassVisitor;
import net.hasor.cobble.loader.ClassMatcher;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.providers.ClassPathResourceLoader;

public class CobbleClassScanner {
    private final ResourceLoader classLoader;
    private final Map<String, ClassMatcher.ClassInfo> classInfoMap = new ConcurrentHashMap<String, ClassMatcher.ClassInfo>();

    public CobbleClassScanner() {
        this.classLoader = new ClassPathResourceLoader();
    }

    public CobbleClassScanner(ResourceLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Set<Class<?>> getClassSet(String[] loadPackages, Class<?> matcherType) {
        return this.getClassSet(loadPackages, (ClassMatcher.ClassMatcherContext context) -> {
            block7: {
                ClassMatcher.ClassInfo classInfo = context.getClassInfo();
                String matcherTypeName = matcherType.getName();
                if (classInfo == null) break block7;
                if (matcherType.isAnnotation()) {
                    for (String anno : classInfo.annos) {
                        if (!anno.equals(matcherTypeName)) continue;
                        return true;
                    }
                } else if (matcherType.isInterface()) {
                    for (String anno : classInfo.interFaces) {
                        if (!anno.equals(matcherTypeName)) continue;
                        return true;
                    }
                } else {
                    for (String castType : classInfo.castType) {
                        if (!castType.equals(matcherTypeName)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public Set<Class<?>> getClassSet(ClassMatcher matcher) {
        return this.getClassSet(new String[0], matcher);
    }

    public Set<Class<?>> getClassSet(String[] loadPackages, ClassMatcher matcher) {
        String[] packages = new String[loadPackages.length];
        for (int i = 0; i < loadPackages.length; ++i) {
            packages[i] = loadPackages[i].replace(".", "/");
        }
        try {
            List<Class> classes = this.classLoader.scanResources(MatchType.Prefix, event -> {
                String className = event.getName();
                if (!className.endsWith(".class")) {
                    return null;
                }
                className = className.substring(0, className.length() - 6);
                className = className.replace("/", ".");
                try {
                    return this.testAndLoad(className, matcher);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }, packages);
            return new HashSet(classes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<?> testAndLoad(String className, ClassMatcher matcher) throws IOException, ClassNotFoundException {
        ClassMatcher.ClassMatcherContext context;
        ClassMatcher.ClassInfo classInfo = null;
        if (this.classInfoMap.containsKey(className)) {
            classInfo = this.classInfoMap.get(className);
        }
        if (classInfo == null) {
            classInfo = this.loadClassInfo(className);
            if (classInfo == null) {
                return null;
            }
            this.classInfoMap.put(className, classInfo);
        }
        if (matcher.matcher(context = new ClassMatcher.ClassMatcherContext(classInfo){

            @Override
            public ClassMatcher.ClassInfo loadClass(String className) throws IOException {
                return CobbleClassScanner.this.loadClassInfo(className);
            }
        })) {
            return this.classLoader.getClass(className);
        }
        return null;
    }

    public ClassMatcher.ClassInfo loadClassInfo(String className) throws IOException {
        try (InputStream classStream = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            if (classStream == null) {
                ClassMatcher.ClassInfo classInfo = null;
                return classInfo;
            }
            ClassMatcher.ClassInfo classInfo = this.loadClassInfo(className, classStream);
            return classInfo;
        }
    }

    private ClassMatcher.ClassInfo loadClassInfo(String className, InputStream inStream) throws IOException {
        ClassReader classReader = new ClassReader(inStream);
        final ClassMatcher.ClassInfo info = new ClassMatcher.ClassInfo();
        classReader.accept(new ClassVisitor(589824){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                info.className = name.replace('/', '.');
                if (superName != null) {
                    info.superName = superName.replace('/', '.');
                }
                info.interFaces = interfaces;
                for (int i = 0; i < info.interFaces.length; ++i) {
                    info.interFaces[i] = info.interFaces[i].replace('/', '.');
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String[] annoArrays = info.annos == null ? new String[]{} : info.annos;
                String[] newAnnoArrays = new String[annoArrays.length + 1];
                System.arraycopy(annoArrays, 0, newAnnoArrays, 0, annoArrays.length);
                String annnoType = desc.substring(1, desc.length() - 1);
                newAnnoArrays[newAnnoArrays.length - 1] = annnoType.replace('/', '.');
                info.annos = newAnnoArrays;
                return super.visitAnnotation(desc, visible);
            }
        }, 1);
        if (info.superName != null) {
            try (InputStream superStream = this.classLoader.getResourceAsStream(info.superName.replace('.', '/') + ".class");){
                if (superStream != null) {
                    this.loadClassInfo(info.superName, superStream);
                }
            }
        }
        for (String faces : info.interFaces) {
            try (InputStream superStream = this.classLoader.getResourceAsStream(faces.replace('.', '/') + ".class");){
                if (superStream == null) continue;
                this.loadClassInfo(faces, superStream);
            }
        }
        TreeSet<String> castTypeList = new TreeSet<String>();
        String superName = info.superName;
        this.addCastTypeList(info, castTypeList);
        if (superName != null) {
            while (superName != null && this.classInfoMap.containsKey(superName)) {
                ClassMatcher.ClassInfo superInfo = this.classInfoMap.get(superName);
                this.addCastTypeList(superInfo, castTypeList);
                superName = superInfo.superName;
            }
        }
        info.castType = castTypeList.toArray(new String[0]);
        this.classInfoMap.put(info.className, info);
        return info;
    }

    private void addCastTypeList(ClassMatcher.ClassInfo info, Set<String> addTo) {
        if (info == null) {
            return;
        }
        addTo.add(info.className);
        if (info.superName != null) {
            addTo.add(info.superName);
        }
        if (info.interFaces != null) {
            for (String atFaces : info.interFaces) {
                addTo.add(atFaces);
                this.addCastTypeList(this.classInfoMap.get(atFaces), addTo);
            }
        }
    }
}

