/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.Scanner;

public class ExportResourceLoader
extends AbstractResourceLoader {
    private boolean exportAll = false;
    private final Set<String> exportPathSet = new HashSet<String>();
    private final ResourceLoader resourceLoader;

    public ExportResourceLoader(ResourceLoader resourceLoader) {
        this(null, resourceLoader);
    }

    public ExportResourceLoader(ClassLoader parent, ResourceLoader resourceLoader) {
        super(parent);
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        String resource = className.replace(".", "/") + ".class";
        if (this.exist(resource)) {
            return this.resourceLoader.getClass(className);
        }
        throw new ClassNotFoundException(className);
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void addExport(String exportResources) {
        if (exportResources != null && exportResources.length() > 0) {
            if (exportResources.charAt(exportResources.length() - 1) != '/') {
                exportResources = exportResources + '/';
            }
            this.exportPathSet.add(ExportResourceLoader.fmtDirPath(exportResources));
        }
    }

    public Set<String> getExportSet() {
        return this.exportPathSet;
    }

    private static String fmtDirPath(String dirPath) {
        int j;
        int i;
        if (dirPath.startsWith("/")) {
            dirPath = dirPath.substring(1);
        }
        if ((i = dirPath.indexOf("/..")) > 0 && (j = dirPath.lastIndexOf("/", i - 1)) >= 0) {
            dirPath = dirPath.substring(0, j) + dirPath.substring(i + 3);
        }
        if ((j = dirPath.lastIndexOf("/")) > 0) {
            dirPath = dirPath.substring(0, j);
        }
        if (!(dirPath = dirPath.replace("\\", "/")).isEmpty() && dirPath.charAt(0) == '/') {
            dirPath = dirPath.substring(1);
        }
        return dirPath;
    }

    protected boolean testPath(String dirPath) {
        if (this.exportAll) {
            return true;
        }
        if (this.exportPathSet.isEmpty()) {
            return false;
        }
        if (this.exportPathSet.contains(dirPath = ExportResourceLoader.fmtDirPath(dirPath))) {
            return true;
        }
        int index = dirPath.length();
        while ((index = dirPath.lastIndexOf("/", index)) != -1) {
            if (!this.exportPathSet.contains(dirPath = dirPath.substring(0, index))) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        if ((scanPaths = scanPaths.length == 0 ? this.exportPathSet.toArray(new String[0]) : (String[])Arrays.stream(scanPaths).filter(this::testPath).toArray(String[]::new)).length == 0) {
            return Collections.emptyList();
        }
        return this.resourceLoader.scanResources(matchType, matcher, scanner, scanPaths);
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        if ((scanPaths = scanPaths.length == 0 ? this.exportPathSet.toArray(new String[0]) : (String[])Arrays.stream(scanPaths).filter(this::testPath).toArray(String[]::new)).length == 0) {
            return null;
        }
        return this.resourceLoader.scanOneResource(matchType, matcher, scanner, scanPaths);
    }

    @Override
    public URL getResource(String resource) throws IOException {
        if (!this.testPath(resource)) {
            return null;
        }
        return this.resourceLoader.getResource(resource);
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        if (!this.testPath(resource)) {
            return null;
        }
        return this.resourceLoader.getResourceAsStream(resource);
    }

    @Override
    public long getResourceSize(String resource) throws IOException {
        if (!this.testPath(resource)) {
            return -1L;
        }
        return this.resourceLoader.getResourceSize(resource);
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        if (!this.testPath(resource)) {
            return Collections.emptyList();
        }
        return this.resourceLoader.getResources(resource);
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        if (!this.testPath(resource)) {
            return Collections.emptyList();
        }
        return this.resourceLoader.getResourcesAsStream(resource);
    }

    @Override
    public boolean exist(String resource) {
        if (!this.testPath(resource)) {
            return false;
        }
        return this.resourceLoader.exist(resource);
    }
}

