/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.Scanner;
import net.hasor.cobble.loader.providers.ClassLoaderStrategy;
import net.hasor.cobble.loader.providers.MultiResourceLoader;

public class ImportResourceLoader
extends AbstractResourceLoader
implements ClassLoaderStrategy {
    private final Map<String, List<LoaderWrap>> packageLoaders = new ConcurrentHashMap<String, List<LoaderWrap>>();
    private final MultiResourceLoader mergeResourceLoader;
    private final int classLoadMode;

    public ImportResourceLoader(int mode) {
        this(mode, null);
    }

    public ImportResourceLoader(int mode, ClassLoader parent) {
        super(parent);
        this.classLoadMode = mode;
        this.mergeResourceLoader = new MultiResourceLoader(1, parent, new ResourceLoader[0]);
    }

    @Override
    protected ResourceLoader loaderForClassLoader() {
        if (this.classLoadMode == 0) {
            return this;
        }
        return this.mergeResourceLoader;
    }

    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        if (this.classLoadMode == 0) {
            return this.loadClassByIsolation(className);
        }
        return this.loadClassByMerge(className);
    }

    private Class<?> loadClassByMerge(String className) throws ClassNotFoundException {
        String resource = className.replace(".", "/") + ".class";
        if (this.exist(resource)) {
            return this.mergeResourceLoader.getClass(className);
        }
        throw new ClassNotFoundException(className);
    }

    private Class<?> loadClassByIsolation(String className) throws ClassNotFoundException {
        try {
            Class<?> aClass;
            if (this.parentClassLoader != null && (aClass = this.parentClassLoader.loadClass(className)) != null) {
                return aClass;
            }
            throw new ClassNotFoundException(className);
        }
        catch (ClassNotFoundException e) {
            String resource = className.replace(".", "/") + ".class";
            Iterator<LoaderWrap> loaders = this.getLoader(resource);
            while (loaders.hasNext()) {
                ResourceLoader loader = loaders.next().loader;
                if (!loader.exist(resource)) continue;
                return loader.getClass(className);
            }
            throw e;
        }
    }

    public void importResources(ResourceLoader loader) {
        this.importResources(0, "", loader);
    }

    public void importResources(int order, ResourceLoader loader) {
        this.importResources(order, "", loader);
    }

    public void importResources(String importPath, ResourceLoader loader) {
        this.importResources(0, importPath, loader);
    }

    public synchronized void importResources(int order, String importPath, ResourceLoader loader) {
        LoaderWrap wrap;
        List loaders = this.packageLoaders.computeIfAbsent(importPath = ImportResourceLoader.pathOrResource(importPath), s -> new ArrayList());
        if (!loaders.contains(wrap = new LoaderWrap(order, loader))) {
            loaders.add(wrap);
            this.mergeResourceLoader.addLoader(loader);
        }
    }

    private static String pathOrResource(String dirPath) {
        if (!(dirPath = dirPath.replace("\\", "/")).isEmpty() && dirPath.charAt(0) == '/') {
            dirPath = dirPath.substring(1);
        }
        return dirPath;
    }

    public Set<String> getAllPackages() {
        return this.packageLoaders.keySet();
    }

    protected Iterator<LoaderWrap> getAllLoader() {
        return this.packageLoaders.values().stream().flatMap(Collection::stream).iterator();
    }

    private void mergeInto(List<LoaderWrap> form, List<LoaderWrap> into) {
        if (form == null || form.isEmpty()) {
            return;
        }
        for (LoaderWrap wrap : form) {
            if (into.contains(wrap)) continue;
            into.add(wrap);
        }
    }

    protected Iterator<LoaderWrap> getLoader(String resource) {
        String fmtResource = ImportResourceLoader.pathOrResource(resource);
        if (fmtResource.length() == 0) {
            return this.getAllLoader();
        }
        ArrayList<LoaderWrap> loaders = new ArrayList<LoaderWrap>();
        block0: for (String resourceItem : this.packageLoaders.keySet()) {
            if (resourceItem == null || !resource.startsWith(resourceItem)) continue;
            String tmpResourceItem = resourceItem;
            int index = tmpResourceItem.lastIndexOf("/");
            while (true) {
                this.mergeInto(this.packageLoaders.get(tmpResourceItem), loaders);
                index = tmpResourceItem.lastIndexOf("/", index);
                if (index == -1) {
                    this.mergeInto(this.packageLoaders.get(tmpResourceItem), loaders);
                    continue block0;
                }
                tmpResourceItem = tmpResourceItem.substring(0, index);
            }
        }
        this.mergeInto(this.packageLoaders.get(""), loaders);
        Collections.sort(loaders);
        return loaders.iterator();
    }

    public ResourceLoader findLoader(String resource) {
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            LoaderWrap wrap = loaders.next();
            if (!wrap.loader.exist(resource)) continue;
            return wrap.loader;
        }
        return null;
    }

    private <T> Scanner<T> scannerProxy(Scanner<T> scanner) {
        Set<String> allPackages = this.getAllPackages();
        return event -> {
            for (String has : allPackages) {
                if (!event.getName().startsWith(has)) continue;
                return scanner.found(event);
            }
            return null;
        };
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        Iterator<LoaderWrap> loaders = this.getAllLoader();
        Scanner<T> scannerProxy = this.scannerProxy(scanner);
        ArrayList<T> result = new ArrayList<T>();
        while (loaders.hasNext()) {
            LoaderWrap loader = loaders.next();
            List<T> foundResources = loader.loader.scanResources(matchType, matcher, scannerProxy, scanPaths);
            if (foundResources == null) continue;
            result.addAll(foundResources);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        Scanner<T> scannerProxy = this.scannerProxy(scanner);
        Iterator<LoaderWrap> loaders = this.getAllLoader();
        while (loaders.hasNext()) {
            T result = loaders.next().loader.scanOneResource(matchType, matcher, scannerProxy, scanPaths);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public URL getResource(String resource) throws IOException {
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            URL resourceURL = loaders.next().loader.getResource(resource);
            if (resourceURL == null) continue;
            return resourceURL;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            ResourceLoader loader = loaders.next().loader;
            InputStream resourceStream = loader.getResourceAsStream(resource);
            if (resourceStream == null) continue;
            return resourceStream;
        }
        return null;
    }

    @Override
    public long getResourceSize(String resource) throws IOException {
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            ResourceLoader loader = loaders.next().loader;
            InputStream resourceStream = loader.getResourceAsStream(resource);
            Throwable throwable = null;
            try {
                if (resourceStream == null) continue;
                long l = loader.getResourceSize(resource);
                return l;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resourceStream == null) continue;
                if (throwable != null) {
                    try {
                        resourceStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                resourceStream.close();
            }
        }
        return -1L;
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            List<URL> resourceURLs = loaders.next().loader.getResources(resource);
            if (resourceURLs == null || resourceURLs.isEmpty()) continue;
            result.addAll(resourceURLs);
        }
        return result;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            List<InputStream> resourceStreams = loaders.next().loader.getResourcesAsStream(resource);
            if (resourceStreams == null || resourceStreams.isEmpty()) continue;
            result.addAll(resourceStreams);
        }
        return result;
    }

    @Override
    public boolean exist(String resource) {
        Iterator<LoaderWrap> loaders = this.getLoader(resource);
        while (loaders.hasNext()) {
            boolean result = loaders.next().loader.exist(resource);
            if (!result) continue;
            return true;
        }
        return false;
    }

    protected static class LoaderWrap
    implements Comparable<LoaderWrap> {
        int order;
        final ResourceLoader loader;

        public LoaderWrap(int order, ResourceLoader loader) {
            this.order = order;
            this.loader = loader;
        }

        public boolean equals(Object o) {
            return Objects.equals(o, this.loader);
        }

        public int hashCode() {
            return this.loader.hashCode();
        }

        public String toString() {
            return "{order=" + this.order + ", loader=" + this.loader + '}';
        }

        @Override
        public int compareTo(LoaderWrap o) {
            return Integer.compare(this.order, o.order);
        }
    }
}

