/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.function.ESupplier;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ScanEvent;
import net.hasor.cobble.loader.Scanner;
import net.hasor.cobble.loader.jar.JarEntry;
import net.hasor.cobble.loader.jar.JarFile;
import net.hasor.cobble.logging.Logger;

public class JarResourceLoader
extends AbstractResourceLoader {
    private static final Logger logger = Logger.getLogger(JarResourceLoader.class);
    private final JarFile jarFile;
    private final List<JarFile> nestedJarFile;

    public JarResourceLoader(File file) throws IOException {
        this(null, file, Collections.emptyList());
    }

    public JarResourceLoader(ClassLoader parent, File file) throws IOException {
        super(parent);
        this.jarFile = new JarFile(file);
        this.nestedJarFile = new ArrayList<JarFile>();
    }

    public JarResourceLoader(ClassLoader parent, File file, List<String> nestedList) throws IOException {
        super(parent);
        this.jarFile = new JarFile(file);
        this.nestedJarFile = new ArrayList<JarFile>();
        for (String nestedJar : nestedList) {
            JarEntry jarEntry = this.jarFile.getJarEntry(nestedJar);
            if (jarEntry == null) continue;
            this.nestedJarFile.add(this.jarFile.getNestedJarFile((ZipEntry)jarEntry));
        }
    }

    public JarResourceLoader(ClassLoader parent, File file, Predicate<java.util.jar.JarEntry> nestedPredicate) throws IOException {
        super(parent);
        this.jarFile = new JarFile(file);
        this.nestedJarFile = new ArrayList<JarFile>();
        if (nestedPredicate != null) {
            for (java.util.jar.JarEntry jarEntry : this.jarFile) {
                if (jarEntry == null || !nestedPredicate.test(jarEntry)) continue;
                this.nestedJarFile.add(this.jarFile.getNestedJarFile(jarEntry));
            }
        }
    }

    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    public Manifest getManifest(String nestedJarName) throws IOException {
        for (JarFile jarFile : this.nestedJarFile) {
            if (!jarFile.getName().equals(nestedJarName)) continue;
            return jarFile.getManifest();
        }
        return null;
    }

    @Override
    public URL getResource(String resource) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            return new URL(this.jarFile.getUrl(), zipEntry.getName());
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                return new URL(nestedJar.getUrl(), nestedZipEntry.getName());
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            return this.jarFile.getInputStream(zipEntry);
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                return nestedJar.getInputStream(nestedZipEntry);
            }
        }
        return null;
    }

    @Override
    public long getResourceSize(String resource) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            return zipEntry.getSize();
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                return nestedZipEntry.getSize();
            }
        }
        return -1L;
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            result.add(new URL(this.jarFile.getUrl(), zipEntry.getName()));
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                result.add(new URL(nestedJar.getUrl(), nestedJar.getName()));
            }
        }
        return result;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            result.add(this.jarFile.getInputStream(zipEntry));
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                result.add(nestedJar.getInputStream(nestedZipEntry));
            }
        }
        return result;
    }

    @Override
    public boolean exist(String resource) {
        ZipEntry zipEntry = this.jarFile.getEntry(resource);
        if (zipEntry != null) {
            return true;
        }
        if (!this.nestedJarFile.isEmpty()) {
            for (JarFile nestedJar : this.nestedJarFile) {
                ZipEntry nestedZipEntry = nestedJar.getEntry(resource);
                if (nestedZipEntry == null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean testFound(java.util.jar.JarEntry entry, Predicate<java.util.jar.JarEntry>[] testPredicates) {
        if (testPredicates == null || testPredicates.length == 0) {
            return true;
        }
        for (Predicate<java.util.jar.JarEntry> predicate : testPredicates) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private <T> void scanJarFile(List<T> result, JarFile jarFile, Scanner<T> scanner, Predicate<java.util.jar.JarEntry>[] scanPaths, boolean matchOnce) throws IOException {
        Iterator zipEntry = jarFile.stream().iterator();
        while (zipEntry.hasNext()) {
            java.util.jar.JarEntry entry = (java.util.jar.JarEntry)zipEntry.next();
            if (!this.testFound(entry, scanPaths)) continue;
            try {
                URI uri = new URL(jarFile.getUrl(), entry.getName()).toURI();
                ESupplier<InputStream, IOException> inputStream = () -> jarFile.getInputStream(entry);
                T res = scanner.found(new ScanEvent(entry.getName(), entry.getSize(), uri, inputStream));
                if (res != null) {
                    result.add(res);
                }
            }
            catch (URISyntaxException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("scanJarFile :" + e.getMessage(), e);
                }
                logger.debug("scanJarFile :" + e.getMessage());
            }
            if (!matchOnce || result.isEmpty()) continue;
            return;
        }
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        try {
            ArrayList result = new ArrayList();
            Predicate<java.util.jar.JarEntry>[] tests = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
            if (matcher.test(this.jarFile.getUrl().toURI())) {
                this.scanJarFile(result, this.jarFile, scanner, tests, false);
            }
            if (!this.nestedJarFile.isEmpty()) {
                for (JarFile nestedJar : this.nestedJarFile) {
                    if (!matcher.test(nestedJar.getUrl().toURI())) continue;
                    this.scanJarFile(result, nestedJar, scanner, tests, false);
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            logger.error("cannot convert URL to URI jar (" + this.jarFile.getUrl() + ") " + e.getMessage(), e);
            throw ExceptionUtils.toRuntime(e);
        }
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        try {
            ArrayList result = new ArrayList();
            Predicate<java.util.jar.JarEntry>[] tests = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
            if (matcher.test(this.jarFile.getUrl().toURI())) {
                this.scanJarFile(result, this.jarFile, scanner, tests, true);
                if (!result.isEmpty()) {
                    return (T)result.get(0);
                }
            }
            if (!this.nestedJarFile.isEmpty()) {
                for (JarFile nestedJar : this.nestedJarFile) {
                    if (!matcher.test(nestedJar.getUrl().toURI())) continue;
                    this.scanJarFile(result, nestedJar, scanner, tests, true);
                    if (result.isEmpty()) continue;
                    return (T)result.get(0);
                }
            }
            return null;
        }
        catch (URISyntaxException e) {
            logger.error("cannot convert URL to URI jar (" + this.jarFile.getUrl() + ") " + e.getMessage(), e);
            throw ExceptionUtils.toRuntime(e);
        }
    }
}

