/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.Scanner;
import net.hasor.cobble.loader.providers.ClassLoaderStrategy;

public class MultiResourceLoader
extends AbstractResourceLoader
implements ClassLoaderStrategy {
    private final List<ResourceLoader> loaders = new CopyOnWriteArrayList<ResourceLoader>();
    private final int classLoadMode;

    public MultiResourceLoader(int mode, ResourceLoader ... loaders) {
        this(mode, (ClassLoader)null, loaders);
    }

    public MultiResourceLoader(int mode, ClassLoader parent, ResourceLoader ... loaders) {
        super(parent);
        this.classLoadMode = mode;
        if (loaders == null) {
            return;
        }
        for (ResourceLoader loader : loaders) {
            this.addLoader(loader);
        }
    }

    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        if (this.classLoadMode == 0) {
            return this.loadClassByIsolation(className);
        }
        return this.loadClassByMerge(className);
    }

    private Class<?> loadClassByMerge(String className) throws ClassNotFoundException {
        return super.getClass(className);
    }

    private Class<?> loadClassByIsolation(String className) throws ClassNotFoundException {
        String resource = className.replace(".", "/") + ".class";
        ResourceLoader loader = this.findLoader(resource);
        if (loader == null) {
            throw new ClassNotFoundException(className);
        }
        return loader.getClass(className);
    }

    public void addLoader(ResourceLoader loader) {
        if (loader == null) {
            return;
        }
        if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    protected ResourceLoader findLoader(String resource) {
        for (ResourceLoader loads : this.loaders) {
            if (loads == null || !loads.exist(resource)) continue;
            return loads;
        }
        return null;
    }

    @Override
    public URL getResource(String resource) throws IOException {
        ResourceLoader loader = this.findLoader(resource);
        return loader == null ? null : loader.getResource(resource);
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        ResourceLoader loader = this.findLoader(resource);
        return loader == null ? null : loader.getResourceAsStream(resource);
    }

    @Override
    public long getResourceSize(String resource) throws IOException {
        ResourceLoader loader = this.findLoader(resource);
        return loader == null ? -1L : loader.getResourceSize(resource);
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (ResourceLoader loads : this.loaders) {
            List<URL> resources = loads.getResources(resource);
            result.addAll(resources);
        }
        return result;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (ResourceLoader loads : this.loaders) {
            List<InputStream> resources = loads.getResourcesAsStream(resource);
            result.addAll(resources);
        }
        return result;
    }

    @Override
    public boolean exist(String resource) {
        return this.findLoader(resource) != null;
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        for (ResourceLoader loads : this.loaders) {
            List<T> resources = loads.scanResources(matchType, matcher, scanner, scanPaths);
            result.addAll(resources);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        for (ResourceLoader loads : this.loaders) {
            T resources = loads.scanOneResource(matchType, matcher, scanner, scanPaths);
            if (resources == null) continue;
            return resources;
        }
        return null;
    }
}

