/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.SystemUtils;
import net.hasor.cobble.function.ESupplier;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.MatchType;
import net.hasor.cobble.loader.ScanEvent;
import net.hasor.cobble.loader.Scanner;

public class PathResourceLoader
extends AbstractResourceLoader {
    private final List<File> dirPathList = new ArrayList<File>();

    public PathResourceLoader() {
        this(null, null);
    }

    public PathResourceLoader(File dirFile) {
        this(null, dirFile);
    }

    public PathResourceLoader(ClassLoader parent) {
        this(parent, null);
    }

    public PathResourceLoader(ClassLoader parent, File dirFile) {
        super(parent);
        if (dirFile != null) {
            this.addPath(dirFile);
        }
    }

    public void addPath(File dirFile) {
        if (dirFile.exists() && dirFile.isDirectory()) {
            this.dirPathList.add(dirFile);
        }
    }

    private List<File> formatResourcePath(String resource) {
        return this.dirPathList.stream().filter(File::exists).map(file -> new File((File)file, resource)).collect(Collectors.toList());
    }

    @Override
    public URL getResource(String resource) throws IOException {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return file.toURI().toURL();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return null;
    }

    @Override
    public long getResourceSize(String resource) {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return file.length();
        }
        return -1L;
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            result.add(file.toURI().toURL());
        }
        return result;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            result.add(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        return result;
    }

    @Override
    public boolean exist(String resource) {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return true;
        }
        return false;
    }

    protected boolean testFound(String entry, Predicate<String>[] testPredicates) {
        if (testPredicates == null || testPredicates.length == 0) {
            return true;
        }
        for (Predicate<String> predicate : testPredicates) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private <T> void scanDirFile(File baseDir, List<T> result, File scanDir, Scanner<T> scanner, Predicate<String>[] scanPaths, boolean matchOnce) throws IOException {
        File[] listFiles = scanDir.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File fileItem : listFiles) {
            if (matchOnce && !result.isEmpty()) {
                return;
            }
            if (fileItem.isHidden() || !fileItem.exists()) continue;
            String resourceName = fileItem.getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1);
            if (SystemUtils.isWindows()) {
                resourceName = StringUtils.replace(resourceName, File.separator, "/");
            }
            if (!this.testFound(resourceName, scanPaths)) continue;
            if (fileItem.isDirectory()) {
                this.scanDirFile(baseDir, result, fileItem, scanner, scanPaths, matchOnce);
                continue;
            }
            ESupplier<InputStream, IOException> inputStream = () -> {
                if (fileItem.canRead()) {
                    return Files.newInputStream(fileItem.toPath(), new OpenOption[0]);
                }
                throw new IOException("file cannot be read :" + fileItem);
            };
            T res = scanner.found(new ScanEvent(resourceName, fileItem.length(), fileItem.toURI(), inputStream));
            if (res == null) continue;
            result.add(res);
        }
    }

    @Override
    public <T> List<T> scanResources(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<String>[] tests = this.buildPredicate(matchType, scanPaths, s -> s);
        for (File baseDir : this.dirPathList) {
            if (!baseDir.exists() || !matcher.test(baseDir.toURI())) continue;
            this.scanDirFile(baseDir, result, baseDir, scanner, tests, false);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(MatchType matchType, Predicate<URI> matcher, Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<String>[] tests = this.buildPredicate(matchType, scanPaths, s -> s);
        for (File baseDir : this.dirPathList) {
            if (baseDir.exists() && matcher.test(baseDir.toURI())) {
                this.scanDirFile(baseDir, result, baseDir, scanner, tests, true);
            }
            if (result.isEmpty()) continue;
            return (T)result.get(0);
        }
        return null;
    }
}

