/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.cobble.setting.AbstractSettings;
import net.hasor.cobble.setting.SettingNode;
import net.hasor.cobble.setting.Settings;
import net.hasor.cobble.setting.data.TreeNode;
import net.hasor.cobble.text.token.GenericTokenParser;

public class BasicSettings
extends AbstractSettings
implements Settings {
    protected static Logger logger = LoggerFactory.getLogger(BasicSettings.class);
    private final Map<String, TreeNode> dataMap = new ConcurrentHashMap<String, TreeNode>();
    private final Map<String, String> envMap = new ConcurrentHashMap<String, String>();

    protected Map<String, TreeNode> allSettingValue() {
        return this.dataMap;
    }

    @Override
    protected Map<String, String> envMap() {
        return this.envMap;
    }

    protected void cleanData() {
        this.envMap().clear();
        this.allSettingValue().clear();
    }

    protected void loadEnvironment() throws IOException {
        Properties prop = System.getProperties();
        for (Object propKey : prop.keySet()) {
            String k = propKey.toString();
            Object v = prop.get(propKey);
            if (v == null) continue;
            this.envMap().put(k.toUpperCase(), v.toString());
        }
        Map<String, String> envMap = System.getenv();
        for (String key : envMap.keySet()) {
            this.envMap().put(key.toUpperCase(), envMap.get(key));
        }
    }

    protected void loadSettings() throws IOException {
    }

    protected void updateSettings() {
        Collection<TreeNode> valueSet = this.allSettingValue().values();
        for (TreeNode sv : valueSet) {
            sv.update((dataNode, context) -> {
                String[] values = dataNode.getValues();
                for (int index = 0; index < values.length; ++index) {
                    String oldVar = values[index];
                    String newVal = this.evalSetting(oldVar);
                    if (StringUtils.equals(oldVar, newVal)) continue;
                    dataNode.replace(index, newVal);
                }
            }, this);
        }
    }

    @Override
    public void refresh() throws IOException {
        this.loadEnvironment();
        this.updateSettings();
    }

    @Override
    public String evalSetting(String evalString) {
        if (StringUtils.isBlank(evalString)) {
            return "";
        }
        String newEvalString = new GenericTokenParser(new String[]{"${"}, "}", (hasFound, openToken, closeToken, content) -> {
            String envKey;
            String var;
            String varKey = content;
            String varDefault = "";
            int defaultIndexOf = content.indexOf(":");
            if (defaultIndexOf != -1) {
                varDefault = content.substring(defaultIndexOf + 1);
                varKey = content.substring(0, defaultIndexOf);
            }
            if (StringUtils.isBlank(var = this.evalEnv(envKey = "%" + varKey.toUpperCase() + "%")) && StringUtils.isNotBlank(varDefault)) {
                var = varDefault;
            }
            if (envKey.equalsIgnoreCase(var)) {
                return envKey;
            }
            return var;
        }).parse(evalString);
        if (!evalString.equalsIgnoreCase(newEvalString)) {
            logger.debug("replace settingValue '" + evalString + "' to '" + newEvalString + "'.");
        }
        return newEvalString;
    }

    private String evalEnv(String evalString) {
        if (StringUtils.isBlank(evalString)) {
            return "";
        }
        Pattern keyPattern = Pattern.compile("(?:%([\\w\\._-]+)%){1,1}");
        Matcher keyM = keyPattern.matcher(evalString);
        HashMap<String, String> data = new HashMap<String, String>();
        Map<String, String> envMap = this.envMap();
        while (keyM.find()) {
            String varKeyOri = keyM.group(1);
            String keyName = "%" + varKeyOri + "%";
            String var = envMap.get(varKeyOri.toUpperCase());
            if (var == null) {
                data.put(keyName, "");
                continue;
            }
            data.put(keyName, this.evalEnv(var));
        }
        String newEvalString = evalString;
        for (String key : data.keySet()) {
            newEvalString = newEvalString.replace(key, (CharSequence)data.get(key));
        }
        logger.debug("evalString '" + evalString + "' eval to '" + newEvalString + "'.");
        return newEvalString;
    }

    @Override
    public String[] getSettingArray() {
        Set<String> nsSet = this.allSettingValue().keySet();
        return nsSet.toArray(new String[0]);
    }

    protected boolean isNsView() {
        return false;
    }

    @Override
    public final BasicSettings getSettings(final String namespace) {
        final Map<String, TreeNode> localData = Collections.unmodifiableMap(new HashMap<String, TreeNode>(){
            {
                this.put(namespace, BasicSettings.this.allSettingValue().get(namespace));
            }
        });
        return new BasicSettings(){

            @Override
            public Map<String, TreeNode> allSettingValue() {
                return localData;
            }

            @Override
            protected boolean isNsView() {
                return true;
            }
        };
    }

    @Override
    public void removeSetting(String key) {
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("namespace or key is blank.");
        }
        String lowerCaseKey = key.trim();
        for (TreeNode treeNode : this.allSettingValue().values()) {
            treeNode.findClear(lowerCaseKey);
        }
    }

    @Override
    public void removeSetting(String key, String namespace) {
        if (StringUtils.isBlank(namespace) || StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("namespace or key is blank.");
        }
        TreeNode treeNode = this.allSettingValue().get(namespace);
        if (treeNode != null) {
            treeNode.findClear(key.trim());
        }
    }

    @Override
    public void setSetting(String key, Object value, String namespace) {
        if (StringUtils.isBlank(namespace) || StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("namespace or key is blank.");
        }
        Map<String, TreeNode> treeNodeMap = this.allSettingValue();
        TreeNode dataNode = treeNodeMap.get(namespace);
        if (dataNode == null) {
            if (this.isNsView()) {
                throw new IllegalStateException("namespace view mode, cannot be added new namespace.");
            }
            dataNode = new TreeNode("", namespace);
            treeNodeMap.put(namespace, dataNode);
        }
        if (value instanceof SettingNode) {
            SettingNode node = (SettingNode)value;
            dataNode.setNode(key.trim(), node);
        } else {
            String valueStr = value == null ? null : value.toString();
            dataNode.setValue(key.trim(), valueStr);
        }
    }

    @Override
    public void addSetting(String key, Object value, String namespace) {
        Map<String, TreeNode> treeNodeMap;
        TreeNode dataNode;
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("key is blank.");
        }
        if (StringUtils.isBlank(namespace)) {
            namespace = "https://www.hasor.net/sechma/main";
        }
        if ((dataNode = (treeNodeMap = this.allSettingValue()).get(namespace)) == null) {
            if (this.isNsView()) {
                throw new IllegalStateException("namespace view mode, cannot be added new namespace.");
            }
            dataNode = new TreeNode("", namespace);
            treeNodeMap.put(namespace, dataNode);
        }
        if (value instanceof SettingNode) {
            SettingNode node = (SettingNode)value;
            dataNode.addNode(key.trim(), node);
        } else {
            String valueStr = value == null ? null : value.toString();
            dataNode.addValue(key.trim(), valueStr);
        }
    }

    protected SettingNode[] findSettingValue(String name) {
        if (StringUtils.isBlank(name)) {
            return new SettingNode[0];
        }
        ArrayList dataNodeList = new ArrayList();
        String lowerCase = name.trim();
        for (TreeNode dataNode : this.allSettingValue().values()) {
            List<SettingNode> treeNodeList = dataNode.findNodes(lowerCase);
            if (treeNodeList == null) continue;
            treeNodeList.forEach(settingNode -> {
                if (!settingNode.isEmpty()) {
                    dataNodeList.add(settingNode);
                }
            });
        }
        if (dataNodeList.isEmpty()) {
            return new SettingNode[0];
        }
        dataNodeList.sort((o1, o2) -> {
            int o1Index = "https://www.hasor.net/sechma/main".equalsIgnoreCase(o1.getSpace()) ? 0 : -1;
            int o2Index = "https://www.hasor.net/sechma/main".equalsIgnoreCase(o2.getSpace()) ? 0 : -1;
            return Integer.compare(o1Index, o2Index);
        });
        return dataNodeList.toArray(new SettingNode[0]);
    }

    protected <T> T convertTo(Object oriObject, Class<T> toType, T defaultValue) {
        if (oriObject == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return (T)BeanUtils.getDefaultValue(toType);
        }
        if (toType.isInstance(oriObject)) {
            return (T)oriObject;
        }
        return (T)ConverterUtils.convert(toType, oriObject);
    }

    @Override
    public final <T> T getToType(String name, Class<T> toType, T defaultValue) {
        SettingNode[] settingVar = this.findSettingValue(name);
        if (settingVar == null || settingVar.length == 0) {
            return defaultValue;
        }
        if (settingVar.length == 0) {
            return null;
        }
        if (SettingNode.class == toType || TreeNode.class == toType) {
            return (T)settingVar[settingVar.length - 1];
        }
        return this.convertTo(settingVar[settingVar.length - 1].getValue(), toType, defaultValue);
    }

    @Override
    public <T> T[] getToTypeArray(String name, Class<T> toType, T defaultValue) {
        SettingNode[] varArrays = this.findSettingValue(name);
        if (varArrays == null) {
            return (Object[])Array.newInstance(toType, 0);
        }
        if (SettingNode.class == toType || TreeNode.class == toType) {
            return varArrays;
        }
        ArrayList<T> targetObjects = new ArrayList<T>();
        for (SettingNode var : varArrays) {
            for (String item : var.getValues()) {
                T finalItem = this.convertTo(item, toType, defaultValue);
                targetObjects.add(finalItem);
            }
        }
        return targetObjects.toArray((Object[])Array.newInstance(toType, targetObjects.size()));
    }
}

