/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.setting.provider.yaml;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.cobble.setting.Settings;
import net.hasor.cobble.setting.data.TreeNode;
import net.hasor.cobble.setting.provider.SettingsReader;
import net.hasor.cobble.setting.provider.yaml.lib.Yaml;

public class YamlSettingsReader
implements SettingsReader {
    @Override
    public void readSetting(Reader reader, Settings readTo) throws IOException {
        Object yamlConfig = new Yaml().load(reader);
        this.loadYaml(readTo, yamlConfig);
    }

    protected void loadYaml(Settings readTo, Object yamlConfig) throws IOException {
        if (!(yamlConfig instanceof Map)) {
            throw new IOException("The first level of YAML must be Map.");
        }
        String namespace = "https://www.hasor.net/sechma/main";
        TreeNode parentNode = new TreeNode("", namespace);
        TreeNode loadMap = this.loadMap((Map)yamlConfig);
        YamlSettingsReader.copyTreeNode(loadMap, parentNode);
        for (TreeNode node : parentNode.getSubNodes()) {
            readTo.addSetting(node.getName(), node, namespace);
        }
    }

    protected List<TreeNode> loadList(List<Object> yamlConfig) {
        return yamlConfig.stream().map(yamlValue -> {
            TreeNode treeNode = new TreeNode("");
            if (yamlValue instanceof List) {
                throw new UnsupportedOperationException("Unsupported array/array struct.");
            }
            if (yamlValue instanceof Map) {
                TreeNode loadMap = this.loadMap((Map)yamlValue);
                YamlSettingsReader.copyTreeNode(loadMap, treeNode);
            } else if (yamlValue != null) {
                treeNode.addValue(String.valueOf(yamlValue));
            }
            return treeNode;
        }).collect(Collectors.toList());
    }

    protected TreeNode loadMap(Map<String, Object> yamlConfig) {
        TreeNode mapNode = new TreeNode("");
        yamlConfig.forEach((key, value) -> {
            if (value instanceof List) {
                List<TreeNode> treeNodes = this.loadList((List)value);
                for (TreeNode node : treeNodes) {
                    TreeNode newLast = mapNode.newLast((String)key);
                    YamlSettingsReader.copyTreeNode(node, newLast);
                }
            } else if (value instanceof Map) {
                TreeNode loadMap = this.loadMap((Map)value);
                mapNode.addNode((String)key, loadMap);
            } else if (value != null) {
                mapNode.addValue((String)key, String.valueOf(value));
            }
        });
        return mapNode;
    }

    private static void copyTreeNode(TreeNode form, TreeNode to) {
        for (String subValue : form.getValues()) {
            to.addValue(subValue);
        }
        for (TreeNode subItem : form.getSubNodes()) {
            to.addSubNode(subItem);
        }
    }
}

