/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.dynamic;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.ArrayDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.BindDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.ChooseDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.ForeachDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.IfDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.IncludeDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.SelectKeyDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.SetDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.TrimDynamicSql;
import net.hasor.dbvisitor.dal.dynamic.nodes.WhereDynamicSql;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DynamicParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public DynamicSql parseDynamicSql(String sqlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(sqlString)));
        Element root = document.getDocumentElement();
        return this.parseDynamicSql(root);
    }

    public DynamicSql parseDynamicSql(Node configNode) {
        ArrayDynamicSql arraySqlNode = new ArrayDynamicSql();
        this.parseNodeList(arraySqlNode, configNode.getChildNodes());
        return arraySqlNode;
    }

    protected String getNodeAttributeValue(Node node, String attributeKey) {
        Node item = node.getAttributes().getNamedItem(attributeKey);
        return item != null ? item.getNodeValue() : null;
    }

    protected void parseNodeList(ArrayDynamicSql parentSqlNode, NodeList nodeList) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                this.parseTextSqlNode(parentSqlNode, node);
                continue;
            }
            if (node.getNodeType() == 1) {
                String nodeName = node.getNodeName();
                if ("foreach".equalsIgnoreCase(nodeName)) {
                    this.parseForeachSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("if".equalsIgnoreCase(nodeName)) {
                    this.parseIfSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("trim".equalsIgnoreCase(nodeName)) {
                    this.parseTrimSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("where".equalsIgnoreCase(nodeName)) {
                    this.parseWhereSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("set".equalsIgnoreCase(nodeName)) {
                    this.parseSetSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("bind".equalsIgnoreCase(nodeName)) {
                    this.parseBindSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("choose".equalsIgnoreCase(nodeName)) {
                    this.parseChooseSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("when".equalsIgnoreCase(nodeName)) {
                    this.parseWhenSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("otherwise".equalsIgnoreCase(nodeName)) {
                    this.parseOtherwiseSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("include".equalsIgnoreCase(nodeName)) {
                    this.parseIncludeSqlNode(parentSqlNode, node);
                    continue;
                }
                if ("selectKey".equalsIgnoreCase(nodeName)) {
                    this.parseSelectKeySqlNode(parentSqlNode, node);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported tags :" + nodeName);
            }
            if (node.getNodeType() != 4) continue;
            this.parseTextSqlNode(parentSqlNode, node);
        }
    }

    protected void parseTextSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        parentSqlNode.appendText(curXmlNode.getNodeValue());
    }

    protected void parseForeachSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String collection = this.getNodeAttributeValue(curXmlNode, "collection");
        String item = this.getNodeAttributeValue(curXmlNode, "item");
        String open = this.getNodeAttributeValue(curXmlNode, "open");
        String close = this.getNodeAttributeValue(curXmlNode, "close");
        String separator = this.getNodeAttributeValue(curXmlNode, "separator");
        ForeachDynamicSql parent = new ForeachDynamicSql(collection, item, open, close, separator);
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseIfSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String test = this.getNodeAttributeValue(curXmlNode, "test");
        IfDynamicSql parent = new IfDynamicSql(test);
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseTrimSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String prefix = this.getNodeAttributeValue(curXmlNode, "prefix");
        String prefixOverrides = this.getNodeAttributeValue(curXmlNode, "prefixOverrides");
        String suffix = this.getNodeAttributeValue(curXmlNode, "suffix");
        String suffixOverrides = this.getNodeAttributeValue(curXmlNode, "suffixOverrides");
        TrimDynamicSql parent = new TrimDynamicSql(prefix, suffix, prefixOverrides, suffixOverrides);
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseWhereSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        WhereDynamicSql parent = new WhereDynamicSql();
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseSetSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        SetDynamicSql parent = new SetDynamicSql();
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseBindSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String name = this.getNodeAttributeValue(curXmlNode, "name");
        String value = this.getNodeAttributeValue(curXmlNode, "value");
        parentSqlNode.addChildNode(new BindDynamicSql(name, value));
    }

    protected void parseChooseSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        ChooseDynamicSql parent = new ChooseDynamicSql();
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseWhenSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        if (!(parentSqlNode instanceof ChooseDynamicSql)) {
            throw new UnsupportedOperationException("the tag `<when>` parent tag must be `<choose>`");
        }
        String test = this.getNodeAttributeValue(curXmlNode, "test");
        ChooseDynamicSql chooseSqlNode = (ChooseDynamicSql)parentSqlNode;
        ArrayDynamicSql parent = new ArrayDynamicSql();
        chooseSqlNode.addWhen(test, parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseOtherwiseSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        if (!(parentSqlNode instanceof ChooseDynamicSql)) {
            throw new UnsupportedOperationException("the tag `<otherwise>` parent tag must be `<choose>`");
        }
        ChooseDynamicSql chooseSqlNode = (ChooseDynamicSql)parentSqlNode;
        ArrayDynamicSql parent = new ArrayDynamicSql();
        chooseSqlNode.setDefaultNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }

    protected void parseIncludeSqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String refId = this.getNodeAttributeValue(curXmlNode, "refid");
        parentSqlNode.addChildNode(new IncludeDynamicSql(refId));
    }

    private void parseSelectKeySqlNode(ArrayDynamicSql parentSqlNode, Node curXmlNode) {
        String statementType = this.getNodeAttributeValue(curXmlNode, "statementType");
        String timeout = this.getNodeAttributeValue(curXmlNode, "timeout");
        String resultMap = this.getNodeAttributeValue(curXmlNode, "resultMap");
        String resultType = this.getNodeAttributeValue(curXmlNode, "resultType");
        String fetchSize = this.getNodeAttributeValue(curXmlNode, "fetchSize");
        String resultSetType = this.getNodeAttributeValue(curXmlNode, "resultSetType");
        String keyProperty = this.getNodeAttributeValue(curXmlNode, "keyProperty");
        String keyColumn = this.getNodeAttributeValue(curXmlNode, "keyColumn");
        String order = this.getNodeAttributeValue(curXmlNode, "order");
        String handler = this.getNodeAttributeValue(curXmlNode, "handler");
        int timeoutNum = StringUtils.isBlank((String)timeout) ? -1 : Math.max(-1, Integer.parseInt(timeout));
        int fetchSizeNum = StringUtils.isBlank((String)fetchSize) ? 256 : Integer.parseInt(fetchSize);
        SelectKeyDynamicSql parent = new SelectKeyDynamicSql(statementType, timeoutNum, resultMap, resultType, fetchSizeNum, resultSetType, keyProperty, keyColumn, order, handler);
        parentSqlNode.addChildNode(parent);
        this.parseNodeList(parent, curXmlNode.getChildNodes());
    }
}

