/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.dynamic.nodes;

import java.sql.SQLException;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.dynamic.segment.SqlSegmentParser;
import net.hasor.dbvisitor.dialect.SqlBuilder;

public class TextDynamicSql
implements DynamicSql {
    private final StringBuilder textBuilder = new StringBuilder();
    private DynamicSql dynamicSql;

    public TextDynamicSql(String text) {
        this.appendText(StringUtils.isBlank((String)text) ? "" : text);
    }

    public void appendText(String text) {
        if (StringUtils.isNotBlank((String)text)) {
            this.textBuilder.append(text);
        }
        this.dynamicSql = this.parserQuery(this.textBuilder.toString());
    }

    @Override
    public boolean isHavePlaceholder() {
        return this.dynamicSql.isHavePlaceholder();
    }

    @Override
    public void buildQuery(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder) throws SQLException {
        this.dynamicSql.buildQuery(data, context, sqlBuilder);
    }

    protected DynamicSql parserQuery(String fragmentString) {
        return SqlSegmentParser.analysisSQL(fragmentString);
    }
}

