/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.dynamic.tokens;

import java.util.HashMap;
import java.util.Map;
import net.hasor.dbvisitor.dal.dynamic.tokens.TokenHandler;

public class GenericTokenParser {
    private final String[] openToken;
    private final String closeToken;
    private final TokenHandler handler;

    public GenericTokenParser(String[] openToken, String closeToken, TokenHandler handler) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.handler = handler;
    }

    private CurrentOpenToken findOpenToken(String text, int offset) {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
        for (String token : this.openToken) {
            statusMap.put(token, text.indexOf(token, offset));
        }
        Map.Entry entry = statusMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).filter(ent -> (Integer)ent.getValue() > -1).findFirst().orElse(null);
        CurrentOpenToken info = new CurrentOpenToken();
        info.openToken = this.openToken[0];
        info.start = -1;
        if (entry == null) {
            return info;
        }
        info.openToken = (String)entry.getKey();
        info.start = (Integer)entry.getValue();
        return info;
    }

    public String parse(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        CurrentOpenToken token = this.findOpenToken(text, 0);
        if (token.start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (token.start > -1) {
            if (token.start > 0 && src[token.start - 1] == '\\') {
                builder.append(src, offset, token.start - offset - 1).append(token.openToken);
                offset = token.start + token.openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, token.start - offset);
                offset = token.start + token.openToken.length();
                int end = text.indexOf(this.closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(this.closeToken);
                        offset = end + this.closeToken.length();
                        end = text.indexOf(this.closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    break;
                }
                if (end == -1) {
                    builder.append(src, token.start, src.length - token.start);
                    offset = src.length;
                } else {
                    builder.append(this.handler.handleToken(builder, token.openToken, expression.toString()));
                    offset = end + this.closeToken.length();
                }
            }
            token = this.findOpenToken(text, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    private static class CurrentOpenToken {
        public String openToken = null;
        public int start = -1;

        private CurrentOpenToken() {
        }
    }
}

