/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.execute.AbstractStatementExecute;
import net.hasor.dbvisitor.dal.execute.CallableStatementExecute;
import net.hasor.dbvisitor.dal.execute.PreparedStatementExecute;
import net.hasor.dbvisitor.dal.execute.SelectKeyExecute;
import net.hasor.dbvisitor.dal.execute.SelectKeyHandler;
import net.hasor.dbvisitor.dal.execute.SelectKeyHandlerFactory;
import net.hasor.dbvisitor.dal.execute.StatementExecute;
import net.hasor.dbvisitor.dal.repository.StatementType;
import net.hasor.dbvisitor.dal.repository.config.DmlSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.SelectKeySqlConfig;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.page.Page;

public class ExecuteProxy {
    private final DmlSqlConfig dynamicSql;
    private final AbstractStatementExecute<?> execute;
    private SelectKeyExecute selectKeyExecute;

    public ExecuteProxy(String dynamicId, DynamicContext context) {
        DynamicSql sqlConfig = context.findDynamic(dynamicId);
        if (sqlConfig == null) {
            throw new NullPointerException("dynamic '" + dynamicId + "' is not found.");
        }
        if (!(sqlConfig instanceof DmlSqlConfig)) {
            throw new ClassCastException("dynamic '" + dynamicId + "' is not DmlSqlConfig");
        }
        this.dynamicSql = (DmlSqlConfig)context.findDynamic(dynamicId);
        this.execute = this.buildExecute(this.dynamicSql.getStatementType(), context);
        SelectKeySqlConfig selectKey = ((DmlSqlConfig)sqlConfig).getSelectKey();
        if (selectKey != null) {
            AbstractStatementExecute<?> selectKeyExecute = this.buildExecute(selectKey.getStatementType(), context);
            SelectKeyHandler selectKeyHandler = null;
            if (StringUtils.isBlank((String)selectKey.getHandler())) {
                selectKeyHandler = new SelectKeySequenceHolder(selectKey, selectKeyExecute);
            } else {
                try {
                    Class<?> aClass = context.getClassLoader().loadClass(selectKey.getHandler());
                    SelectKeyHandlerFactory holderFactory = (SelectKeyHandlerFactory)aClass.newInstance();
                    selectKeyHandler = holderFactory.createHandler(selectKey, selectKeyExecute);
                    if (selectKeyHandler == null) {
                        throw new NullPointerException("createSelectKeyHolder result is null.");
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntime((Throwable)e);
                }
            }
            this.selectKeyExecute = new SelectKeyExecute(selectKey, selectKeyHandler);
        }
    }

    private AbstractStatementExecute<?> buildExecute(StatementType statementType, DynamicContext context) {
        switch (statementType) {
            case Statement: {
                return new StatementExecute(context);
            }
            case Prepared: {
                return new PreparedStatementExecute(context);
            }
            case Callable: {
                return new CallableStatementExecute(context);
            }
        }
        throw new UnsupportedOperationException("statementType '" + statementType.getTypeName() + "' Unsupported.");
    }

    public Object execute(Connection conn, Map<String, Object> data, Page page, boolean pageResult, PageSqlDialect dialect) throws SQLException {
        if (this.selectKeyExecute != null) {
            this.selectKeyExecute.processBefore(conn, data);
        }
        Object result = this.execute.execute(conn, this.dynamicSql, data, page, pageResult, dialect);
        if (this.selectKeyExecute != null) {
            this.selectKeyExecute.processAfter(conn, data);
        }
        return result;
    }

    private static class SelectKeySequenceHolder
    implements SelectKeyHandler {
        private final SelectKeySqlConfig keySqlConfig;
        private final AbstractStatementExecute<?> selectKeyExecute;

        public SelectKeySequenceHolder(SelectKeySqlConfig keySqlConfig, AbstractStatementExecute<?> selectKeyExecute) {
            this.keySqlConfig = keySqlConfig;
            this.selectKeyExecute = selectKeyExecute;
        }

        @Override
        public Object processSelectKey(Connection conn, Map<String, Object> parameter, boolean onBefore) throws SQLException {
            String keyColumn = this.keySqlConfig.getKeyColumn();
            Object resultValue = null;
            resultValue = StringUtils.isBlank((String)keyColumn) ? this.selectKeyExecute.execute(conn, this.keySqlConfig, parameter, null, false, null) : this.selectKeyExecute.execute(conn, this.keySqlConfig, parameter, null, false, null, true);
            if (resultValue instanceof List) {
                resultValue = ((List)resultValue).get(0);
            }
            return resultValue;
        }
    }
}

