/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.repository.config;

import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.repository.MultipleResultsType;
import net.hasor.dbvisitor.dal.repository.QueryType;
import net.hasor.dbvisitor.dal.repository.ResultSetType;
import net.hasor.dbvisitor.dal.repository.config.DmlSqlConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QuerySqlConfig
extends DmlSqlConfig {
    private String resultMap;
    private String resultType;
    private int fetchSize;
    private ResultSetType resultSetType;
    private MultipleResultsType multipleResultType;

    public QuerySqlConfig(DynamicSql target) {
        super(target);
    }

    public QuerySqlConfig(DynamicSql target, Node operationNode) {
        super(target, operationNode);
        NamedNodeMap nodeAttributes = operationNode.getAttributes();
        Node resultMapNode = nodeAttributes.getNamedItem("resultMap");
        Node resultTypeNode = nodeAttributes.getNamedItem("resultType");
        Node fetchSizeNode = nodeAttributes.getNamedItem("fetchSize");
        Node resultSetTypeNode = nodeAttributes.getNamedItem("resultSetType");
        Node multipleResultNode = nodeAttributes.getNamedItem("multipleResult");
        String resultMap = resultMapNode != null ? resultMapNode.getNodeValue() : null;
        String resultType = resultTypeNode != null ? resultTypeNode.getNodeValue() : null;
        String fetchSize = fetchSizeNode != null ? fetchSizeNode.getNodeValue() : null;
        String resultSetType = resultSetTypeNode != null ? resultSetTypeNode.getNodeValue() : null;
        String multipleResult = multipleResultNode != null ? multipleResultNode.getNodeValue() : null;
        this.resultMap = resultMap;
        this.resultType = resultType;
        this.fetchSize = StringUtils.isBlank((String)fetchSize) ? 256 : Integer.parseInt(fetchSize);
        this.resultSetType = ResultSetType.valueOfCode(resultSetType, ResultSetType.DEFAULT);
        this.multipleResultType = MultipleResultsType.valueOfCode(multipleResult, this.defaultMultipleResultsType());
    }

    protected MultipleResultsType defaultMultipleResultsType() {
        return MultipleResultsType.LAST;
    }

    @Override
    public QueryType getDynamicType() {
        return QueryType.Query;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(String resultMap) {
        this.resultMap = resultMap;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
    }

    public MultipleResultsType getMultipleResultType() {
        return this.multipleResultType;
    }

    public void setMultipleResultType(MultipleResultsType multipleResultType) {
        this.multipleResultType = multipleResultType;
    }
}

