/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.repository.parser;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.dbvisitor.dal.dynamic.DynamicParser;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.repository.Delete;
import net.hasor.dbvisitor.dal.repository.Insert;
import net.hasor.dbvisitor.dal.repository.Query;
import net.hasor.dbvisitor.dal.repository.QueryType;
import net.hasor.dbvisitor.dal.repository.Update;
import net.hasor.dbvisitor.dal.repository.parser.DynamicResolve;
import net.hasor.dbvisitor.dal.repository.parser.XmlDynamicResolve;
import org.xml.sax.SAXException;

public class ClassDynamicResolve
extends DynamicParser
implements DynamicResolve<Method> {
    private static final Logger logger = Logger.getLogger(ClassDynamicResolve.class);
    private final XmlDynamicResolve xmlDynamicResolve = new XmlDynamicResolve();

    public static boolean matchType(Class<?> dalType) {
        Method[] dalTypeMethods;
        if (!dalType.isInterface()) {
            return false;
        }
        for (Method method : dalTypeMethods = dalType.getMethods()) {
            if (!ClassDynamicResolve.matchMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchMethod(Method dalMethod) {
        if (dalMethod.getDeclaringClass() == Object.class) {
            return false;
        }
        for (Annotation anno : dalMethod.getAnnotations()) {
            if (!ClassDynamicResolve.matchAnnotation(anno)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAnnotation(Annotation annotation) {
        return annotation instanceof Insert || annotation instanceof Delete || annotation instanceof Update || annotation instanceof Query;
    }

    protected DynamicSql createDynamicSql(Annotation annotation, Class<?> resultType, String parameterType) throws ParserConfigurationException, IOException, SAXException {
        String dynamicSqlBody = "";
        QueryType queryType = null;
        HashMap<String, String> dynamicSqlAttribute = new HashMap<String, String>();
        dynamicSqlAttribute.put("parameterType", parameterType);
        boolean isXml = false;
        if (annotation instanceof Insert) {
            queryType = QueryType.Insert;
            dynamicSqlBody = ((Insert)annotation).value();
            dynamicSqlAttribute.put("statementType", ((Insert)annotation).statementType().getTypeName());
            dynamicSqlAttribute.put("timeout", String.valueOf(((Insert)annotation).timeout()));
            dynamicSqlAttribute.put("useGeneratedKeys", String.valueOf(((Insert)annotation).useGeneratedKeys()));
            dynamicSqlAttribute.put("keyProperty", ((Insert)annotation).keyProperty());
            if (((Insert)annotation).parameterType() != Object.class) {
                dynamicSqlAttribute.put("parameterType", ((Insert)annotation).parameterType().getName());
            }
            isXml = ((Insert)annotation).xml();
        } else if (annotation instanceof Delete) {
            queryType = QueryType.Delete;
            dynamicSqlBody = ((Delete)annotation).value();
            dynamicSqlAttribute.put("statementType", ((Delete)annotation).statementType().getTypeName());
            dynamicSqlAttribute.put("timeout", String.valueOf(((Delete)annotation).timeout()));
            isXml = ((Delete)annotation).xml();
        } else if (annotation instanceof Update) {
            queryType = QueryType.Update;
            dynamicSqlBody = ((Update)annotation).value();
            dynamicSqlAttribute.put("statementType", ((Update)annotation).statementType().getTypeName());
            dynamicSqlAttribute.put("timeout", String.valueOf(((Update)annotation).timeout()));
            isXml = ((Update)annotation).xml();
        } else if (annotation instanceof Query) {
            queryType = QueryType.Query;
            dynamicSqlBody = ((Query)annotation).value();
            dynamicSqlAttribute.put("statementType", ((Query)annotation).statementType().getTypeName());
            dynamicSqlAttribute.put("timeout", String.valueOf(((Query)annotation).timeout()));
            dynamicSqlAttribute.put("fetchSize", String.valueOf(((Query)annotation).fetchSize()));
            dynamicSqlAttribute.put("resultSetType", ((Query)annotation).resultSetType().getTypeName());
            dynamicSqlAttribute.put("multipleResult", ((Query)annotation).multipleResult().getTypeName());
            dynamicSqlAttribute.put("resultMap", ((Query)annotation).resultMap());
            if (((Query)annotation).resultType() != Object.class) {
                dynamicSqlAttribute.put("resultType", ((Query)annotation).resultType().getName());
            }
            isXml = ((Query)annotation).xml();
        } else {
            return null;
        }
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<" + queryType.getXmlTag());
        dynamicSqlAttribute.forEach((key, value) -> {
            String xmlValue = StringUtils.isNotBlank((String)value) ? value.replace("\"", "&quot;") : "";
            xmlBuilder.append(" " + key + " =\"" + xmlValue + "\"");
        });
        xmlBuilder.append(">");
        if (isXml) {
            xmlBuilder.append(dynamicSqlBody);
        } else {
            xmlBuilder.append("<![CDATA[ " + dynamicSqlBody + " ]]>");
        }
        xmlBuilder.append("</" + queryType.getXmlTag() + ">");
        logger.trace("createDynamicSql xml is --> " + xmlBuilder);
        return this.xmlDynamicResolve.parseSqlConfig(xmlBuilder.toString());
    }

    @Override
    public DynamicSql parseSqlConfig(Method dalMethod) {
        Objects.requireNonNull(dalMethod, "dalMethod is null.");
        Class<?> returnType = dalMethod.getReturnType();
        String parameterType = null;
        if (dalMethod.getParameterCount() == 1) {
            parameterType = dalMethod.getParameterTypes()[0].getName();
        }
        for (Annotation anno : dalMethod.getAnnotations()) {
            if (!ClassDynamicResolve.matchAnnotation(anno)) continue;
            try {
                return this.createDynamicSql(anno, returnType, parameterType);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw ExceptionUtils.toRuntime((Throwable)e);
            }
        }
        return null;
    }
}

