/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.session;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.dbvisitor.dal.mapper.BaseMapper;
import net.hasor.dbvisitor.dal.session.DalSession;
import net.hasor.dbvisitor.dal.session.RuntimeSQLException;
import net.hasor.dbvisitor.lambda.EntityDeleteOperation;
import net.hasor.dbvisitor.lambda.EntityQueryOperation;
import net.hasor.dbvisitor.lambda.EntityUpdateOperation;
import net.hasor.dbvisitor.lambda.InsertOperation;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.page.Page;
import net.hasor.dbvisitor.page.PageObject;
import net.hasor.dbvisitor.page.PageResult;

class BaseMapperHandler
implements BaseMapper<Object> {
    private final String space;
    private final Class<Object> entityType;
    private final DalSession dalSession;
    private final TableMapping<Object> tableMapping;

    public BaseMapperHandler(String space, Class<?> entityType, DalSession dalSession) {
        this.space = space;
        this.entityType = entityType;
        this.dalSession = dalSession;
        this.tableMapping = dalSession.getDalRegistry().findMapping(space, this.entityType);
        Objects.requireNonNull(this.tableMapping, "entityType '" + entityType + "' undefined.");
    }

    @Override
    public Class<Object> entityType() {
        return this.entityType;
    }

    @Override
    public LambdaTemplate template() {
        return this.dalSession.newTemplate(this.space);
    }

    @Override
    public DalSession getSession() {
        return this.dalSession;
    }

    private TableMapping<Object> getMapping() {
        return this.tableMapping;
    }

    protected List<ColumnMapping> foundPrimaryKey() {
        TableMapping<Object> tableMapping = this.getMapping();
        return tableMapping.getProperties().stream().filter(ColumnMapping::isPrimaryKey).collect(Collectors.toList());
    }

    @Override
    public int updateById(Object entity) throws RuntimeSQLException {
        if (entity == null) {
            throw new NullPointerException("entity is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityUpdateOperation<Object> update = this.update();
        for (ColumnMapping pk : pks) {
            Object o = pk.getHandler().get(entity);
            if (o == null) {
                ((EntityUpdateOperation)update.and()).isNull(pk.getProperty());
                continue;
            }
            ((EntityUpdateOperation)update.and()).eq(pk.getProperty(), o);
        }
        try {
            TableMapping<Object> tableMapping = this.getMapping();
            return ((EntityUpdateOperation)update.updateToSampleCondition(entity, property -> !tableMapping.getPropertyByName((String)property).isPrimaryKey())).doUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int upsertById(Object entity) throws RuntimeSQLException {
        if (entity == null) {
            throw new NullPointerException("entity is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityQueryOperation query = this.query();
        EntityUpdateOperation<Object> update = this.update();
        for (ColumnMapping pk : pks) {
            Object o = pk.getHandler().get(entity);
            if (o == null) {
                ((EntityQueryOperation)query.and()).isNull(pk.getProperty());
                ((EntityUpdateOperation)update.and()).isNull(pk.getProperty());
                continue;
            }
            ((EntityQueryOperation)query.and()).eq(pk.getProperty(), o);
            ((EntityUpdateOperation)update.and()).eq(pk.getProperty(), o);
        }
        try {
            if (query.queryForCount() == 0) {
                return ((InsertOperation)this.insert().applyEntity(entity)).executeSumResult();
            }
            TableMapping<Object> tableMapping = this.getMapping();
            return ((EntityUpdateOperation)update.updateToSampleCondition(entity, property -> !tableMapping.getPropertyByName((String)property).isPrimaryKey())).doUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int updateByMap(Map<String, Object> map) throws RuntimeSQLException {
        if (map == null) {
            throw new NullPointerException("map is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityUpdateOperation update = this.update();
        boolean isPrimaryKeyEmpty = true;
        for (ColumnMapping pk : pks) {
            String key = pk.getProperty();
            Object o = map.get(key);
            if (o == null) {
                ((EntityUpdateOperation)update.and()).isNull(key);
            } else {
                ((EntityUpdateOperation)update.and()).eq(key, o);
            }
            map.remove(key);
            isPrimaryKeyEmpty = false;
        }
        if (isPrimaryKeyEmpty) {
            throw new NullPointerException("primary key is empty.");
        }
        if (map.size() == 0) {
            throw new NullPointerException("map is empty.");
        }
        try {
            TableMapping<Object> tableMapping = this.getMapping();
            return ((EntityUpdateOperation)update.updateToMapCondition(map, property -> !tableMapping.getPropertyByName((String)property).isPrimaryKey())).doUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int delete(Object entity) throws RuntimeSQLException {
        if (entity == null) {
            throw new NullPointerException("entity is null.");
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityDeleteOperation delete = this.delete();
        for (ColumnMapping pk : pks) {
            Object o = pk.getHandler().get(entity);
            if (o == null) {
                ((EntityDeleteOperation)delete.and()).isNull(pk.getProperty());
                continue;
            }
            ((EntityDeleteOperation)delete.and()).eq(pk.getProperty(), o);
        }
        try {
            return delete.doDelete();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int deleteById(Serializable id) throws RuntimeSQLException {
        if (id == null) {
            return 0;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityDeleteOperation delete = this.delete();
        if (pks.size() == 1) {
            ((EntityDeleteOperation)delete.and()).eq(pks.get(0).getProperty(), (Object)id);
        } else {
            for (ColumnMapping pk : pks) {
                Object o = pk.getHandler().get((Object)id);
                if (o == null) {
                    ((EntityDeleteOperation)delete.and()).isNull(pk.getProperty());
                    continue;
                }
                ((EntityDeleteOperation)delete.and()).eq(pk.getProperty(), o);
            }
        }
        try {
            return delete.doDelete();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int deleteByIds(List<? extends Serializable> idList) throws RuntimeSQLException {
        if (idList == null || idList.isEmpty()) {
            return 0;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        if (pks.size() == 1) {
            try {
                return ((EntityDeleteOperation)((EntityDeleteOperation)this.delete().and()).in(pks.get(0).getProperty(), (Collection<?>)idList)).doDelete();
            }
            catch (SQLException e) {
                throw new RuntimeSQLException(e);
            }
        }
        EntityDeleteOperation delete = this.delete();
        for (Serializable serializable : idList) {
            delete.or(queryCompare -> {
                for (ColumnMapping pkColumn : pks) {
                    Object keyValue = pkColumn.getHandler().get(obj);
                    if (keyValue == null) {
                        ((EntityDeleteOperation)queryCompare.and()).isNull(pkColumn.getProperty());
                        continue;
                    }
                    ((EntityDeleteOperation)queryCompare.and()).eq(pkColumn.getProperty(), keyValue);
                }
            });
        }
        try {
            return delete.doDelete();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public Object selectById(Serializable id) throws RuntimeSQLException {
        if (id == null) {
            return null;
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        EntityQueryOperation query = this.query();
        if (pks.size() == 1) {
            ((EntityQueryOperation)query.and()).eq(pks.get(0).getProperty(), (Object)id);
        } else {
            for (ColumnMapping pk : pks) {
                Object o = pk.getHandler().get((Object)id);
                if (o == null) {
                    ((EntityQueryOperation)query.and()).isNull(pk.getProperty());
                    continue;
                }
                ((EntityQueryOperation)query.and()).eq(pk.getProperty(), o);
            }
        }
        try {
            return query.queryForObject();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public List<Object> selectByIds(List<? extends Serializable> idList) throws RuntimeSQLException {
        if (idList == null || idList.isEmpty()) {
            return Collections.emptyList();
        }
        List<ColumnMapping> pks = this.foundPrimaryKey();
        if (pks.isEmpty()) {
            throw new RuntimeSQLException(this.entityType() + " no primary key is identified");
        }
        if (pks.size() == 1) {
            try {
                return ((EntityQueryOperation)((EntityQueryOperation)this.query().and()).in(pks.get(0).getProperty(), (Collection<?>)idList)).queryForList();
            }
            catch (SQLException e) {
                throw new RuntimeSQLException(e);
            }
        }
        EntityQueryOperation query = this.query();
        for (Serializable serializable : idList) {
            query.or(queryCompare -> {
                for (ColumnMapping pkColumn : pks) {
                    Object keyValue = pkColumn.getHandler().get(obj);
                    if (keyValue == null) {
                        ((EntityQueryOperation)queryCompare.and()).isNull(pkColumn.getProperty());
                        continue;
                    }
                    ((EntityQueryOperation)queryCompare.and()).eq(pkColumn.getProperty(), keyValue);
                }
            });
        }
        try {
            return query.queryForList();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    protected EntityQueryOperation<Object> buildQueryBySample(Object sample) {
        EntityQueryOperation<Object> query = this.query();
        if (sample != null) {
            for (ColumnMapping mapping : this.getMapping().getProperties()) {
                Object value = mapping.getHandler().get(sample);
                if (value == null) continue;
                ((EntityQueryOperation)query.and()).eq(mapping.getProperty(), value);
            }
        }
        return query;
    }

    @Override
    public List<Object> listBySample(Object sample) throws RuntimeSQLException {
        try {
            return this.buildQueryBySample(sample).queryForList();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int countBySample(Object sample) throws RuntimeSQLException {
        try {
            return this.buildQueryBySample(sample).queryForCount();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public int countAll() throws RuntimeSQLException {
        try {
            return this.query().queryForCount();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public PageResult<Object> pageBySample(Object sample, Page page) throws RuntimeSQLException {
        try {
            List result = ((EntityQueryOperation)this.buildQueryBySample(sample).usePage(page)).queryForList();
            return new PageResult<Object>(page, result);
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    @Override
    public Page initPageBySample(Object sample, int pageSize, int pageNumberOffset) throws RuntimeSQLException {
        int totalCount = this.countBySample(sample);
        PageObject pageObject = new PageObject(pageSize, totalCount);
        pageObject.setPageNumberOffset(pageNumberOffset);
        return pageObject;
    }
}

