/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.session;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RuntimeSQLException
extends RuntimeException
implements Iterable<Throwable> {
    protected SQLException getSQLException() {
        return (SQLException)this.getCause();
    }

    public RuntimeSQLException(SQLException e) {
        super(e);
    }

    public RuntimeSQLException(String s) {
        super(new SQLException(s));
    }

    public String getSQLState() {
        return this.getSQLException().getSQLState();
    }

    public int getErrorCode() {
        return this.getSQLException().getErrorCode();
    }

    @Override
    public Iterator<Throwable> iterator() {
        return new Iterator<Throwable>(){
            SQLException firstException;
            SQLException nextException;
            Throwable cause;
            {
                this.firstException = RuntimeSQLException.this.getSQLException();
                this.nextException = this.firstException.getNextException();
                this.cause = this.firstException.getCause();
            }

            @Override
            public boolean hasNext() {
                return this.firstException != null || this.nextException != null || this.cause != null;
            }

            @Override
            public Throwable next() {
                Throwable throwable = null;
                if (this.firstException != null) {
                    throwable = this.firstException;
                    this.firstException = null;
                } else if (this.cause != null) {
                    throwable = this.cause;
                    this.cause = this.cause.getCause();
                } else if (this.nextException != null) {
                    throwable = this.nextException;
                    this.cause = this.nextException.getCause();
                    this.nextException = this.nextException.getNextException();
                } else {
                    throw new NoSuchElementException();
                }
                return throwable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

