/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect;

import java.util.Map;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.dialect.DefaultSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.dialect.provider.Db2Dialect;
import net.hasor.dbvisitor.dialect.provider.DerbyDialect;
import net.hasor.dbvisitor.dialect.provider.DmDialect;
import net.hasor.dbvisitor.dialect.provider.H2Dialect;
import net.hasor.dbvisitor.dialect.provider.HSQLDialect;
import net.hasor.dbvisitor.dialect.provider.HiveDialect;
import net.hasor.dbvisitor.dialect.provider.ImpalaDialect;
import net.hasor.dbvisitor.dialect.provider.InformixDialect;
import net.hasor.dbvisitor.dialect.provider.MySqlDialect;
import net.hasor.dbvisitor.dialect.provider.OracleDialect;
import net.hasor.dbvisitor.dialect.provider.PostgreSqlDialect;
import net.hasor.dbvisitor.dialect.provider.SqlLiteDialect;
import net.hasor.dbvisitor.dialect.provider.SqlServerDialect;
import net.hasor.dbvisitor.dialect.provider.XuGuDialect;

public class SqlDialectRegister {
    private static final Map<String, Class<?>> dialectAliasMap = new LinkedCaseInsensitiveMap();
    private static final Map<String, SqlDialect> dialectCache = new LinkedCaseInsensitiveMap();

    public static void clearDialectCache() {
        dialectCache.clear();
    }

    public static void registerDialectAlias(String dialectName, Class<? extends SqlDialect> dialectClass) {
        dialectAliasMap.put(dialectName, dialectClass);
        dialectAliasMap.put(dialectClass.getName(), dialectClass);
    }

    public static SqlDialect findOrCreate(String dialectName) {
        return SqlDialectRegister.findOrCreate(dialectName, null);
    }

    public static SqlDialect findOrCreate(String dialectName, ClassLoader loader) {
        if (StringUtils.isBlank((String)dialectName)) {
            return DefaultSqlDialect.DEFAULT;
        }
        SqlDialect dialect = dialectCache.get(dialectName);
        if (dialect != null) {
            return dialect;
        }
        loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        String lastMessage = null;
        Class aClass = dialectAliasMap.get(dialectName);
        if (aClass == null) {
            try {
                aClass = ResourcesUtils.classForName((ClassLoader)loader, (String)dialectName);
            }
            catch (ClassNotFoundException e) {
                lastMessage = "load dialect '" + dialectName + "' class not found";
            }
        }
        if (aClass != null) {
            try {
                dialect = (SqlDialect)aClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("load dialect '" + aClass.getName() + "' failed, " + e.getMessage(), e);
            }
        } else {
            if (StringUtils.isNotBlank(lastMessage)) {
                throw new IllegalStateException(lastMessage);
            }
            throw new IllegalStateException("no dialect '" + dialectName + "' found.");
        }
        dialectCache.put(dialectName, dialect);
        return dialect;
    }

    static {
        SqlDialectRegister.registerDialectAlias("db2", Db2Dialect.class);
        SqlDialectRegister.registerDialectAlias("derby", DerbyDialect.class);
        SqlDialectRegister.registerDialectAlias("dm", DmDialect.class);
        SqlDialectRegister.registerDialectAlias("h2", H2Dialect.class);
        SqlDialectRegister.registerDialectAlias("hive", HiveDialect.class);
        SqlDialectRegister.registerDialectAlias("hsql", HSQLDialect.class);
        SqlDialectRegister.registerDialectAlias("impala", ImpalaDialect.class);
        SqlDialectRegister.registerDialectAlias("informix", InformixDialect.class);
        SqlDialectRegister.registerDialectAlias("kingbase", PostgreSqlDialect.class);
        SqlDialectRegister.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        SqlDialectRegister.registerDialectAlias("mariadb", MySqlDialect.class);
        SqlDialectRegister.registerDialectAlias("mysql", MySqlDialect.class);
        SqlDialectRegister.registerDialectAlias("oracle", OracleDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlite", SqlLiteDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlserver", SqlServerDialect.class);
        SqlDialectRegister.registerDialectAlias("jtds", SqlServerDialect.class);
        SqlDialectRegister.registerDialectAlias("xugu", XuGuDialect.class);
    }
}

