/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.SeqSqlDialect;
import net.hasor.dbvisitor.dialect.provider.AbstractDialect;

public class H2Dialect
extends AbstractDialect
implements PageSqlDialect,
SeqSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/h2.keywords";
    }

    @Override
    protected String defaultQualifier() {
        return "\"";
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, long start, long limit) {
        StringBuilder sqlBuilder = new StringBuilder(boundSql.getSqlString());
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (limit > 0L) {
            sqlBuilder.append(" LIMIT ?");
            paramArrays.add(limit);
        }
        if (start > 0L) {
            sqlBuilder.append(" OFFSET ?");
            paramArrays.add(start);
        }
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public String selectSeq(boolean useQualifier, String catalog, String schema, String seqName) {
        StringBuilder sqlBuilder = new StringBuilder("values next value for ");
        if (StringUtils.isNotBlank((String)schema)) {
            sqlBuilder.append(this.fmtName(useQualifier, schema)).append(".");
        }
        sqlBuilder.append(this.fmtName(useQualifier, seqName));
        return sqlBuilder.toString();
    }
}

