/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.InsertSqlDialect;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.provider.AbstractDialect;

public class PostgreSqlDialect
extends AbstractDialect
implements PageSqlDialect,
InsertSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/postgresql.keywords";
    }

    @Override
    protected String defaultQualifier() {
        return "\"";
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, long start, long limit) {
        StringBuilder sqlBuilder = new StringBuilder(boundSql.getSqlString());
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (limit > 0L) {
            sqlBuilder.append(" LIMIT ?");
            paramArrays.add(limit);
        }
        if (start > 0L) {
            sqlBuilder.append(" OFFSET ?");
            paramArrays.add(start);
        }
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public boolean supportInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertInto(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        return this.buildSql("INSERT INTO ", useQualifier, catalog, schema, table, columns, columnValueTerms, "");
    }

    @Override
    public boolean supportIgnore(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertIgnore(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        return this.buildSql("INSERT IGNORE ", useQualifier, catalog, schema, table, columns, columnValueTerms, " ON CONFLICT DO NOTHING");
    }

    @Override
    public boolean supportReplace(List<String> primaryKey, List<String> columns) {
        return !primaryKey.isEmpty();
    }

    @Override
    public String insertReplace(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        StringBuilder strBuffer = new StringBuilder(" ON CONFLICT (");
        boolean first = true;
        for (String pk : primaryKey) {
            if (!first) {
                strBuffer.append(", ");
            }
            strBuffer.append(this.fmtName(useQualifier, pk));
            first = false;
        }
        strBuffer.append(") DO UPDATE SET ");
        StringBuilder namesBuffer = new StringBuilder();
        StringBuilder updateBuffer = new StringBuilder();
        first = true;
        for (String col : columns) {
            if (!first) {
                strBuffer.append(", ");
            }
            String wrapName = this.fmtName(useQualifier, col);
            namesBuffer.append(wrapName);
            updateBuffer.append("EXCLUDED.").append(wrapName);
            first = false;
        }
        strBuffer.append("(" + namesBuffer + ") = (" + updateBuffer + ")");
        return this.buildSql("INSERT INTO ", useQualifier, catalog, schema, table, columns, columnValueTerms, strBuffer.toString());
    }

    protected String buildSql(String markString, boolean useQualifier, String catalog, String schema, String table, List<String> columns, Map<String, String> columnValueTerms, String appendSql) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(markString);
        strBuilder.append(this.tableName(useQualifier, catalog, schema, table));
        strBuilder.append(" ");
        strBuilder.append("(");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            String valueTerm;
            String colName = columns.get(i);
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.fmtName(useQualifier, colName));
            String string = valueTerm = columnValueTerms != null ? columnValueTerms.get(colName) : null;
            if (StringUtils.isNotBlank((String)valueTerm)) {
                argBuilder.append(valueTerm);
                continue;
            }
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        strBuilder.append(appendSql);
        return strBuilder.toString();
    }

    @Override
    public String randomQuery(boolean useQualifier, String catalog, String schema, String table, List<String> selectColumns, Map<String, String> columnTerms, int recordSize) {
        String tableName = this.tableName(useQualifier, catalog, schema, table);
        StringBuilder select = new StringBuilder();
        if (selectColumns == null || selectColumns.isEmpty()) {
            select.append("*");
        } else {
            for (String col : selectColumns) {
                String valueTerm;
                if (select.length() > 0) {
                    select.append(", ");
                }
                String string = valueTerm = columnTerms != null ? columnTerms.get(col) : null;
                if (StringUtils.isNotBlank((String)valueTerm)) {
                    select.append(valueTerm);
                    continue;
                }
                select.append(this.fmtName(useQualifier, col));
            }
        }
        return "select " + select + " from " + tableName + " order by random() limit " + recordSize;
    }
}

