/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.hasor.dbvisitor.jdbc.PreparedStatementSetter;
import net.hasor.dbvisitor.jdbc.SqlParameter;
import net.hasor.dbvisitor.jdbc.core.ParameterDisposer;
import net.hasor.dbvisitor.jdbc.core.StatementSetterUtils;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class ArgPreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] args) {
        this(args, TypeHandlerRegistry.DEFAULT);
    }

    public ArgPreparedStatementSetter(Object[] args, TypeHandlerRegistry typeHandlerRegistry) {
        this.typeHandlerRegistry = typeHandlerRegistry;
        this.args = args;
    }

    public TypeHandlerRegistry getTypeHandlerRegistry() {
        return this.typeHandlerRegistry;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                this.doSetValue(ps, i + 1, arg);
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
        if (argValue instanceof SqlParameter.InSqlParameter) {
            Object value = ((SqlParameter.InSqlParameter)argValue).getValue();
            Integer jdbcType = ((SqlParameter.InSqlParameter)argValue).getJdbcType();
            TypeHandler<?> typeHandler = ((SqlParameter.InSqlParameter)argValue).getTypeHandler();
            if (typeHandler != null && jdbcType != null) {
                typeHandler.setParameter(ps, parameterPosition, value, jdbcType);
                return;
            }
            if (typeHandler != null) {
                if (value == null) {
                    ps.setObject(parameterPosition, null);
                } else {
                    typeHandler.setParameter(ps, parameterPosition, value, TypeHandlerRegistry.toSqlType(value.getClass()));
                }
                return;
            }
            argValue = value;
        }
        this.typeHandlerRegistry.setParameterValue(ps, parameterPosition, argValue);
    }

    @Override
    public void cleanupParameters() {
        StatementSetterUtils.cleanupParameters(this.args);
    }
}

