/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.hasor.dbvisitor.jars.OgnlUtils;
import net.hasor.dbvisitor.jdbc.SqlParameter;
import net.hasor.dbvisitor.jdbc.SqlParameterSource;

public class ParsedSql {
    private final String originalSql;
    private int namedParameterCount;
    private int unnamedParameterCount;
    private int totalParameterCount;
    private List<String> parameterNames;
    private List<int[]> parameterIndexes;
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    private ParsedSql(String originalSql) {
        this.originalSql = originalSql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public int getNamedParameterCount() {
        return this.namedParameterCount;
    }

    public int getUnnamedParameterCount() {
        return this.unnamedParameterCount;
    }

    public int getTotalParameterCount() {
        return this.totalParameterCount;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public List<int[]> getParameterIndexes() {
        return this.parameterIndexes;
    }

    public String buildSql() {
        return this.buildSql(null);
    }

    public String buildSql(SqlParameterSource paramSource) {
        String originalSql = this.getOriginalSql();
        List<String> parameterNames = this.getParameterNames();
        List<int[]> parameterIndexes = this.getParameterIndexes();
        StringBuilder sqlToUse = new StringBuilder();
        int lastIndex = 0;
        for (int i = 0; i < parameterNames.size(); ++i) {
            int[] indexes = parameterIndexes.get(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            sqlToUse.append(originalSql, lastIndex, startIndex);
            if (paramSource != null) {
                String paramName = parameterNames.get(i);
                Object value = paramSource.getValue(paramName);
                if (this.namedParameterCount > 0) {
                    if (value == null && paramName.contains(".") && !paramName.contains("#") && !paramName.contains("@")) {
                        value = OgnlUtils.evalOgnl(paramName, paramSource.toMap());
                    }
                    if (value instanceof SqlParameter.InSqlParameter) {
                        value = ((SqlParameter.InSqlParameter)value).getValue();
                    }
                    if (value != null && value.getClass().isArray()) {
                        value = Arrays.asList((Object[])value);
                    }
                    if (value instanceof Iterable) {
                        Iterator entryIter = ((Iterable)value).iterator();
                        int k = 0;
                        while (entryIter.hasNext()) {
                            if (k > 0) {
                                sqlToUse.append(", ");
                            }
                            ++k;
                            sqlToUse.append("?");
                            entryIter.next();
                        }
                    } else {
                        sqlToUse.append("?");
                    }
                } else {
                    sqlToUse.append("?");
                }
            } else {
                sqlToUse.append("?");
            }
            lastIndex = endIndex;
        }
        sqlToUse.append(originalSql.substring(lastIndex));
        return sqlToUse.toString();
    }

    public Object[] buildValues(SqlParameterSource paramSource) throws SQLException {
        String originalSql = this.getOriginalSql();
        List<String> parameterNames = this.getParameterNames();
        int namedParameterCount = this.getNamedParameterCount();
        int unnamedParameterCount = this.getUnnamedParameterCount();
        int totalParameterCount = this.getTotalParameterCount();
        ArrayList<Object> paramArray = new ArrayList<Object>(totalParameterCount);
        if (namedParameterCount > 0 && unnamedParameterCount > 0) {
            throw new SQLException("You can't mix named and traditional ? placeholders. You have " + namedParameterCount + " named parameter(s) and " + unnamedParameterCount + " traditonal placeholder(s) in [" + originalSql + "]");
        }
        for (String paramName : parameterNames) {
            List<Object> value = paramSource.getValue(paramName);
            if (value == null && paramName.contains(".")) {
                if (paramName.contains("#") || paramName.contains("@")) {
                    throw new SQLException("expr string cannot include '#' or '@', paramExpr= " + paramName);
                }
                value = OgnlUtils.evalOgnl(paramName, paramSource.toMap());
            }
            if (value instanceof SqlParameter.InSqlParameter) {
                value = ((SqlParameter.InSqlParameter)((Object)value)).getValue();
            }
            if (value != null && value.getClass().isArray()) {
                value = Arrays.asList((Object[])value);
            }
            if (value instanceof Iterable) {
                for (Object o : (Iterable)value) {
                    paramArray.add(o);
                }
                continue;
            }
            paramArray.add(value);
        }
        return paramArray.toArray();
    }

    public static ParsedSql getParsedSql(String originalSql) {
        ParsedSql parSQL = new ParsedSql(originalSql);
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<int[]> parameterIndexes = new ArrayList<int[]>();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        Objects.requireNonNull(originalSql, "SQL must not be null");
        HashSet<String> namedParameters = new HashSet<String>();
        char[] statement = originalSql.toCharArray();
        int i = 0;
        while (i < statement.length) {
            char c;
            int skipToPosition = ParsedSql.skipCommentsAndQuotes(statement, i);
            if (i != skipToPosition) {
                if (skipToPosition >= statement.length) break;
                i = skipToPosition;
            }
            if ((c = statement[i]) == ':' || c == '&') {
                int j = i + 1;
                if (j < statement.length && statement[j] == ':' && c == ':') {
                    i += 2;
                    continue;
                }
                while (j < statement.length && !ParsedSql.isParameterSeparator(statement[j])) {
                    ++j;
                }
                if (j - i > 1) {
                    String parameter = originalSql.substring(i + 1, j);
                    if (!namedParameters.contains(parameter)) {
                        namedParameters.add(parameter);
                        ++namedParameterCount;
                    }
                    parameterNames.add(parameter);
                    parameterIndexes.add(new int[]{i, j});
                    ++totalParameterCount;
                }
                i = j - 1;
            } else if (c == '?') {
                ++unnamedParameterCount;
                ++totalParameterCount;
            }
            ++i;
        }
        parSQL.namedParameterCount = namedParameterCount;
        parSQL.unnamedParameterCount = unnamedParameterCount;
        parSQL.totalParameterCount = totalParameterCount;
        parSQL.parameterIndexes = parameterIndexes;
        parSQL.parameterNames = parameterNames;
        return parSQL;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }
}

