/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.extractor;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.dbvisitor.jdbc.CallableStatementCallback;
import net.hasor.dbvisitor.jdbc.PreparedStatementCallback;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.jdbc.extractor.MultipleProcessType;
import net.hasor.dbvisitor.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.dbvisitor.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class MultipleResultSetExtractor
implements PreparedStatementCallback<List<Object>>,
CallableStatementCallback<List<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MultipleResultSetExtractor.class);
    private final List<RowMapper<?>> rowMappers;
    private MultipleProcessType processType = MultipleProcessType.ALL;

    public MultipleResultSetExtractor(RowMapper<?> ... rowMapper) {
        this.rowMappers = Arrays.asList(rowMapper);
    }

    public MultipleResultSetExtractor(MultipleProcessType processType, RowMapper<?> ... rowMapper) {
        this.processType = processType;
        this.rowMappers = Arrays.asList(rowMapper);
    }

    @Override
    public List<Object> doInCallableStatement(CallableStatement cs) throws SQLException {
        boolean retVal = cs.execute();
        return this.doResult(retVal, cs);
    }

    @Override
    public List<Object> doInPreparedStatement(PreparedStatement ps) throws SQLException {
        boolean retVal = ps.execute();
        return this.doResult(retVal, ps);
    }

    public List<Object> doResult(boolean retVal, Statement stmt) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("statement.execute() returned '" + retVal + "'");
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (retVal) {
            try (ResultSet resultSet = stmt.getResultSet();){
                RowMapper<?> rowMapper = this.rowMappers.isEmpty() ? this.getDefaultRowMapper() : this.rowMappers.get(0);
                resultList.add(this.processResultSet(resultSet, rowMapper));
            }
        } else {
            resultList.add(stmt.getUpdateCount());
        }
        if (this.processType == MultipleProcessType.FIRST) {
            return resultList;
        }
        int resultIndex = 1;
        while (stmt.getMoreResults() || stmt.getUpdateCount() != -1) {
            int updateCount = stmt.getUpdateCount();
            Object last = null;
            try (ResultSet resultSet = stmt.getResultSet();){
                last = resultSet != null ? (this.rowMappers.size() > resultIndex ? this.processResultSet(resultSet, this.rowMappers.get(resultIndex++)) : this.processResultSet(resultSet, this.getDefaultRowMapper())) : Integer.valueOf(updateCount);
            }
            if (this.processType == MultipleProcessType.LAST) {
                resultList.set(0, last);
                continue;
            }
            resultList.add(last);
        }
        return resultList;
    }

    protected RowMapper<?> getDefaultRowMapper() {
        return new ColumnMapRowMapper(true, TypeHandlerRegistry.DEFAULT);
    }

    protected Object processResultSet(ResultSet rs, RowMapper<?> rowMapper) throws SQLException {
        if (rs == null) {
            return null;
        }
        return this.createSetExtractor(rowMapper).extractData(rs);
    }

    protected RowMapperResultSetExtractor<?> createSetExtractor(RowMapper<?> rowMapper) {
        return new RowMapperResultSetExtractor(rowMapper);
    }
}

