/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.function.ESupplier;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.jdbc.RowCallbackHandler;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.jdbc.mapper.MappingResultSetExtractor;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.BasicQueryCompare;
import net.hasor.dbvisitor.lambda.core.PageObjectForLambda;
import net.hasor.dbvisitor.lambda.core.QueryFunc;
import net.hasor.dbvisitor.lambda.segment.MergeSqlSegment;
import net.hasor.dbvisitor.lambda.segment.OrderByKeyword;
import net.hasor.dbvisitor.lambda.segment.Segment;
import net.hasor.dbvisitor.lambda.segment.SqlKeyword;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.page.Page;

public abstract class AbstractSelectLambda<R, T, P>
extends BasicQueryCompare<R, T, P>
implements QueryFunc<R, T, P> {
    protected final MergeSqlSegment customSelect = new MergeSqlSegment(new Segment[0]);
    protected final MergeSqlSegment groupByList = new MergeSqlSegment(new Segment[0]);
    protected final MergeSqlSegment orderByList = new MergeSqlSegment(new Segment[0]);
    private final Page pageInfo = new PageObjectForLambda(0L, (ESupplier<Long, SQLException>)((ESupplier)this::queryForLargeCount));
    private boolean lockGroupBy = false;
    private boolean lockOrderBy = false;

    public AbstractSelectLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    public R selectAll() {
        this.customSelect.cleanSegment();
        return this.getSelf();
    }

    @Override
    public final R select(P ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IndexOutOfBoundsException("properties is empty.");
        }
        this.customSelect.cleanSegment();
        for (P property : properties) {
            if (!this.customSelect.isEmpty()) {
                this.customSelect.addSegment(() -> ",");
            }
            this.customSelect.addSegment(this.buildSelectByProperty(this.getPropertyName(property)));
        }
        return this.getSelf();
    }

    @Override
    public R applySelect(String select) {
        this.customSelect.cleanSegment();
        this.customSelect.addSegment(() -> select);
        return this.getSelf();
    }

    protected void lockGroupBy() {
        this.lockGroupBy = true;
    }

    @Override
    public final R groupBy(P ... groupBy) {
        if (this.lockGroupBy) {
            throw new IllegalStateException("must before order by invoke it.");
        }
        this.lockCondition();
        if (groupBy != null && groupBy.length > 0) {
            if (this.groupByList.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.GROUP_BY);
                this.queryTemplate.addSegment(this.groupByList);
            }
            for (P property : groupBy) {
                if (!this.groupByList.isEmpty()) {
                    this.groupByList.addSegment(() -> ",");
                }
                this.groupByList.addSegment(this.buildGroupOrderByProperty(this.getPropertyName(property)));
            }
        }
        return this.getSelf();
    }

    @Override
    public R orderBy(P ... orderBy) {
        return this.addOrderBy(OrderByKeyword.ORDER_DEFAULT, orderBy);
    }

    @Override
    public R asc(P ... orderBy) {
        return this.addOrderBy(OrderByKeyword.ASC, orderBy);
    }

    @Override
    public R desc(P ... orderBy) {
        return this.addOrderBy(OrderByKeyword.DESC, orderBy);
    }

    protected void lockOrderBy() {
        this.lockGroupBy = true;
    }

    private R addOrderBy(OrderByKeyword keyword, P ... orderBy) {
        if (this.lockOrderBy) {
            throw new IllegalStateException("must before order by invoke it.");
        }
        this.lockCondition();
        this.lockGroupBy();
        if (orderBy != null && orderBy.length > 0) {
            if (this.orderByList.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.ORDER_BY);
                this.queryTemplate.addSegment(this.orderByList);
            }
            for (P property : orderBy) {
                if (!this.orderByList.isEmpty()) {
                    this.orderByList.addSegment(() -> ",");
                }
                this.orderByList.addSegment(this.buildGroupOrderByProperty(this.getPropertyName(property)), keyword);
            }
        }
        return this.getSelf();
    }

    @Override
    public R usePage(Page pageInfo) {
        Page page = this.pageInfo();
        page.setPageSize(pageInfo.getPageSize());
        page.setTotalCount(pageInfo.getTotalCount());
        page.setCurrentPage(pageInfo.getCurrentPage());
        page.setPageNumberOffset(pageInfo.getPageNumberOffset());
        return this.getSelf();
    }

    @Override
    public Page pageInfo() {
        return this.pageInfo;
    }

    @Override
    public R initPage(int pageSize, int pageNumber) {
        Page pageInfo = this.pageInfo();
        pageInfo.setPageNumberOffset(0L);
        pageInfo.setPageSize(pageSize);
        pageInfo.setCurrentPage(pageNumber);
        return this.getSelf();
    }

    @Override
    public void query(RowCallbackHandler rch) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rch);
    }

    @Override
    public <V> V query(ResultSetExtractor<V> rse) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rse);
    }

    @Override
    public <V> List<V> query(RowMapper<V> rowMapper) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForList(boundSql.getSqlString(), boundSql.getArgs(), rowMapper);
    }

    @Override
    public List<T> queryForList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        MappingResultSetExtractor<T> extractor = new MappingResultSetExtractor<T>(this.getTableReader());
        return (List)this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), extractor);
    }

    @Override
    public List<Map<String, Object>> queryForMapList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        MappingResultSetExtractor<Map<String, Object>> extractor = new MappingResultSetExtractor<Map<String, Object>>(this.getTableMapping().toMapReader());
        return (List)((Object)this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), extractor));
    }

    @Override
    public Map<String, Object> queryForMap() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        TableReader<Map<String, Object>> mapReader = this.getTableMapping().toMapReader();
        return this.getJdbcTemplate().queryForObject(boundSql.getSqlString(), boundSql.getArgs(), (rs, rowNum) -> {
            ResultSetMetaData rsmd = rs.getMetaData();
            int nrOfColumns = rsmd.getColumnCount();
            ArrayList<String> columnList = new ArrayList<String>();
            for (int i = 1; i <= nrOfColumns; ++i) {
                String name = rsmd.getColumnLabel(i);
                if (name == null || name.length() < 1) {
                    name = rsmd.getColumnName(i);
                }
                columnList.add(name);
            }
            return (Map)mapReader.extractRow(columnList, rs, rowNum);
        });
    }

    protected abstract TableReader<T> getTableReader();

    @Override
    public T queryForObject() throws SQLException {
        TableReader tableReader = this.getTableReader();
        BoundSql boundSql = this.getBoundSql();
        return (T)this.getJdbcTemplate().queryForObject(boundSql.getSqlString(), boundSql.getArgs(), (rs, rowNum) -> {
            ResultSetMetaData rsmd = rs.getMetaData();
            int nrOfColumns = rsmd.getColumnCount();
            ArrayList<String> columnList = new ArrayList<String>();
            for (int i = 1; i <= nrOfColumns; ++i) {
                String colName = rsmd.getColumnLabel(i);
                if (colName == null || colName.length() < 1) {
                    colName = rsmd.getColumnName(i);
                }
                columnList.add(colName);
            }
            return tableReader.extractRow(columnList, rs, rowNum);
        });
    }

    @Override
    public int queryForCount() throws SQLException {
        BoundSql oriBoundSql = this.buildBoundSqlWithoutPage(this.dialect());
        BoundSql countSql = ((PageSqlDialect)this.dialect()).countSql(oriBoundSql);
        return this.getJdbcTemplate().queryForInt(countSql.getSqlString(), countSql.getArgs());
    }

    @Override
    public long queryForLargeCount() throws SQLException {
        BoundSql oriBoundSql = this.buildBoundSqlWithoutPage(this.dialect());
        BoundSql countSql = ((PageSqlDialect)this.dialect()).countSql(oriBoundSql);
        return this.getJdbcTemplate().queryForLong(countSql.getSqlString(), countSql.getArgs());
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        long pageSize = this.pageInfo().getPageSize();
        if (pageSize > 0L) {
            BoundSql sqlWithoutPage = this.buildBoundSqlWithoutPage(dialect);
            long position = this.pageInfo().getFirstRecordPosition();
            return ((PageSqlDialect)dialect).pageSql(sqlWithoutPage, position, pageSize);
        }
        return this.buildBoundSqlWithoutPage(dialect);
    }

    private BoundSql buildBoundSqlWithoutPage(SqlDialect dialect) {
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        sqlSegment.addSegment(SqlKeyword.SELECT);
        if (this.customSelect.isEmpty()) {
            if (this.groupByList.isEmpty()) {
                sqlSegment.addSegment(() -> "*");
            } else {
                sqlSegment.addSegment(this.groupByList);
            }
        } else {
            sqlSegment.addSegment(this.customSelect);
        }
        sqlSegment.addSegment(SqlKeyword.FROM);
        sqlSegment.addSegment(() -> {
            TableMapping<?> tableMapping = this.getTableMapping();
            String catalogName = tableMapping.getCatalog();
            String schemaName = tableMapping.getSchema();
            String tableName = tableMapping.getTable();
            return dialect.tableName(this.isQualifier(), catalogName, schemaName, tableName);
        });
        if (!this.queryTemplate.isEmpty()) {
            Segment firstSqlSegment = this.queryTemplate.firstSqlSegment();
            if (firstSqlSegment == SqlKeyword.GROUP_BY || firstSqlSegment == SqlKeyword.HAVING || firstSqlSegment == SqlKeyword.ORDER_BY) {
                sqlSegment.addSegment(this.queryTemplate);
            } else {
                sqlSegment.addSegment(SqlKeyword.WHERE);
                sqlSegment.addSegment(this.queryTemplate.sub(1));
            }
        }
        String sqlQuery = sqlSegment.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }

    @Override
    public <D> Iterator<D> queryForIterator(long limit, int batchSize, Function<T, D> transform) {
        PageObjectForLambda pageInfo = new PageObjectForLambda((long)batchSize, (ESupplier<Long, SQLException>)((ESupplier)this::queryForLargeCount));
        pageInfo.setCurrentPage(0L);
        pageInfo.setPageNumberOffset(0L);
        return new StreamIterator<D>(limit, pageInfo, this, transform);
    }

    private class StreamIterator<D>
    implements Iterator<D> {
        private final Page pageInfo;
        private final AbstractSelectLambda<R, T, P> lambda;
        private Iterator<T> currentIterator;
        private final Function<T, D> transform;
        private final AtomicLong limitCounter;
        private boolean eof = false;

        public StreamIterator(long limit, Page pageInfo, AbstractSelectLambda<R, T, P> lambda, Function<T, D> transform) {
            this.limitCounter = limit < 0L ? null : new AtomicLong(limit);
            this.pageInfo = pageInfo;
            this.lambda = lambda;
            this.transform = transform;
        }

        private synchronized void fetchData() {
            try {
                this.lambda.usePage(this.pageInfo);
                List queryResult = this.lambda.queryForList();
                if (queryResult == null || queryResult.isEmpty()) {
                    this.eof = true;
                    this.currentIterator = Collections.emptyIterator();
                } else {
                    this.currentIterator = queryResult.iterator();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtils.toRuntime((Throwable)e);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.limitCounter != null && this.limitCounter.get() <= 0L) {
                return false;
            }
            if (this.currentIterator == null) {
                this.fetchData();
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (!this.eof) {
                this.pageInfo.nextPage();
                this.fetchData();
                return this.currentIterator.hasNext();
            }
            return false;
        }

        @Override
        public synchronized D next() {
            if (this.hasNext()) {
                if (this.limitCounter != null) {
                    this.limitCounter.decrementAndGet();
                }
                return this.transform.apply(this.currentIterator.next());
            }
            throw new NoSuchElementException();
        }
    }
}

