/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.support.entity;

import java.util.Collection;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.reflect.SFunction;
import net.hasor.dbvisitor.dialect.ConditionSqlDialect;
import net.hasor.dbvisitor.lambda.EntityQueryOperation;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.AbstractSelectLambda;
import net.hasor.dbvisitor.lambda.segment.SqlKeyword;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;

public class SelectLambdaForEntity<T>
extends AbstractSelectLambda<EntityQueryOperation<T>, T, SFunction<T>>
implements EntityQueryOperation<T> {
    protected TableReader<T> tableReader;

    public SelectLambdaForEntity(Class<T> exampleType, TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
        this.tableReader = tableMapping.toReader();
    }

    @Override
    protected EntityQueryOperation<T> getSelf() {
        return this;
    }

    @Override
    protected String getPropertyName(SFunction<T> property) {
        return BeanUtils.toProperty(property);
    }

    @Override
    protected TableReader<T> getTableReader() {
        return this.tableReader;
    }

    @Override
    public EntityQueryOperation<T> eq(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.EQ, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> ne(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NE, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> gt(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.GT, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> ge(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.GE, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> lt(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.LT, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> le(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.LE, this.formatValue(property, value));
    }

    @Override
    public EntityQueryOperation<T> like(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public EntityQueryOperation<T> notLike(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public EntityQueryOperation<T> likeRight(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public EntityQueryOperation<T> notLikeRight(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public EntityQueryOperation<T> likeLeft(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public EntityQueryOperation<T> notLikeLeft(String property, Object value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(property, ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public EntityQueryOperation<T> isNull(String property) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.IS_NULL);
    }

    @Override
    public EntityQueryOperation<T> isNotNull(String property) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public EntityQueryOperation<T> in(String property, Collection<?> value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(property, value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public EntityQueryOperation<T> notIn(String property, Collection<?> value) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NOT, SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(property, value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public EntityQueryOperation<T> between(String property, Object value1, Object value2) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.BETWEEN, this.formatValue(property, value1), SqlKeyword.AND, this.formatValue(property, value2));
    }

    @Override
    public EntityQueryOperation<T> notBetween(String property, Object value1, Object value2) {
        return (EntityQueryOperation)this.addCondition(this.buildConditionByProperty(property), SqlKeyword.NOT, SqlKeyword.BETWEEN, this.formatValue(property, value1), SqlKeyword.AND, this.formatValue(property, value2));
    }
}

